% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meter-provider-noop.R
\name{otel_meter}
\alias{otel_meter}
\title{OpenTelemetry Meter Object}
\value{
Not applicable.
}
\description{
\link{otel_meter_provider} -> \link{otel_meter} -> \link{otel_counter},
\link{otel_up_down_counter}, \link{otel_histogram}, \link{otel_gauge}
}
\details{
Usually you do not need to deal with otel_meter objects directly.
\code{\link[=counter_add]{counter_add()}}, \code{\link[=up_down_counter_add]{up_down_counter_add()}}, \code{\link[=histogram_record]{histogram_record()}} and
\code{\link[=gauge_record]{gauge_record()}} automatically set up the meter and uses it to create
instruments.

A meter object is created by calling the \code{get_meter()} method of an
\link{otel_meter_provider}.

You can use the \code{create_counter()}, \code{create_up_down_counter()},
\code{create_histogram()}, \code{create_gauge()} methods of the meter object to
create instruments.

Typically there is a separate meter object for each instrumented R
package.
}
\section{Methods}{
\subsection{\code{meter$is_enabled()}}{

Whether the meter is active and emitting measurements.

This is equivalent to the \code{\link[=is_measuring_enabled]{is_measuring_enabled()}} function.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{meter$is_enabled()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Logical scalar.
}

}

\subsection{\code{meter$create_counter()}}{

Create a new \href{https://opentelemetry.io/docs/specs/otel/metrics/api/#counter}{counter instrument}.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{create_counter(name, description = NULL, unit = NULL)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: Name of the instrument.
\item \code{description}: Optional description.
\item \code{unit}: Optional measurement unit. If specified, it should use
units from \href{https://ucum.org/}{Unified Code for Units of Measure},
according to the \href{https://opentelemetry.io/docs/specs/semconv/general/metrics/#instrument-units}{OpenTelemetry semantic conventions}.
}
}

\subsection{Value}{

An OpenTelemetry counter (\link{otel_counter}) object.
}

}

\subsection{\code{meter$create_up_down_counter()}}{

Create a new \href{https://opentelemetry.io/docs/specs/otel/metrics/api/#updowncounter}{up-down counter instrument}.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{create_up_down_counter(name, description = NULL, unit = NULL)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: Name of the instrument.
\item \code{description}: Optional description.
\item \code{unit}: Optional measurement unit. If specified, it should use
units from \href{https://ucum.org/}{Unified Code for Units of Measure},
according to the \href{https://opentelemetry.io/docs/specs/semconv/general/metrics/#instrument-units}{OpenTelemetry semantic conventions}.
}
}

\subsection{Value}{

An OpenTelemetry counter (\link{otel_up_down_counter}) object.
}

}

\subsection{\code{meter$create_histogram()}}{

Create a new \href{https://opentelemetry.io/docs/specs/otel/metrics/api/#histogram}{histogram}.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{create_histogram(name, description = NULL, unit = NULL)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: Name of the instrument.
\item \code{description}: Optional description.
\item \code{unit}: Optional measurement unit. If specified, it should use
units from \href{https://ucum.org/}{Unified Code for Units of Measure},
according to the \href{https://opentelemetry.io/docs/specs/semconv/general/metrics/#instrument-units}{OpenTelemetry semantic conventions}.
}
}

\subsection{Value}{

An OpenTelemetry histogram (\link{otel_histogram}) object.
}

}

\subsection{\code{meter$create_gauge()}}{

Create a new \href{https://opentelemetry.io/docs/specs/otel/metrics/api/#gauge}{gauge}.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{create_gauge(name, description = NULL, unit = NULL)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: Name of the instrument.
\item \code{description}: Optional description.
\item \code{unit}: Optional measurement unit. If specified, it should use
units from \href{https://ucum.org/}{Unified Code for Units of Measure},
according to the \href{https://opentelemetry.io/docs/specs/semconv/general/metrics/#instrument-units}{OpenTelemetry semantic conventions}.
}
}

\subsection{Value}{

An OpenTelemetry gauge (\link{otel_gauge}) object.
}

}
}

\examples{
mp <- get_default_meter_provider()
mtr <- mp$get_meter()
ctr <- mtr$create_counter("session")
ctr$add(1)
}
\seealso{
Other low level metrics API: 
\code{\link{get_default_meter_provider}()},
\code{\link{get_meter}()},
\code{\link{meter_provider_noop}},
\code{\link{otel_counter}},
\code{\link{otel_gauge}},
\code{\link{otel_histogram}},
\code{\link{otel_meter_provider}},
\code{\link{otel_up_down_counter}}
}
\concept{low level metrics API}
