% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meter-provider-noop.R
\name{otel_up_down_counter}
\alias{otel_up_down_counter}
\title{OpenTelemetry Up-Down Counter Object}
\value{
Not applicable.
}
\description{
\link{otel_meter_provider} -> \link{otel_meter} -> \link{otel_counter},
\link{otel_up_down_counter}, \link{otel_histogram}, \link{otel_gauge}
}
\details{
Usually you do not need to deal with otel_up_down_counter objects directly.
\code{\link[=up_down_counter_add]{up_down_counter_add()}} automatically sets up a meter and creates an
up-down counter instrument, as needed.

An up-down counter object is created by calling the
\code{create_up_down_counter()} method of an \code{\link[=otel_meter_provider]{otel_meter_provider()}}.

You can use the \code{add()} method to increment or decrement the counter.

In R up-down counters are represented by double values.
}
\section{Methods}{
\subsection{\code{up_down_counter$add()}}{

Increment or decrement the up-down counter by a fixed amount.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{up_down_counter$add(value, attributes = NULL, span_context = NULL, ...)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{value}: Value to increment of decrement the up-down counter with.
\item \code{attributes}: Additional attributes to add.
\item \code{span_context}: Span context. If missing, the active context is used,
if any.
}
}

\subsection{Value}{

The up-down counter object itself, invisibly.
}

}
}

\examples{
mp <- get_default_meter_provider()
mtr <- mp$get_meter()
ctr <- mtr$create_up_down_counter("session")
ctr$add(1)
}
\seealso{
Other low level metrics API: 
\code{\link{get_default_meter_provider}()},
\code{\link{get_meter}()},
\code{\link{meter_provider_noop}},
\code{\link{otel_counter}},
\code{\link{otel_gauge}},
\code{\link{otel_histogram}},
\code{\link{otel_meter}},
\code{\link{otel_meter_provider}}
}
\concept{low level metrics API}
