% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irt_ensemble.R
\name{irt_ensemble}
\alias{irt_ensemble}
\title{Computes an ensemble score using Item Response Theory}
\usage{
irt_ensemble(X)
}
\arguments{
\item{X}{The input data containing the outlier scores in a dataframe, matrix or tibble format. Rows contain observations and columns contain outlier detection methods.}
}
\value{
A list with the components:
\item{\code{scores}}{The ensemble scores.}
\item{\code{model}}{The IRT model. }
}
\description{
This function computes an ensemble score using Item Response Theory (IRT). This was proposed as an ensemble method for anomaly/outlier detection in  Kandanaarachchi (2021) <doi:10.13140/RG.2.2.18355.96801>.
}
\details{
For outlier detection, higher ensemble scores indicate higher levels of anomalousness. This ensemble uses IRT's latent trait to uncover  the hidden ground truth, which is used as the ensemble score. It uses the R packages airt and EstCRM to fit the IRT models. It can also be used for other ensembling tasks.
}
\examples{
set.seed(123)
X <- data.frame(x1 = rnorm(200), x2 = rnorm(200))
X[199, ] <- c(4, 4)
X[200, ] <- c(-3, 5)
y1 <- DDoutlier::KNN_AGG(X)
y2 <- DDoutlier::LOF(X)
y3 <- DDoutlier::COF(X)
y4 <- DDoutlier::INFLO(X)
y5 <- DDoutlier::KDEOS(X)
y6 <- DDoutlier::LDF(X)
y7 <- DDoutlier::LDOF(X)
Y <- cbind.data.frame(y1, y2, y3, y4, y5, y6, y7)
ens <- irt_ensemble(Y)
ens$scores

}
