% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{summary.pc_matrix}
\alias{summary.pc_matrix}
\title{Summarize Pattern Causality Matrix}
\usage{
\method{summary}{pc_matrix}(object, ...)
}
\arguments{
\item{object}{A \code{pc_matrix} object.}

\item{...}{Additional arguments passed to the \code{summary} function.}
}
\value{
Invisibly returns the input object.
}
\description{
Provides a summary of the pattern causality matrix object.
This function calculates and displays descriptive statistics (mean, SD, min, max)
for each causality matrix (positive, negative, dark).
}
\examples{
data(climate_indices)
dataset <- climate_indices[, -1]
pc_matrix_obj <- pcMatrix(dataset, E = 3, tau = 1, 
  metric = "euclidean", h = 1, weighted = TRUE, 
  verbose = FALSE)
summary(pc_matrix_obj)
}
