% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_put_principal_mapping}
\alias{kendra_put_principal_mapping}
\title{Maps users to their groups so that you only need to provide the user ID
when you issue the query}
\usage{
kendra_put_principal_mapping(
  IndexId,
  DataSourceId = NULL,
  GroupId,
  GroupMembers,
  OrderingId = NULL,
  RoleArn = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index you want to map users to their groups.}

\item{DataSourceId}{The identifier of the data source you want to map users to their groups.

This is useful if a group is tied to multiple data sources, but you only
want the group to access documents of a certain data source. For
example, the groups "Research", "Engineering", and "Sales and Marketing"
are all tied to the company's documents stored in the data sources
Confluence and Salesforce. However, "Sales and Marketing" team only
needs access to customer-related documents stored in Salesforce.}

\item{GroupId}{[required] The identifier of the group you want to map its users to.}

\item{GroupMembers}{[required] The list that contains your users or sub groups that belong the same
group.

For example, the group "Company" includes the user "CEO" and the sub
groups "Research", "Engineering", and "Sales and Marketing".

If you have more than 1000 users and/or sub groups for a single group,
you need to provide the path to the S3 file that lists your users and
sub groups for a group. Your sub groups can contain more than 1000
users, but the list of sub groups that belong to a group (and/or users)
must be no more than 1000.}

\item{OrderingId}{The timestamp identifier you specify to ensure Amazon Kendra does not
override the latest \code{PUT} action with previous actions. The highest
number ID, which is the ordering ID, is the latest action you want to
process and apply on top of other actions with lower number IDs. This
prevents previous actions with lower number IDs from possibly overriding
the latest action.

The ordering ID can be the Unix time of the last update you made to a
group members list. You would then provide this list when calling
\code{\link[=kendra_put_principal_mapping]{put_principal_mapping}}. This ensures
your \code{PUT} action for that updated group with the latest members list
doesn't get overwritten by earlier \code{PUT} actions for the same group
which are yet to be processed.

The default ordering ID is the current Unix time in milliseconds that
the action was received by Amazon Kendra.}

\item{RoleArn}{The Amazon Resource Name (ARN) of a role that has access to the S3 file
that contains your list of users or sub groups that belong to a group.

For more information, see \href{https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds}{IAM roles for Amazon Kendra}.}
}
\description{
Maps users to their groups so that you only need to provide the user ID when you issue the query.

See \url{https://www.paws-r-sdk.com/docs/kendra_put_principal_mapping/} for full documentation.
}
\keyword{internal}
