# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include eventbridgepipes_service.R
NULL

#' Create a pipe
#'
#' @description
#' Create a pipe. Amazon EventBridge Pipes connect event sources to targets and reduces the need for specialized knowledge and integration code.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_create_pipe/](https://www.paws-r-sdk.com/docs/eventbridgepipes_create_pipe/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the pipe.
#' @param Description A description of the pipe.
#' @param DesiredState The state the pipe should be in.
#' @param Source &#91;required&#93; The ARN of the source resource.
#' @param SourceParameters The parameters required to set up a source for your pipe.
#' @param Enrichment The ARN of the enrichment resource.
#' @param EnrichmentParameters The parameters required to set up enrichment on your pipe.
#' @param Target &#91;required&#93; The ARN of the target resource.
#' @param TargetParameters The parameters required to set up a target for your pipe.
#' 
#' For more information about pipe target parameters, including how to use
#' dynamic path parameters, see [Target
#' parameters](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html)
#' in the *Amazon EventBridge User Guide*.
#' @param RoleArn &#91;required&#93; The ARN of the role that allows the pipe to send data to the target.
#' @param Tags The list of key-value pairs to associate with the pipe.
#' @param LogConfiguration The logging configuration settings for the pipe.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_create_pipe
eventbridgepipes_create_pipe <- function(Name, Description = NULL, DesiredState = NULL, Source, SourceParameters = NULL, Enrichment = NULL, EnrichmentParameters = NULL, Target, TargetParameters = NULL, RoleArn, Tags = NULL, LogConfiguration = NULL) {
  op <- new_operation(
    name = "CreatePipe",
    http_method = "POST",
    http_path = "/v1/pipes/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$create_pipe_input(Name = Name, Description = Description, DesiredState = DesiredState, Source = Source, SourceParameters = SourceParameters, Enrichment = Enrichment, EnrichmentParameters = EnrichmentParameters, Target = Target, TargetParameters = TargetParameters, RoleArn = RoleArn, Tags = Tags, LogConfiguration = LogConfiguration)
  output <- .eventbridgepipes$create_pipe_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$create_pipe <- eventbridgepipes_create_pipe

#' Delete an existing pipe
#'
#' @description
#' Delete an existing pipe. For more information about pipes, see [Amazon EventBridge Pipes](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html) in the Amazon EventBridge User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_delete_pipe/](https://www.paws-r-sdk.com/docs/eventbridgepipes_delete_pipe/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the pipe.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_delete_pipe
eventbridgepipes_delete_pipe <- function(Name) {
  op <- new_operation(
    name = "DeletePipe",
    http_method = "DELETE",
    http_path = "/v1/pipes/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$delete_pipe_input(Name = Name)
  output <- .eventbridgepipes$delete_pipe_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$delete_pipe <- eventbridgepipes_delete_pipe

#' Get the information about an existing pipe
#'
#' @description
#' Get the information about an existing pipe. For more information about pipes, see [Amazon EventBridge Pipes](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html) in the Amazon EventBridge User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_describe_pipe/](https://www.paws-r-sdk.com/docs/eventbridgepipes_describe_pipe/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the pipe.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_describe_pipe
eventbridgepipes_describe_pipe <- function(Name) {
  op <- new_operation(
    name = "DescribePipe",
    http_method = "GET",
    http_path = "/v1/pipes/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$describe_pipe_input(Name = Name)
  output <- .eventbridgepipes$describe_pipe_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$describe_pipe <- eventbridgepipes_describe_pipe

#' Get the pipes associated with this account
#'
#' @description
#' Get the pipes associated with this account. For more information about pipes, see [Amazon EventBridge Pipes](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html) in the Amazon EventBridge User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_list_pipes/](https://www.paws-r-sdk.com/docs/eventbridgepipes_list_pipes/) for full documentation.
#'
#' @param NamePrefix A value that will return a subset of the pipes associated with this
#' account. For example, `"NamePrefix": "ABC"` will return all endpoints
#' with "ABC" in the name.
#' @param DesiredState The state the pipe should be in.
#' @param CurrentState The state the pipe is in.
#' @param SourcePrefix The prefix matching the pipe source.
#' @param TargetPrefix The prefix matching the pipe target.
#' @param NextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an HTTP 400 InvalidToken error.
#' @param Limit The maximum number of pipes to include in the response.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_list_pipes
eventbridgepipes_list_pipes <- function(NamePrefix = NULL, DesiredState = NULL, CurrentState = NULL, SourcePrefix = NULL, TargetPrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPipes",
    http_method = "GET",
    http_path = "/v1/pipes",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "Limit", result_key = "Pipes")
  )
  input <- .eventbridgepipes$list_pipes_input(NamePrefix = NamePrefix, DesiredState = DesiredState, CurrentState = CurrentState, SourcePrefix = SourcePrefix, TargetPrefix = TargetPrefix, NextToken = NextToken, Limit = Limit)
  output <- .eventbridgepipes$list_pipes_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$list_pipes <- eventbridgepipes_list_pipes

#' Displays the tags associated with a pipe
#'
#' @description
#' Displays the tags associated with a pipe.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/eventbridgepipes_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the pipe for which you want to view tags.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_list_tags_for_resource
eventbridgepipes_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .eventbridgepipes$list_tags_for_resource_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$list_tags_for_resource <- eventbridgepipes_list_tags_for_resource

#' Start an existing pipe
#'
#' @description
#' Start an existing pipe.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_start_pipe/](https://www.paws-r-sdk.com/docs/eventbridgepipes_start_pipe/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the pipe.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_start_pipe
eventbridgepipes_start_pipe <- function(Name) {
  op <- new_operation(
    name = "StartPipe",
    http_method = "POST",
    http_path = "/v1/pipes/{Name}/start",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$start_pipe_input(Name = Name)
  output <- .eventbridgepipes$start_pipe_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$start_pipe <- eventbridgepipes_start_pipe

#' Stop an existing pipe
#'
#' @description
#' Stop an existing pipe.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_stop_pipe/](https://www.paws-r-sdk.com/docs/eventbridgepipes_stop_pipe/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the pipe.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_stop_pipe
eventbridgepipes_stop_pipe <- function(Name) {
  op <- new_operation(
    name = "StopPipe",
    http_method = "POST",
    http_path = "/v1/pipes/{Name}/stop",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$stop_pipe_input(Name = Name)
  output <- .eventbridgepipes$stop_pipe_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$stop_pipe <- eventbridgepipes_stop_pipe

#' Assigns one or more tags (key-value pairs) to the specified pipe
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified pipe. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_tag_resource/](https://www.paws-r-sdk.com/docs/eventbridgepipes_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the pipe.
#' @param tags &#91;required&#93; The list of key-value pairs associated with the pipe.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_tag_resource
eventbridgepipes_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .eventbridgepipes$tag_resource_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$tag_resource <- eventbridgepipes_tag_resource

#' Removes one or more tags from the specified pipes
#'
#' @description
#' Removes one or more tags from the specified pipes.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_untag_resource/](https://www.paws-r-sdk.com/docs/eventbridgepipes_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the pipe.
#' @param tagKeys &#91;required&#93; The list of tag keys to remove from the pipe.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_untag_resource
eventbridgepipes_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .eventbridgepipes$untag_resource_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$untag_resource <- eventbridgepipes_untag_resource

#' Update an existing pipe
#'
#' @description
#' Update an existing pipe. When you call [`update_pipe`][eventbridgepipes_update_pipe], EventBridge only the updates fields you have specified in the request; the rest remain unchanged. The exception to this is if you modify any Amazon Web Services-service specific fields in the `SourceParameters`, `EnrichmentParameters`, or `TargetParameters` objects. For example, `DynamoDBStreamParameters` or `EventBridgeEventBusParameters`. EventBridge updates the fields in these objects atomically as one and overrides existing values. This is by design, and means that if you don't specify an optional field in one of these `Parameters` objects, EventBridge sets that field to its system-default value during the update.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgepipes_update_pipe/](https://www.paws-r-sdk.com/docs/eventbridgepipes_update_pipe/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the pipe.
#' @param Description A description of the pipe.
#' @param DesiredState The state the pipe should be in.
#' @param SourceParameters The parameters required to set up a source for your pipe.
#' @param Enrichment The ARN of the enrichment resource.
#' @param EnrichmentParameters The parameters required to set up enrichment on your pipe.
#' @param Target The ARN of the target resource.
#' @param TargetParameters The parameters required to set up a target for your pipe.
#' 
#' For more information about pipe target parameters, including how to use
#' dynamic path parameters, see [Target
#' parameters](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html)
#' in the *Amazon EventBridge User Guide*.
#' @param RoleArn &#91;required&#93; The ARN of the role that allows the pipe to send data to the target.
#' @param LogConfiguration The logging configuration settings for the pipe.
#'
#' @keywords internal
#'
#' @rdname eventbridgepipes_update_pipe
eventbridgepipes_update_pipe <- function(Name, Description = NULL, DesiredState = NULL, SourceParameters = NULL, Enrichment = NULL, EnrichmentParameters = NULL, Target = NULL, TargetParameters = NULL, RoleArn, LogConfiguration = NULL) {
  op <- new_operation(
    name = "UpdatePipe",
    http_method = "PUT",
    http_path = "/v1/pipes/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgepipes$update_pipe_input(Name = Name, Description = Description, DesiredState = DesiredState, SourceParameters = SourceParameters, Enrichment = Enrichment, EnrichmentParameters = EnrichmentParameters, Target = Target, TargetParameters = TargetParameters, RoleArn = RoleArn, LogConfiguration = LogConfiguration)
  output <- .eventbridgepipes$update_pipe_output()
  config <- get_config()
  svc <- .eventbridgepipes$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgepipes$operations$update_pipe <- eventbridgepipes_update_pipe
