% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_attribute}
\alias{ec2_modify_instance_attribute}
\title{Modifies the specified attribute of the specified instance}
\usage{
ec2_modify_instance_attribute(
  SourceDestCheck = NULL,
  DisableApiStop = NULL,
  DryRun = NULL,
  InstanceId,
  Attribute = NULL,
  Value = NULL,
  BlockDeviceMappings = NULL,
  DisableApiTermination = NULL,
  InstanceType = NULL,
  Kernel = NULL,
  Ramdisk = NULL,
  UserData = NULL,
  InstanceInitiatedShutdownBehavior = NULL,
  Groups = NULL,
  EbsOptimized = NULL,
  SriovNetSupport = NULL,
  EnaSupport = NULL
)
}
\arguments{
\item{SourceDestCheck}{Enable or disable source/destination checks, which ensure that the
instance is either the source or the destination of any traffic that it
receives. If the value is \code{true}, source/destination checks are enabled;
otherwise, they are disabled. The default value is \code{true}. You must
disable source/destination checks if the instance runs services such as
network address translation, routing, or firewalls.}

\item{DisableApiStop}{Indicates whether an instance is enabled for stop protection. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-stop-protection.html}{Enable stop protection for your instance}.}

\item{DryRun}{Checks whether you have the required permissions for the operation,
without actually making the request, and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceId}{[required] The ID of the instance.}

\item{Attribute}{The name of the attribute to modify.

You can modify the following attributes only: \code{disableApiTermination} |
\code{instanceType} | \code{kernel} | \code{ramdisk} |
\code{instanceInitiatedShutdownBehavior} | \code{blockDeviceMapping} | \code{userData}
| \code{sourceDestCheck} | \code{groupSet} | \code{ebsOptimized} | \code{sriovNetSupport} |
\code{enaSupport} | \code{nvmeSupport} | \code{disableApiStop} | \code{enclaveOptions}}

\item{Value}{A new value for the attribute. Use only with the \code{kernel}, \code{ramdisk},
\code{userData}, \code{disableApiTermination}, or
\code{instanceInitiatedShutdownBehavior} attribute.}

\item{BlockDeviceMappings}{Modifies the \code{DeleteOnTermination} attribute for volumes that are
currently attached. The volume must be owned by the caller. If no value
is specified for \code{DeleteOnTermination}, the default is \code{true} and the
volume is deleted when the instance is terminated. You can't modify the
\code{DeleteOnTermination} attribute for volumes that are attached to Fargate
tasks.

To add instance store volumes to an Amazon EBS-backed instance, you must
add them when you launch the instance. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM}{Update the block device mapping when launching an instance}
in the \emph{Amazon EC2 User Guide}.}

\item{DisableApiTermination}{If the value is \code{true}, you can't terminate the instance using the
Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this
parameter for Spot Instances.}

\item{InstanceType}{Changes the instance type to the specified value. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance types}
in the \emph{Amazon EC2 User Guide}. If the instance type is not valid, the
error returned is \code{InvalidInstanceAttributeValue}.}

\item{Kernel}{Changes the instance's kernel to the specified value. We recommend that
you use PV-GRUB instead of kernels and RAM disks. For more information,
see
\href{https://docs.aws.amazon.com/linux/al2/ug/UserProvidedKernels.html}{PV-GRUB}.}

\item{Ramdisk}{Changes the instance's RAM disk to the specified value. We recommend
that you use PV-GRUB instead of kernels and RAM disks. For more
information, see
\href{https://docs.aws.amazon.com/linux/al2/ug/UserProvidedKernels.html}{PV-GRUB}.}

\item{UserData}{Changes the instance's user data to the specified value. User data must
be base64-encoded. Depending on the tool or SDK that you're using, the
base64-encoding might be performed for you. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/}{Work with instance user data}.}

\item{InstanceInitiatedShutdownBehavior}{Specifies whether an instance stops or terminates when you initiate
shutdown from the instance (using the operating system command for
system shutdown).}

\item{Groups}{Replaces the security groups of the instance with the specified security
groups. You must specify the ID of at least one security group, even if
it's just the default security group for the VPC.}

\item{EbsOptimized}{Specifies whether the instance is optimized for Amazon EBS I/O. This
optimization provides dedicated throughput to Amazon EBS and an
optimized configuration stack to provide optimal EBS I/O performance.
This optimization isn't available with all instance types. Additional
usage charges apply when using an EBS Optimized instance.}

\item{SriovNetSupport}{Set to \code{simple} to enable enhanced networking with the Intel 82599
Virtual Function interface for the instance.

There is no way to disable enhanced networking with the Intel 82599
Virtual Function interface at this time.

This option is supported only for HVM instances. Specifying this option
with a PV instance can make it unreachable.}

\item{EnaSupport}{Set to \code{true} to enable enhanced networking with ENA for the instance.

This option is supported only for HVM instances. Specifying this option
with a PV instance can make it unreachable.}
}
\description{
Modifies the specified attribute of the specified instance. You can specify only one attribute at a time.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_instance_attribute/} for full documentation.
}
\keyword{internal}
