% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_relational_database}
\alias{lightsail_create_relational_database}
\title{Creates a new database in Amazon Lightsail}
\usage{
lightsail_create_relational_database(
  relationalDatabaseName,
  availabilityZone = NULL,
  relationalDatabaseBlueprintId,
  relationalDatabaseBundleId,
  masterDatabaseName,
  masterUsername,
  masterUserPassword = NULL,
  preferredBackupWindow = NULL,
  preferredMaintenanceWindow = NULL,
  publiclyAccessible = NULL,
  tags = NULL
)
}
\arguments{
\item{relationalDatabaseName}{[required] The name to use for your new Lightsail database resource.

Constraints:
\itemize{
\item Must contain from 2 to 255 alphanumeric characters, or hyphens.
\item The first and last character must be a letter or number.
}}

\item{availabilityZone}{The Availability Zone in which to create your new database. Use the
\verb{us-east-2a} case-sensitive format.

You can get a list of Availability Zones by using the \verb{get regions}
operation. Be sure to add the
\verb{include relational database Availability Zones} parameter to your
request.}

\item{relationalDatabaseBlueprintId}{[required] The blueprint ID for your new database. A blueprint describes the major
engine version of a database.

You can get a list of database blueprints IDs by using the
\verb{get relational database blueprints} operation.}

\item{relationalDatabaseBundleId}{[required] The bundle ID for your new database. A bundle describes the performance
specifications for your database.

You can get a list of database bundle IDs by using the
\verb{get relational database bundles} operation.}

\item{masterDatabaseName}{[required] The meaning of this parameter differs according to the database engine
you use.

\strong{MySQL}

The name of the database to create when the Lightsail database resource
is created. If this parameter isn't specified, no database is created in
the database resource.

Constraints:
\itemize{
\item Must contain 1 to 64 letters or numbers.
\item Must begin with a letter. Subsequent characters can be letters,
underscores, or digits (0- 9).
\item Can't be a word reserved by the specified database engine.

For more information about reserved words in MySQL, see the Keywords
and Reserved Words articles for \href{https://dev.mysql.com/doc/refman/8.4/en/keywords.html}{MySQL 5.6}, \href{https://dev.mysql.com/doc/refman/5.7/en/keywords.html}{MySQL 5.7}, and
\href{https://dev.mysql.com/doc/refman/8.0/en/keywords.html}{MySQL 8.0}.
}

\strong{PostgreSQL}

The name of the database to create when the Lightsail database resource
is created. If this parameter isn't specified, a database named
\code{postgres} is created in the database resource.

Constraints:
\itemize{
\item Must contain 1 to 63 letters or numbers.
\item Must begin with a letter. Subsequent characters can be letters,
underscores, or digits (0- 9).
\item Can't be a word reserved by the specified database engine.

For more information about reserved words in PostgreSQL, see the SQL
Key Words articles for \href{https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html}{PostgreSQL 9.6},
\href{https://www.postgresql.org/docs/10/sql-keywords-appendix.html}{PostgreSQL 10},
\href{https://www.postgresql.org/docs/11/sql-keywords-appendix.html}{PostgreSQL 11},
and \href{https://www.postgresql.org/docs/12/sql-keywords-appendix.html}{PostgreSQL 12}.
}}

\item{masterUsername}{[required] The name for the master user.

\strong{MySQL}

Constraints:
\itemize{
\item Required for MySQL.
\item Must be 1 to 16 letters or numbers. Can contain underscores.
\item First character must be a letter.
\item Can't be a reserved word for the chosen database engine.

For more information about reserved words in MySQL 5.6 or 5.7, see
the Keywords and Reserved Words articles for \href{https://dev.mysql.com/doc/refman/8.4/en/keywords.html}{MySQL 5.6}, \href{https://dev.mysql.com/doc/refman/5.7/en/keywords.html}{MySQL 5.7}, or
\href{https://dev.mysql.com/doc/refman/8.0/en/keywords.html}{MySQL 8.0}.
}

\strong{PostgreSQL}

Constraints:
\itemize{
\item Required for PostgreSQL.
\item Must be 1 to 63 letters or numbers. Can contain underscores.
\item First character must be a letter.
\item Can't be a reserved word for the chosen database engine.

For more information about reserved words in MySQL 5.6 or 5.7, see
the Keywords and Reserved Words articles for \href{https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html}{PostgreSQL 9.6},
\href{https://www.postgresql.org/docs/10/sql-keywords-appendix.html}{PostgreSQL 10},
\href{https://www.postgresql.org/docs/11/sql-keywords-appendix.html}{PostgreSQL 11},
and \href{https://www.postgresql.org/docs/12/sql-keywords-appendix.html}{PostgreSQL 12}.
}}

\item{masterUserPassword}{The password for the master user. The password can include any printable
ASCII character except "/", """, or "@". It cannot contain spaces.

\strong{MySQL}

Constraints: Must contain from 8 to 41 characters.

\strong{PostgreSQL}

Constraints: Must contain from 8 to 128 characters.}

\item{preferredBackupWindow}{The daily time range during which automated backups are created for your
new database if automated backups are enabled.

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region. For more information about the
preferred backup window time blocks for each region, see the \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow}{Working With Backups}
guide in the Amazon Relational Database Service documentation.

Constraints:
\itemize{
\item Must be in the \code{hh24:mi-hh24:mi} format.

Example: \code{16:00-16:30}
\item Specified in Coordinated Universal Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{preferredMaintenanceWindow}{The weekly time range during which system maintenance can occur on your
new database.

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region, occurring on a random day of the
week.

Constraints:
\itemize{
\item Must be in the \code{ddd:hh24:mi-ddd:hh24:mi} format.
\item Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
\item Must be at least 30 minutes.
\item Specified in Coordinated Universal Time (UTC).
\item Example: \code{Tue:17:00-Tue:17:30}
}}

\item{publiclyAccessible}{Specifies the accessibility options for your new database. A value of
\code{true} specifies a database that is available to resources outside of
your Lightsail account. A value of \code{false} specifies a database that is
available only to your Lightsail resources in the same region as your
database.}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}
}
\description{
Creates a new database in Amazon Lightsail.

See \url{https://www.paws-r-sdk.com/docs/lightsail_create_relational_database/} for full documentation.
}
\keyword{internal}
