# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include marketplaceentitlementservice_service.R
NULL

#' GetEntitlements retrieves entitlement values for a given product
#'
#' @description
#' GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer identifier or product dimensions.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplaceentitlementservice_get_entitlements/](https://www.paws-r-sdk.com/docs/marketplaceentitlementservice_get_entitlements/) for full documentation.
#'
#' @param ProductCode &#91;required&#93; Product code is used to uniquely identify a product in AWS Marketplace.
#' The product code will be provided by AWS Marketplace when the product
#' listing is created.
#' @param Filter Filter is used to return entitlements for a specific customer or for a
#' specific dimension. Filters are described as keys mapped to a lists of
#' values. Filtered requests are *unioned* for each value in the value
#' list, and then *intersected* for each filter key.
#' @param NextToken For paginated calls to GetEntitlements, pass the NextToken from the
#' previous GetEntitlementsResult.
#' @param MaxResults The maximum number of items to retrieve from the GetEntitlements
#' operation. For pagination, use the NextToken field in subsequent calls
#' to GetEntitlements.
#'
#' @keywords internal
#'
#' @rdname marketplaceentitlementservice_get_entitlements
marketplaceentitlementservice_get_entitlements <- function(ProductCode, Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetEntitlements",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .marketplaceentitlementservice$get_entitlements_input(ProductCode = ProductCode, Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .marketplaceentitlementservice$get_entitlements_output()
  config <- get_config()
  svc <- .marketplaceentitlementservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplaceentitlementservice$operations$get_entitlements <- marketplaceentitlementservice_get_entitlements
