# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Pinpoint SMS Voice V2
#'
#' @description
#' Welcome to the *AWS End User Messaging SMS and Voice, version 2 API
#' Reference*. This guide provides information about AWS End User Messaging
#' SMS and Voice, version 2 API resources, including supported HTTP
#' methods, parameters, and schemas.
#' 
#' Amazon Pinpoint is an Amazon Web Services service that you can use to
#' engage with your recipients across multiple messaging channels. The AWS
#' End User Messaging SMS and Voice, version 2 API provides programmatic
#' access to options that are unique to the SMS and voice channels. AWS End
#' User Messaging SMS and Voice, version 2 resources such as phone numbers,
#' sender IDs, and opt-out lists can be used by the Amazon Pinpoint API.
#' 
#' If you're new to AWS End User Messaging SMS and Voice, it's also helpful
#' to review the [AWS End User Messaging SMS User
#' Guide](https://docs.aws.amazon.com/sms-voice/latest/userguide/what-is-service.html).
#' The *AWS End User Messaging SMS User Guide* provides tutorials, code
#' samples, and procedures that demonstrate how to use AWS End User
#' Messaging SMS and Voice features programmatically and how to integrate
#' functionality into mobile apps and other types of applications. The
#' guide also provides key information, such as AWS End User Messaging SMS
#' and Voice integration with other Amazon Web Services services, and the
#' quotas that apply to use of the service.
#' 
#' **Regional availability**
#' 
#' The *AWS End User Messaging SMS and Voice version 2 API Reference* is
#' available in several Amazon Web Services Regions and it provides an
#' endpoint for each of these Regions. For a list of all the Regions and
#' endpoints where the API is currently available, see [Amazon Web Services
#' Service
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region)
#' and [Amazon Pinpoint endpoints and
#' quotas](https://docs.aws.amazon.com/general/latest/gr/pinpoint.html) in
#' the Amazon Web Services General Reference. To learn more about Amazon
#' Web Services Regions, see [Managing Amazon Web Services
#' Regions](https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html)
#' in the Amazon Web Services General Reference.
#' 
#' In each Region, Amazon Web Services maintains multiple Availability
#' Zones. These Availability Zones are physically isolated from each other,
#' but are united by private, low-latency, high-throughput, and highly
#' redundant network connections. These Availability Zones enable us to
#' provide very high levels of availability and redundancy, while also
#' minimizing latency. To learn more about the number of Availability Zones
#' that are available in each Region, see [Amazon Web Services Global
#' Infrastructure.](https://aws.amazon.com/about-aws/global-infrastructure/)
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- pinpointsmsvoicev2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- pinpointsmsvoicev2()
#' svc$associate_origination_identity(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=pinpointsmsvoicev2_associate_origination_identity]{associate_origination_identity} \tab Associates the specified origination identity with a pool\cr
#'  \link[=pinpointsmsvoicev2_associate_protect_configuration]{associate_protect_configuration} \tab Associate a protect configuration with a configuration set\cr
#'  \link[=pinpointsmsvoicev2_create_configuration_set]{create_configuration_set} \tab Creates a new configuration set\cr
#'  \link[=pinpointsmsvoicev2_create_event_destination]{create_event_destination} \tab Creates a new event destination in a configuration set\cr
#'  \link[=pinpointsmsvoicev2_create_opt_out_list]{create_opt_out_list} \tab Creates a new opt-out list\cr
#'  \link[=pinpointsmsvoicev2_create_pool]{create_pool} \tab Creates a new pool and associates the specified origination identity to the pool\cr
#'  \link[=pinpointsmsvoicev2_create_protect_configuration]{create_protect_configuration} \tab Create a new protect configuration\cr
#'  \link[=pinpointsmsvoicev2_create_registration]{create_registration} \tab Creates a new registration based on the RegistrationType field\cr
#'  \link[=pinpointsmsvoicev2_create_registration_association]{create_registration_association} \tab Associate the registration with an origination identity such as a phone number or sender ID\cr
#'  \link[=pinpointsmsvoicev2_create_registration_attachment]{create_registration_attachment} \tab Create a new registration attachment to use for uploading a file or a URL to a file\cr
#'  \link[=pinpointsmsvoicev2_create_registration_version]{create_registration_version} \tab Create a new version of the registration and increase the VersionNumber\cr
#'  \link[=pinpointsmsvoicev2_create_verified_destination_number]{create_verified_destination_number} \tab You can only send messages to verified destination numbers when your account is in the sandbox\cr
#'  \link[=pinpointsmsvoicev2_delete_account_default_protect_configuration]{delete_account_default_protect_configuration} \tab Removes the current account default protect configuration\cr
#'  \link[=pinpointsmsvoicev2_delete_configuration_set]{delete_configuration_set} \tab Deletes an existing configuration set\cr
#'  \link[=pinpointsmsvoicev2_delete_default_message_type]{delete_default_message_type} \tab Deletes an existing default message type on a configuration set\cr
#'  \link[=pinpointsmsvoicev2_delete_default_sender_id]{delete_default_sender_id} \tab Deletes an existing default sender ID on a configuration set\cr
#'  \link[=pinpointsmsvoicev2_delete_event_destination]{delete_event_destination} \tab Deletes an existing event destination\cr
#'  \link[=pinpointsmsvoicev2_delete_keyword]{delete_keyword} \tab Deletes an existing keyword from an origination phone number or pool\cr
#'  \link[=pinpointsmsvoicev2_delete_media_message_spend_limit_override]{delete_media_message_spend_limit_override} \tab Deletes an account-level monthly spending limit override for sending multimedia messages (MMS)\cr
#'  \link[=pinpointsmsvoicev2_delete_opted_out_number]{delete_opted_out_number} \tab Deletes an existing opted out destination phone number from the specified opt-out list\cr
#'  \link[=pinpointsmsvoicev2_delete_opt_out_list]{delete_opt_out_list} \tab Deletes an existing opt-out list\cr
#'  \link[=pinpointsmsvoicev2_delete_pool]{delete_pool} \tab Deletes an existing pool\cr
#'  \link[=pinpointsmsvoicev2_delete_protect_configuration]{delete_protect_configuration} \tab Permanently delete the protect configuration\cr
#'  \link[=pinpointsmsvoicev2_delete_registration]{delete_registration} \tab Permanently delete an existing registration from your account\cr
#'  \link[=pinpointsmsvoicev2_delete_registration_attachment]{delete_registration_attachment} \tab Permanently delete the specified registration attachment\cr
#'  \link[=pinpointsmsvoicev2_delete_registration_field_value]{delete_registration_field_value} \tab Delete the value in a registration form field\cr
#'  \link[=pinpointsmsvoicev2_delete_text_message_spend_limit_override]{delete_text_message_spend_limit_override} \tab Deletes an account-level monthly spending limit override for sending text messages\cr
#'  \link[=pinpointsmsvoicev2_delete_verified_destination_number]{delete_verified_destination_number} \tab Delete a verified destination phone number\cr
#'  \link[=pinpointsmsvoicev2_delete_voice_message_spend_limit_override]{delete_voice_message_spend_limit_override} \tab Deletes an account level monthly spend limit override for sending voice messages\cr
#'  \link[=pinpointsmsvoicev2_describe_account_attributes]{describe_account_attributes} \tab Describes attributes of your Amazon Web Services account\cr
#'  \link[=pinpointsmsvoicev2_describe_account_limits]{describe_account_limits} \tab Describes the current AWS End User Messaging SMS and Voice SMS Voice V2 resource quotas for your account\cr
#'  \link[=pinpointsmsvoicev2_describe_configuration_sets]{describe_configuration_sets} \tab Describes the specified configuration sets or all in your account\cr
#'  \link[=pinpointsmsvoicev2_describe_keywords]{describe_keywords} \tab Describes the specified keywords or all keywords on your origination phone number or pool\cr
#'  \link[=pinpointsmsvoicev2_describe_opted_out_numbers]{describe_opted_out_numbers} \tab Describes the specified opted out destination numbers or all opted out destination numbers in an opt-out list\cr
#'  \link[=pinpointsmsvoicev2_describe_opt_out_lists]{describe_opt_out_lists} \tab Describes the specified opt-out list or all opt-out lists in your account\cr
#'  \link[=pinpointsmsvoicev2_describe_phone_numbers]{describe_phone_numbers} \tab Describes the specified origination phone number, or all the phone numbers in your account\cr
#'  \link[=pinpointsmsvoicev2_describe_pools]{describe_pools} \tab Retrieves the specified pools or all pools associated with your Amazon Web Services account\cr
#'  \link[=pinpointsmsvoicev2_describe_protect_configurations]{describe_protect_configurations} \tab Retrieves the protect configurations that match any of filters\cr
#'  \link[=pinpointsmsvoicev2_describe_registration_attachments]{describe_registration_attachments} \tab Retrieves the specified registration attachments or all registration attachments associated with your Amazon Web Services account\cr
#'  \link[=pinpointsmsvoicev2_describe_registration_field_definitions]{describe_registration_field_definitions} \tab Retrieves the specified registration type field definitions\cr
#'  \link[=pinpointsmsvoicev2_describe_registration_field_values]{describe_registration_field_values} \tab Retrieves the specified registration field values\cr
#'  \link[=pinpointsmsvoicev2_describe_registrations]{describe_registrations} \tab Retrieves the specified registrations\cr
#'  \link[=pinpointsmsvoicev2_describe_registration_section_definitions]{describe_registration_section_definitions} \tab Retrieves the specified registration section definitions\cr
#'  \link[=pinpointsmsvoicev2_describe_registration_type_definitions]{describe_registration_type_definitions} \tab Retrieves the specified registration type definitions\cr
#'  \link[=pinpointsmsvoicev2_describe_registration_versions]{describe_registration_versions} \tab Retrieves the specified registration version\cr
#'  \link[=pinpointsmsvoicev2_describe_sender_ids]{describe_sender_ids} \tab Describes the specified SenderIds or all SenderIds associated with your Amazon Web Services account\cr
#'  \link[=pinpointsmsvoicev2_describe_spend_limits]{describe_spend_limits} \tab Describes the current monthly spend limits for sending voice and text messages\cr
#'  \link[=pinpointsmsvoicev2_describe_verified_destination_numbers]{describe_verified_destination_numbers} \tab Retrieves the specified verified destiona numbers\cr
#'  \link[=pinpointsmsvoicev2_disassociate_origination_identity]{disassociate_origination_identity} \tab Removes the specified origination identity from an existing pool\cr
#'  \link[=pinpointsmsvoicev2_disassociate_protect_configuration]{disassociate_protect_configuration} \tab Disassociate a protect configuration from a configuration set\cr
#'  \link[=pinpointsmsvoicev2_discard_registration_version]{discard_registration_version} \tab Discard the current version of the registration\cr
#'  \link[=pinpointsmsvoicev2_get_protect_configuration_country_rule_set]{get_protect_configuration_country_rule_set} \tab Retrieve the CountryRuleSet for the specified NumberCapability from a protect configuration\cr
#'  \link[=pinpointsmsvoicev2_list_pool_origination_identities]{list_pool_origination_identities} \tab Lists all associated origination identities in your pool\cr
#'  \link[=pinpointsmsvoicev2_list_registration_associations]{list_registration_associations} \tab Retreive all of the origination identies that are associated with a registration\cr
#'  \link[=pinpointsmsvoicev2_list_tags_for_resource]{list_tags_for_resource} \tab List all tags associated with a resource\cr
#'  \link[=pinpointsmsvoicev2_put_keyword]{put_keyword} \tab Creates or updates a keyword configuration on an origination phone number or pool\cr
#'  \link[=pinpointsmsvoicev2_put_opted_out_number]{put_opted_out_number} \tab Creates an opted out destination phone number in the opt-out list\cr
#'  \link[=pinpointsmsvoicev2_put_registration_field_value]{put_registration_field_value} \tab Creates or updates a field value for a registration\cr
#'  \link[=pinpointsmsvoicev2_release_phone_number]{release_phone_number} \tab Releases an existing origination phone number in your account\cr
#'  \link[=pinpointsmsvoicev2_release_sender_id]{release_sender_id} \tab Releases an existing sender ID in your account\cr
#'  \link[=pinpointsmsvoicev2_request_phone_number]{request_phone_number} \tab Request an origination phone number for use in your account\cr
#'  \link[=pinpointsmsvoicev2_request_sender_id]{request_sender_id} \tab Request a new sender ID that doesn't require registration\cr
#'  \link[=pinpointsmsvoicev2_send_destination_number_verification_code]{send_destination_number_verification_code} \tab Before you can send test messages to a verified destination phone number you need to opt-in the verified destination phone number\cr
#'  \link[=pinpointsmsvoicev2_send_media_message]{send_media_message} \tab Creates a new multimedia message (MMS) and sends it to a recipient's phone number\cr
#'  \link[=pinpointsmsvoicev2_send_text_message]{send_text_message} \tab Creates a new text message and sends it to a recipient's phone number\cr
#'  \link[=pinpointsmsvoicev2_send_voice_message]{send_voice_message} \tab Allows you to send a request that sends a voice message\cr
#'  \link[=pinpointsmsvoicev2_set_account_default_protect_configuration]{set_account_default_protect_configuration} \tab Set a protect configuration as your account default\cr
#'  \link[=pinpointsmsvoicev2_set_default_message_type]{set_default_message_type} \tab Sets the default message type on a configuration set\cr
#'  \link[=pinpointsmsvoicev2_set_default_sender_id]{set_default_sender_id} \tab Sets default sender ID on a configuration set\cr
#'  \link[=pinpointsmsvoicev2_set_media_message_spend_limit_override]{set_media_message_spend_limit_override} \tab Sets an account level monthly spend limit override for sending MMS messages\cr
#'  \link[=pinpointsmsvoicev2_set_text_message_spend_limit_override]{set_text_message_spend_limit_override} \tab Sets an account level monthly spend limit override for sending text messages\cr
#'  \link[=pinpointsmsvoicev2_set_voice_message_spend_limit_override]{set_voice_message_spend_limit_override} \tab Sets an account level monthly spend limit override for sending voice messages\cr
#'  \link[=pinpointsmsvoicev2_submit_registration_version]{submit_registration_version} \tab Submit the specified registration for review and approval\cr
#'  \link[=pinpointsmsvoicev2_tag_resource]{tag_resource} \tab Adds or overwrites only the specified tags for the specified resource\cr
#'  \link[=pinpointsmsvoicev2_untag_resource]{untag_resource} \tab Removes the association of the specified tags from a resource\cr
#'  \link[=pinpointsmsvoicev2_update_event_destination]{update_event_destination} \tab Updates an existing event destination in a configuration set\cr
#'  \link[=pinpointsmsvoicev2_update_phone_number]{update_phone_number} \tab Updates the configuration of an existing origination phone number\cr
#'  \link[=pinpointsmsvoicev2_update_pool]{update_pool} \tab Updates the configuration of an existing pool\cr
#'  \link[=pinpointsmsvoicev2_update_protect_configuration]{update_protect_configuration} \tab Update the setting for an existing protect configuration\cr
#'  \link[=pinpointsmsvoicev2_update_protect_configuration_country_rule_set]{update_protect_configuration_country_rule_set} \tab Update a country rule set to ALLOW or BLOCK messages to be sent to the specified destination counties\cr
#'  \link[=pinpointsmsvoicev2_update_sender_id]{update_sender_id} \tab Updates the configuration of an existing sender ID\cr
#'  \link[=pinpointsmsvoicev2_verify_destination_number]{verify_destination_number} \tab Use the verification code that was received by the verified destination phone number to opt-in the verified destination phone number to receive more messages
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname pinpointsmsvoicev2
#' @export
pinpointsmsvoicev2 <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .pinpointsmsvoicev2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.pinpointsmsvoicev2 <- list()

.pinpointsmsvoicev2$operations <- list()

.pinpointsmsvoicev2$metadata <- list(
  service_name = "pinpointsmsvoicev2",
  endpoints = list("*" = list(endpoint = "sms-voice.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "sms-voice.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "sms-voice.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "sms-voice.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "sms-voice.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "sms-voice.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Pinpoint SMS Voice V2",
  api_version = "2022-03-31",
  signing_name = "sms-voice",
  json_version = "1.0",
  target_prefix = "PinpointSMSVoiceV2"
)

.pinpointsmsvoicev2$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.pinpointsmsvoicev2$metadata, handlers, config, op)
}
