% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_create_calculated_attribute_definition}
\alias{customerprofiles_create_calculated_attribute_definition}
\title{Creates a new calculated attribute definition}
\usage{
customerprofiles_create_calculated_attribute_definition(
  DomainName,
  CalculatedAttributeName,
  DisplayName = NULL,
  Description = NULL,
  AttributeDetails,
  Conditions = NULL,
  Filter = NULL,
  Statistic,
  Tags = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{CalculatedAttributeName}{[required] The unique name of the calculated attribute.}

\item{DisplayName}{The display name of the calculated attribute.}

\item{Description}{The description of the calculated attribute.}

\item{AttributeDetails}{[required] Mathematical expression and a list of attribute items specified in that
expression.}

\item{Conditions}{The conditions including range, object count, and threshold for the
calculated attribute.}

\item{Filter}{Defines how to filter incoming objects to include part of the Calculated
Attribute.}

\item{Statistic}{[required] The aggregation operation to perform for the calculated attribute.}

\item{Tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Creates a new calculated attribute definition. After creation, new object data ingested into Customer Profiles will be included in the calculated attribute, which can be retrieved for a profile using the \code{\link[=customerprofiles_get_calculated_attribute_for_profile]{get_calculated_attribute_for_profile}} API. Defining a calculated attribute makes it available for all profiles within a domain. Each calculated attribute can only reference one \code{ObjectType} and at most, two fields from that \code{ObjectType}.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_create_calculated_attribute_definition/} for full documentation.
}
\keyword{internal}
