% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_create_adapter}
\alias{textract_create_adapter}
\title{Creates an adapter, which can be fine-tuned for enhanced performance on
user provided documents}
\usage{
textract_create_adapter(
  AdapterName,
  ClientRequestToken = NULL,
  Description = NULL,
  FeatureTypes,
  AutoUpdate = NULL,
  Tags = NULL
)
}
\arguments{
\item{AdapterName}{[required] The name to be assigned to the adapter being created.}

\item{ClientRequestToken}{Idempotent token is used to recognize the request. If the same token is
used with multiple CreateAdapter requests, the same session is returned.
This token is employed to avoid unintentionally creating the same
session multiple times.}

\item{Description}{The description to be assigned to the adapter being created.}

\item{FeatureTypes}{[required] The type of feature that the adapter is being trained on. Currrenly,
supported feature types are: \code{QUERIES}}

\item{AutoUpdate}{Controls whether or not the adapter should automatically update.}

\item{Tags}{A list of tags to be added to the adapter.}
}
\description{
Creates an adapter, which can be fine-tuned for enhanced performance on user provided documents. Takes an AdapterName and FeatureType. Currently the only supported feature type is \code{QUERIES}. You can also provide a Description, Tags, and a ClientRequestToken. You can choose whether or not the adapter should be AutoUpdated with the AutoUpdate argument. By default, AutoUpdate is set to DISABLED.

See \url{https://www.paws-r-sdk.com/docs/textract_create_adapter/} for full documentation.
}
\keyword{internal}
