# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include autoscaling_service.R
NULL

#' Attaches one or more EC2 instances to the specified Auto Scaling group
#'
#' @description
#' Attaches one or more EC2 instances to the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_attach_instances/](https://www.paws-r-sdk.com/docs/autoscaling_attach_instances/) for full documentation.
#'
#' @param InstanceIds The IDs of the instances. You can specify up to 20 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @keywords internal
#'
#' @rdname autoscaling_attach_instances
autoscaling_attach_instances <- function(InstanceIds = NULL, AutoScalingGroupName) {
  op <- new_operation(
    name = "AttachInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$attach_instances_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$attach_instances_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$attach_instances <- autoscaling_attach_instances

#' This API operation is superseded by AttachTrafficSources, which can
#' attach multiple traffic sources types
#'
#' @description
#' This API operation is superseded by [`attach_traffic_sources`][autoscaling_attach_traffic_sources], which can attach multiple traffic sources types. We recommend using [`attach_traffic_sources`][autoscaling_attach_traffic_sources] to simplify how you manage traffic sources. However, we continue to support [`attach_load_balancer_target_groups`][autoscaling_attach_load_balancer_target_groups]. You can use both the original [`attach_load_balancer_target_groups`][autoscaling_attach_load_balancer_target_groups] API operation and [`attach_traffic_sources`][autoscaling_attach_traffic_sources] on the same Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_attach_load_balancer_target_groups/](https://www.paws-r-sdk.com/docs/autoscaling_attach_load_balancer_target_groups/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TargetGroupARNs &#91;required&#93; The Amazon Resource Names (ARNs) of the target groups. You can specify
#' up to 10 target groups. To get the ARN of a target group, use the
#' Elastic Load Balancing
#' [DescribeTargetGroups](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
#' API operation.
#'
#' @keywords internal
#'
#' @rdname autoscaling_attach_load_balancer_target_groups
autoscaling_attach_load_balancer_target_groups <- function(AutoScalingGroupName, TargetGroupARNs) {
  op <- new_operation(
    name = "AttachLoadBalancerTargetGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$attach_load_balancer_target_groups_input(AutoScalingGroupName = AutoScalingGroupName, TargetGroupARNs = TargetGroupARNs)
  output <- .autoscaling$attach_load_balancer_target_groups_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$attach_load_balancer_target_groups <- autoscaling_attach_load_balancer_target_groups

#' This API operation is superseded by AttachTrafficSources, which can
#' attach multiple traffic sources types
#'
#' @description
#' This API operation is superseded by [`attach_traffic_sources`][autoscaling_attach_traffic_sources], which can attach multiple traffic sources types. We recommend using [`attach_traffic_sources`][autoscaling_attach_traffic_sources] to simplify how you manage traffic sources. However, we continue to support [`attach_load_balancers`][autoscaling_attach_load_balancers]. You can use both the original [`attach_load_balancers`][autoscaling_attach_load_balancers] API operation and [`attach_traffic_sources`][autoscaling_attach_traffic_sources] on the same Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_attach_load_balancers/](https://www.paws-r-sdk.com/docs/autoscaling_attach_load_balancers/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LoadBalancerNames &#91;required&#93; The names of the load balancers. You can specify up to 10 load
#' balancers.
#'
#' @keywords internal
#'
#' @rdname autoscaling_attach_load_balancers
autoscaling_attach_load_balancers <- function(AutoScalingGroupName, LoadBalancerNames) {
  op <- new_operation(
    name = "AttachLoadBalancers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$attach_load_balancers_input(AutoScalingGroupName = AutoScalingGroupName, LoadBalancerNames = LoadBalancerNames)
  output <- .autoscaling$attach_load_balancers_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$attach_load_balancers <- autoscaling_attach_load_balancers

#' Attaches one or more traffic sources to the specified Auto Scaling group
#'
#' @description
#' Attaches one or more traffic sources to the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_attach_traffic_sources/](https://www.paws-r-sdk.com/docs/autoscaling_attach_traffic_sources/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TrafficSources &#91;required&#93; The unique identifiers of one or more traffic sources. You can specify
#' up to 10 traffic sources.
#'
#' @keywords internal
#'
#' @rdname autoscaling_attach_traffic_sources
autoscaling_attach_traffic_sources <- function(AutoScalingGroupName, TrafficSources) {
  op <- new_operation(
    name = "AttachTrafficSources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$attach_traffic_sources_input(AutoScalingGroupName = AutoScalingGroupName, TrafficSources = TrafficSources)
  output <- .autoscaling$attach_traffic_sources_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$attach_traffic_sources <- autoscaling_attach_traffic_sources

#' Deletes one or more scheduled actions for the specified Auto Scaling
#' group
#'
#' @description
#' Deletes one or more scheduled actions for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_batch_delete_scheduled_action/](https://www.paws-r-sdk.com/docs/autoscaling_batch_delete_scheduled_action/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScheduledActionNames &#91;required&#93; The names of the scheduled actions to delete. The maximum number allowed
#' is 50.
#'
#' @keywords internal
#'
#' @rdname autoscaling_batch_delete_scheduled_action
autoscaling_batch_delete_scheduled_action <- function(AutoScalingGroupName, ScheduledActionNames) {
  op <- new_operation(
    name = "BatchDeleteScheduledAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$batch_delete_scheduled_action_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledActionNames = ScheduledActionNames)
  output <- .autoscaling$batch_delete_scheduled_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$batch_delete_scheduled_action <- autoscaling_batch_delete_scheduled_action

#' Creates or updates one or more scheduled scaling actions for an Auto
#' Scaling group
#'
#' @description
#' Creates or updates one or more scheduled scaling actions for an Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_batch_put_scheduled_update_group_action/](https://www.paws-r-sdk.com/docs/autoscaling_batch_put_scheduled_update_group_action/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScheduledUpdateGroupActions &#91;required&#93; One or more scheduled actions. The maximum number allowed is 50.
#'
#' @keywords internal
#'
#' @rdname autoscaling_batch_put_scheduled_update_group_action
autoscaling_batch_put_scheduled_update_group_action <- function(AutoScalingGroupName, ScheduledUpdateGroupActions) {
  op <- new_operation(
    name = "BatchPutScheduledUpdateGroupAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$batch_put_scheduled_update_group_action_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledUpdateGroupActions = ScheduledUpdateGroupActions)
  output <- .autoscaling$batch_put_scheduled_update_group_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$batch_put_scheduled_update_group_action <- autoscaling_batch_put_scheduled_update_group_action

#' Cancels an instance refresh or rollback that is in progress
#'
#' @description
#' Cancels an instance refresh or rollback that is in progress. If an instance refresh or rollback is not in progress, an `ActiveInstanceRefreshNotFound` error occurs.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_cancel_instance_refresh/](https://www.paws-r-sdk.com/docs/autoscaling_cancel_instance_refresh/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @keywords internal
#'
#' @rdname autoscaling_cancel_instance_refresh
autoscaling_cancel_instance_refresh <- function(AutoScalingGroupName) {
  op <- new_operation(
    name = "CancelInstanceRefresh",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$cancel_instance_refresh_input(AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$cancel_instance_refresh_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$cancel_instance_refresh <- autoscaling_cancel_instance_refresh

#' Completes the lifecycle action for the specified token or instance with
#' the specified result
#'
#' @description
#' Completes the lifecycle action for the specified token or instance with the specified result.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_complete_lifecycle_action/](https://www.paws-r-sdk.com/docs/autoscaling_complete_lifecycle_action/) for full documentation.
#'
#' @param LifecycleHookName &#91;required&#93; The name of the lifecycle hook.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LifecycleActionToken A universally unique identifier (UUID) that identifies a specific
#' lifecycle action associated with an instance. Amazon EC2 Auto Scaling
#' sends this token to the notification target you specified when you
#' created the lifecycle hook.
#' @param LifecycleActionResult &#91;required&#93; The action for the group to take. You can specify either `CONTINUE` or
#' `ABANDON`.
#' @param InstanceId The ID of the instance.
#'
#' @keywords internal
#'
#' @rdname autoscaling_complete_lifecycle_action
autoscaling_complete_lifecycle_action <- function(LifecycleHookName, AutoScalingGroupName, LifecycleActionToken = NULL, LifecycleActionResult, InstanceId = NULL) {
  op <- new_operation(
    name = "CompleteLifecycleAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$complete_lifecycle_action_input(LifecycleHookName = LifecycleHookName, AutoScalingGroupName = AutoScalingGroupName, LifecycleActionToken = LifecycleActionToken, LifecycleActionResult = LifecycleActionResult, InstanceId = InstanceId)
  output <- .autoscaling$complete_lifecycle_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$complete_lifecycle_action <- autoscaling_complete_lifecycle_action

#' We strongly recommend using a launch template when calling this
#' operation to ensure full functionality for Amazon EC2 Auto Scaling and
#' Amazon EC2
#'
#' @description
#' **We strongly recommend using a launch template when calling this operation to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.**
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_create_auto_scaling_group/](https://www.paws-r-sdk.com/docs/autoscaling_create_auto_scaling_group/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group. This name must be unique per Region
#' per account.
#' 
#' The name can contain any ASCII character 33 to 126 including most
#' punctuation characters, digits, and upper and lowercased letters.
#' 
#' You cannot use a colon (:) in the name.
#' @param LaunchConfigurationName The name of the launch configuration to use to launch instances.
#' 
#' Conditional: You must specify either a launch template (`LaunchTemplate`
#' or `MixedInstancesPolicy`) or a launch configuration
#' (`LaunchConfigurationName` or `InstanceId`).
#' @param LaunchTemplate Information used to specify the launch template and version to use to
#' launch instances.
#' 
#' Conditional: You must specify either a launch template (`LaunchTemplate`
#' or `MixedInstancesPolicy`) or a launch configuration
#' (`LaunchConfigurationName` or `InstanceId`).
#' 
#' The launch template that is specified must be configured for use with an
#' Auto Scaling group. For more information, see [Create a launch template
#' for an Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MixedInstancesPolicy The mixed instances policy. For more information, see [Auto Scaling
#' groups with multiple instance types and purchase
#' options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param InstanceId The ID of the instance used to base the launch configuration on. If
#' specified, Amazon EC2 Auto Scaling uses the configuration values from
#' the specified instance to create a new launch configuration. To get the
#' instance ID, use the Amazon EC2
#' [DescribeInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html)
#' API operation. For more information, see [Create an Auto Scaling group
#' using parameters from an existing
#' instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MinSize &#91;required&#93; The minimum size of the group.
#' @param MaxSize &#91;required&#93; The maximum size of the group.
#' 
#' With a mixed instances policy that uses instance weighting, Amazon EC2
#' Auto Scaling may need to go above `MaxSize` to meet your capacity
#' requirements. In this event, Amazon EC2 Auto Scaling will never go above
#' `MaxSize` by more than your largest instance weight (weights that define
#' how many units each instance contributes to the desired capacity of the
#' group).
#' @param DesiredCapacity The desired capacity is the initial capacity of the Auto Scaling group
#' at the time of its creation and the capacity it attempts to maintain. It
#' can scale beyond this capacity if you configure auto scaling. This
#' number must be greater than or equal to the minimum size of the group
#' and less than or equal to the maximum size of the group. If you do not
#' specify a desired capacity, the default is the minimum size of the
#' group.
#' @param DefaultCooldown *Only needed if you use simple scaling policies.*
#' 
#' The amount of time, in seconds, between one scaling activity ending and
#' another one starting due to simple scaling policies. For more
#' information, see [Scaling cooldowns for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Default: `300` seconds
#' @param AvailabilityZones A list of Availability Zones where instances in the Auto Scaling group
#' can be created. Used for launching into the default VPC subnet in each
#' Availability Zone when not using the `VPCZoneIdentifier` property, or
#' for attaching a network interface when an existing network interface ID
#' is specified in a launch template.
#' @param LoadBalancerNames A list of Classic Load Balancers associated with this Auto Scaling
#' group. For Application Load Balancers, Network Load Balancers, and
#' Gateway Load Balancers, specify the `TargetGroupARNs` property instead.
#' @param TargetGroupARNs The Amazon Resource Names (ARN) of the Elastic Load Balancing target
#' groups to associate with the Auto Scaling group. Instances are
#' registered as targets with the target groups. The target groups receive
#' incoming traffic and route requests to one or more registered targets.
#' For more information, see [Use Elastic Load Balancing to distribute
#' traffic across the instances in your Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param HealthCheckType A comma-separated value string of one or more health check types.
#' 
#' The valid values are `EC2`, `EBS`, `ELB`, and `VPC_LATTICE`. `EC2` is
#' the default health check and cannot be disabled. For more information,
#' see [Health checks for instances in an Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Only specify `EC2` if you must clear a value that was previously set.
#' @param HealthCheckGracePeriod The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
#' before checking the health status of an EC2 instance that has come into
#' service and marking it unhealthy due to a failed health check. This is
#' useful if your instances do not immediately pass their health checks
#' after they enter the `InService` state. For more information, see [Set
#' the health check grace period for an Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Default: `0` seconds
#' @param PlacementGroup The name of the placement group into which to launch your instances. For
#' more information, see [Placement
#' groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' A *cluster* placement group is a logical grouping of instances within a
#' single Availability Zone. You cannot specify multiple Availability Zones
#' and a cluster placement group.
#' @param VPCZoneIdentifier A comma-separated list of subnet IDs for a virtual private cloud (VPC)
#' where instances in the Auto Scaling group can be created. If you specify
#' `VPCZoneIdentifier` with `AvailabilityZones`, the subnets that you
#' specify must reside in those Availability Zones.
#' @param TerminationPolicies A policy or a list of policies that are used to select the instance to
#' terminate. These policies are executed in the order that you list them.
#' For more information, see [Configure termination policies for Amazon EC2
#' Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Valid values: `Default` | `AllocationStrategy` |
#' `ClosestToNextInstanceHour` | `NewestInstance` | `OldestInstance` |
#' `OldestLaunchConfiguration` | `OldestLaunchTemplate` |
#' `arn:aws:lambda:region:account-id:function:my-function:my-alias`
#' @param NewInstancesProtectedFromScaleIn Indicates whether newly launched instances are protected from
#' termination by Amazon EC2 Auto Scaling when scaling in. For more
#' information about preventing instances from terminating on scale in, see
#' [Use instance scale-in
#' protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param CapacityRebalance Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity
#' Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon
#' EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2
#' notifies that a Spot Instance is at an elevated risk of interruption.
#' After launching a new instance, it then terminates an old instance. For
#' more information, see [Use Capacity Rebalancing to handle Amazon EC2
#' Spot
#' Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html)
#' in the in the *Amazon EC2 Auto Scaling User Guide*.
#' @param LifecycleHookSpecificationList One or more lifecycle hooks to add to the Auto Scaling group before
#' instances are launched.
#' @param Tags One or more tags. You can tag your Auto Scaling group and propagate the
#' tags to the Amazon EC2 instances it launches. Tags are not propagated to
#' Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags
#' in a launch template but use caution. If the launch template specifies
#' an instance tag with a key that is also specified for the Auto Scaling
#' group, Amazon EC2 Auto Scaling overrides the value of that instance tag
#' with the value specified by the Auto Scaling group. For more
#' information, see [Tag Auto Scaling groups and
#' instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param ServiceLinkedRoleARN The Amazon Resource Name (ARN) of the service-linked role that the Auto
#' Scaling group uses to call other Amazon Web Services service on your
#' behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role
#' named `AWSServiceRoleForAutoScaling`, which it creates if it does not
#' exist. For more information, see [Service-linked
#' roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MaxInstanceLifetime The maximum amount of time, in seconds, that an instance can be in
#' service. The default is null. If specified, the value must be either 0
#' or a number equal to or greater than 86,400 seconds (1 day). For more
#' information, see [Replace Auto Scaling instances based on maximum
#' instance
#' lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param Context Reserved.
#' @param DesiredCapacityType The unit of measurement for the value specified for desired capacity.
#' Amazon EC2 Auto Scaling supports `DesiredCapacityType` for
#' attribute-based instance type selection only. For more information, see
#' [Create a mixed instances group using attribute-based instance type
#' selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' By default, Amazon EC2 Auto Scaling specifies `units`, which translates
#' into number of instances.
#' 
#' Valid values: `units` | `vcpu` | `memory-mib`
#' @param DefaultInstanceWarmup The amount of time, in seconds, until a new instance is considered to
#' have finished initializing and resource consumption to become stable
#' after it enters the `InService` state.
#' 
#' During an instance refresh, Amazon EC2 Auto Scaling waits for the
#' warm-up period after it replaces an instance before it moves on to
#' replacing the next instance. Amazon EC2 Auto Scaling also waits for the
#' warm-up period before aggregating the metrics for new instances with
#' existing instances in the Amazon CloudWatch metrics that are used for
#' scaling, resulting in more reliable usage data. For more information,
#' see [Set the default instance warmup for an Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' To manage various warm-up settings at the group level, we recommend that
#' you set the default instance warmup, *even if it is set to 0 seconds*.
#' To remove a value that you previously set, include the property but
#' specify `-1` for the value. However, we strongly recommend keeping the
#' default instance warmup enabled by specifying a value of `0` or other
#' nominal value.
#' 
#' Default: None
#' @param TrafficSources The list of traffic sources to attach to this Auto Scaling group. You
#' can use any of the following as traffic sources for an Auto Scaling
#' group: Classic Load Balancer, Application Load Balancer, Gateway Load
#' Balancer, Network Load Balancer, and VPC Lattice.
#' @param InstanceMaintenancePolicy An instance maintenance policy. For more information, see [Set instance
#' maintenance
#' policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @keywords internal
#'
#' @rdname autoscaling_create_auto_scaling_group
autoscaling_create_auto_scaling_group <- function(AutoScalingGroupName, LaunchConfigurationName = NULL, LaunchTemplate = NULL, MixedInstancesPolicy = NULL, InstanceId = NULL, MinSize, MaxSize, DesiredCapacity = NULL, DefaultCooldown = NULL, AvailabilityZones = NULL, LoadBalancerNames = NULL, TargetGroupARNs = NULL, HealthCheckType = NULL, HealthCheckGracePeriod = NULL, PlacementGroup = NULL, VPCZoneIdentifier = NULL, TerminationPolicies = NULL, NewInstancesProtectedFromScaleIn = NULL, CapacityRebalance = NULL, LifecycleHookSpecificationList = NULL, Tags = NULL, ServiceLinkedRoleARN = NULL, MaxInstanceLifetime = NULL, Context = NULL, DesiredCapacityType = NULL, DefaultInstanceWarmup = NULL, TrafficSources = NULL, InstanceMaintenancePolicy = NULL) {
  op <- new_operation(
    name = "CreateAutoScalingGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$create_auto_scaling_group_input(AutoScalingGroupName = AutoScalingGroupName, LaunchConfigurationName = LaunchConfigurationName, LaunchTemplate = LaunchTemplate, MixedInstancesPolicy = MixedInstancesPolicy, InstanceId = InstanceId, MinSize = MinSize, MaxSize = MaxSize, DesiredCapacity = DesiredCapacity, DefaultCooldown = DefaultCooldown, AvailabilityZones = AvailabilityZones, LoadBalancerNames = LoadBalancerNames, TargetGroupARNs = TargetGroupARNs, HealthCheckType = HealthCheckType, HealthCheckGracePeriod = HealthCheckGracePeriod, PlacementGroup = PlacementGroup, VPCZoneIdentifier = VPCZoneIdentifier, TerminationPolicies = TerminationPolicies, NewInstancesProtectedFromScaleIn = NewInstancesProtectedFromScaleIn, CapacityRebalance = CapacityRebalance, LifecycleHookSpecificationList = LifecycleHookSpecificationList, Tags = Tags, ServiceLinkedRoleARN = ServiceLinkedRoleARN, MaxInstanceLifetime = MaxInstanceLifetime, Context = Context, DesiredCapacityType = DesiredCapacityType, DefaultInstanceWarmup = DefaultInstanceWarmup, TrafficSources = TrafficSources, InstanceMaintenancePolicy = InstanceMaintenancePolicy)
  output <- .autoscaling$create_auto_scaling_group_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$create_auto_scaling_group <- autoscaling_create_auto_scaling_group

#' Creates a launch configuration
#'
#' @description
#' Creates a launch configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_create_launch_configuration/](https://www.paws-r-sdk.com/docs/autoscaling_create_launch_configuration/) for full documentation.
#'
#' @param LaunchConfigurationName &#91;required&#93; The name of the launch configuration. This name must be unique per
#' Region per account.
#' @param ImageId The ID of the Amazon Machine Image (AMI) that was assigned during
#' registration. For more information, see [Find a Linux
#' AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' If you specify `InstanceId`, an `ImageId` is not required.
#' @param KeyName The name of the key pair. For more information, see [Amazon EC2 key
#' pairs and Amazon EC2
#' instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param SecurityGroups A list that contains the security group IDs to assign to the instances
#' in the Auto Scaling group. For more information, see [Control traffic to
#' your Amazon Web Services resources using security
#' groups](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-security-groups.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' @param ClassicLinkVPCId Available for backward compatibility.
#' @param ClassicLinkVPCSecurityGroups Available for backward compatibility.
#' @param UserData The user data to make available to the launched EC2 instances. For more
#' information, see [Instance metadata and user
#' data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
#' (Linux) and [Instance metadata and user
#' data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
#' (Windows). If you are using a command line tool, base64-encoding is
#' performed for you, and you can load the text from a file. Otherwise, you
#' must provide base64-encoded text. User data is limited to 16 KB.
#' @param InstanceId The ID of the instance to use to create the launch configuration. The
#' new launch configuration derives attributes from the instance, except
#' for the block device mapping.
#' 
#' To create a launch configuration with a block device mapping or override
#' any other instance attributes, specify them as part of the same request.
#' 
#' For more information, see [Create a launch
#' configuration](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param InstanceType Specifies the instance type of the EC2 instance. For information about
#' available instance types, see [Available instance
#' types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' If you specify `InstanceId`, an `InstanceType` is not required.
#' @param KernelId The ID of the kernel associated with the AMI.
#' 
#' We recommend that you use PV-GRUB instead of kernels and RAM disks. For
#' more information, see [User provided
#' kernels](https://docs.aws.amazon.com/linux/al2/ug/UserProvidedKernels.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param RamdiskId The ID of the RAM disk to select.
#' 
#' We recommend that you use PV-GRUB instead of kernels and RAM disks. For
#' more information, see [User provided
#' kernels](https://docs.aws.amazon.com/linux/al2/ug/UserProvidedKernels.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param BlockDeviceMappings The block device mapping entries that define the block devices to attach
#' to the instances at launch. By default, the block devices specified in
#' the block device mapping for the AMI are used. For more information, see
#' [Block device
#' mappings](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param InstanceMonitoring Controls whether instances in this group are launched with detailed
#' (`true`) or basic (`false`) monitoring.
#' 
#' The default value is `true` (enabled).
#' 
#' When detailed monitoring is enabled, Amazon CloudWatch generates metrics
#' every minute and your account is charged a fee. When you disable
#' detailed monitoring, CloudWatch generates metrics every 5 minutes. For
#' more information, see [Configure monitoring for Auto Scaling
#' instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/enable-as-instance-metrics.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param SpotPrice The maximum hourly price to be paid for any Spot Instance launched to
#' fulfill the request. Spot Instances are launched when the price you
#' specify exceeds the current Spot price. For more information, see
#' [Request Spot Instances for fault-tolerant and flexible
#' applications](https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Valid Range: Minimum value of 0.001
#' 
#' When you change your maximum price by creating a new launch
#' configuration, running instances will continue to run as long as the
#' maximum price for those running instances is higher than the current
#' Spot price.
#' @param IamInstanceProfile The name or the Amazon Resource Name (ARN) of the instance profile
#' associated with the IAM role for the instance. The instance profile
#' contains the IAM role. For more information, see [IAM role for
#' applications that run on Amazon EC2
#' instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param EbsOptimized Specifies whether the launch configuration is optimized for EBS I/O
#' (`true`) or not (`false`). The optimization provides dedicated
#' throughput to Amazon EBS and an optimized configuration stack to provide
#' optimal I/O performance. This optimization is not available with all
#' instance types. Additional fees are incurred when you enable EBS
#' optimization for an instance type that is not EBS-optimized by default.
#' For more information, see [Amazon EBS-optimized
#' instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' The default value is `false`.
#' @param AssociatePublicIpAddress Specifies whether to assign a public IPv4 address to the group's
#' instances. If the instance is launched into a default subnet, the
#' default is to assign a public IPv4 address, unless you disabled the
#' option to assign a public IPv4 address on the subnet. If the instance is
#' launched into a nondefault subnet, the default is not to assign a public
#' IPv4 address, unless you enabled the option to assign a public IPv4
#' address on the subnet.
#' 
#' If you specify `true`, each instance in the Auto Scaling group receives
#' a unique public IPv4 address. For more information, see [Provide network
#' connectivity for your Auto Scaling instances using Amazon
#' VPC](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' If you specify this property, you must specify at least one subnet for
#' `VPCZoneIdentifier` when you create your group.
#' @param PlacementTenancy The tenancy of the instance, either `default` or `dedicated`. An
#' instance with `dedicated` tenancy runs on isolated, single-tenant
#' hardware and can only be launched into a VPC. To launch dedicated
#' instances into a shared tenancy VPC (a VPC with the instance placement
#' tenancy attribute set to `default`), you must set the value of this
#' property to `dedicated`.
#' 
#' If you specify `PlacementTenancy`, you must specify at least one subnet
#' for `VPCZoneIdentifier` when you create your group.
#' 
#' Valid values: `default` | `dedicated`
#' @param MetadataOptions The metadata options for the instances. For more information, see
#' [Configure the instance metadata
#' options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @keywords internal
#'
#' @rdname autoscaling_create_launch_configuration
autoscaling_create_launch_configuration <- function(LaunchConfigurationName, ImageId = NULL, KeyName = NULL, SecurityGroups = NULL, ClassicLinkVPCId = NULL, ClassicLinkVPCSecurityGroups = NULL, UserData = NULL, InstanceId = NULL, InstanceType = NULL, KernelId = NULL, RamdiskId = NULL, BlockDeviceMappings = NULL, InstanceMonitoring = NULL, SpotPrice = NULL, IamInstanceProfile = NULL, EbsOptimized = NULL, AssociatePublicIpAddress = NULL, PlacementTenancy = NULL, MetadataOptions = NULL) {
  op <- new_operation(
    name = "CreateLaunchConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$create_launch_configuration_input(LaunchConfigurationName = LaunchConfigurationName, ImageId = ImageId, KeyName = KeyName, SecurityGroups = SecurityGroups, ClassicLinkVPCId = ClassicLinkVPCId, ClassicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroups, UserData = UserData, InstanceId = InstanceId, InstanceType = InstanceType, KernelId = KernelId, RamdiskId = RamdiskId, BlockDeviceMappings = BlockDeviceMappings, InstanceMonitoring = InstanceMonitoring, SpotPrice = SpotPrice, IamInstanceProfile = IamInstanceProfile, EbsOptimized = EbsOptimized, AssociatePublicIpAddress = AssociatePublicIpAddress, PlacementTenancy = PlacementTenancy, MetadataOptions = MetadataOptions)
  output <- .autoscaling$create_launch_configuration_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$create_launch_configuration <- autoscaling_create_launch_configuration

#' Creates or updates tags for the specified Auto Scaling group
#'
#' @description
#' Creates or updates tags for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_create_or_update_tags/](https://www.paws-r-sdk.com/docs/autoscaling_create_or_update_tags/) for full documentation.
#'
#' @param Tags &#91;required&#93; One or more tags.
#'
#' @keywords internal
#'
#' @rdname autoscaling_create_or_update_tags
autoscaling_create_or_update_tags <- function(Tags) {
  op <- new_operation(
    name = "CreateOrUpdateTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$create_or_update_tags_input(Tags = Tags)
  output <- .autoscaling$create_or_update_tags_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$create_or_update_tags <- autoscaling_create_or_update_tags

#' Deletes the specified Auto Scaling group
#'
#' @description
#' Deletes the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_delete_auto_scaling_group/](https://www.paws-r-sdk.com/docs/autoscaling_delete_auto_scaling_group/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ForceDelete Specifies that the group is to be deleted along with all instances
#' associated with the group, without waiting for all instances to be
#' terminated. This action also deletes any outstanding lifecycle actions
#' associated with the group.
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_auto_scaling_group
autoscaling_delete_auto_scaling_group <- function(AutoScalingGroupName, ForceDelete = NULL) {
  op <- new_operation(
    name = "DeleteAutoScalingGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$delete_auto_scaling_group_input(AutoScalingGroupName = AutoScalingGroupName, ForceDelete = ForceDelete)
  output <- .autoscaling$delete_auto_scaling_group_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_auto_scaling_group <- autoscaling_delete_auto_scaling_group

#' Deletes the specified launch configuration
#'
#' @description
#' Deletes the specified launch configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_delete_launch_configuration/](https://www.paws-r-sdk.com/docs/autoscaling_delete_launch_configuration/) for full documentation.
#'
#' @param LaunchConfigurationName &#91;required&#93; The name of the launch configuration.
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_launch_configuration
autoscaling_delete_launch_configuration <- function(LaunchConfigurationName) {
  op <- new_operation(
    name = "DeleteLaunchConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$delete_launch_configuration_input(LaunchConfigurationName = LaunchConfigurationName)
  output <- .autoscaling$delete_launch_configuration_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_launch_configuration <- autoscaling_delete_launch_configuration

#' Deletes the specified lifecycle hook
#'
#' @description
#' Deletes the specified lifecycle hook.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_delete_lifecycle_hook/](https://www.paws-r-sdk.com/docs/autoscaling_delete_lifecycle_hook/) for full documentation.
#'
#' @param LifecycleHookName &#91;required&#93; The name of the lifecycle hook.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_lifecycle_hook
autoscaling_delete_lifecycle_hook <- function(LifecycleHookName, AutoScalingGroupName) {
  op <- new_operation(
    name = "DeleteLifecycleHook",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$delete_lifecycle_hook_input(LifecycleHookName = LifecycleHookName, AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$delete_lifecycle_hook_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_lifecycle_hook <- autoscaling_delete_lifecycle_hook

#' Deletes the specified notification
#'
#' @description
#' Deletes the specified notification.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_delete_notification_configuration/](https://www.paws-r-sdk.com/docs/autoscaling_delete_notification_configuration/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TopicARN &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon SNS topic.
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_notification_configuration
autoscaling_delete_notification_configuration <- function(AutoScalingGroupName, TopicARN) {
  op <- new_operation(
    name = "DeleteNotificationConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$delete_notification_configuration_input(AutoScalingGroupName = AutoScalingGroupName, TopicARN = TopicARN)
  output <- .autoscaling$delete_notification_configuration_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_notification_configuration <- autoscaling_delete_notification_configuration

#' Deletes the specified scaling policy
#'
#' @description
#' Deletes the specified scaling policy.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_delete_policy/](https://www.paws-r-sdk.com/docs/autoscaling_delete_policy/) for full documentation.
#'
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param PolicyName &#91;required&#93; The name or Amazon Resource Name (ARN) of the policy.
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_policy
autoscaling_delete_policy <- function(AutoScalingGroupName = NULL, PolicyName) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$delete_policy_input(AutoScalingGroupName = AutoScalingGroupName, PolicyName = PolicyName)
  output <- .autoscaling$delete_policy_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_policy <- autoscaling_delete_policy

#' Deletes the specified scheduled action
#'
#' @description
#' Deletes the specified scheduled action.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_delete_scheduled_action/](https://www.paws-r-sdk.com/docs/autoscaling_delete_scheduled_action/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScheduledActionName &#91;required&#93; The name of the action to delete.
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_scheduled_action
autoscaling_delete_scheduled_action <- function(AutoScalingGroupName, ScheduledActionName) {
  op <- new_operation(
    name = "DeleteScheduledAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$delete_scheduled_action_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledActionName = ScheduledActionName)
  output <- .autoscaling$delete_scheduled_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_scheduled_action <- autoscaling_delete_scheduled_action

#' Deletes the specified tags
#'
#' @description
#' Deletes the specified tags.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_delete_tags/](https://www.paws-r-sdk.com/docs/autoscaling_delete_tags/) for full documentation.
#'
#' @param Tags &#91;required&#93; One or more tags.
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_tags
autoscaling_delete_tags <- function(Tags) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$delete_tags_input(Tags = Tags)
  output <- .autoscaling$delete_tags_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_tags <- autoscaling_delete_tags

#' Deletes the warm pool for the specified Auto Scaling group
#'
#' @description
#' Deletes the warm pool for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_delete_warm_pool/](https://www.paws-r-sdk.com/docs/autoscaling_delete_warm_pool/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ForceDelete Specifies that the warm pool is to be deleted along with all of its
#' associated instances, without waiting for all instances to be
#' terminated. This parameter also deletes any outstanding lifecycle
#' actions associated with the warm pool instances.
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_warm_pool
autoscaling_delete_warm_pool <- function(AutoScalingGroupName, ForceDelete = NULL) {
  op <- new_operation(
    name = "DeleteWarmPool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$delete_warm_pool_input(AutoScalingGroupName = AutoScalingGroupName, ForceDelete = ForceDelete)
  output <- .autoscaling$delete_warm_pool_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_warm_pool <- autoscaling_delete_warm_pool

#' Describes the current Amazon EC2 Auto Scaling resource quotas for your
#' account
#'
#' @description
#' Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_account_limits/](https://www.paws-r-sdk.com/docs/autoscaling_describe_account_limits/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_account_limits
autoscaling_describe_account_limits <- function() {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$describe_account_limits_input()
  output <- .autoscaling$describe_account_limits_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_account_limits <- autoscaling_describe_account_limits

#' Describes the available adjustment types for step scaling and simple
#' scaling policies
#'
#' @description
#' Describes the available adjustment types for step scaling and simple scaling policies.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_adjustment_types/](https://www.paws-r-sdk.com/docs/autoscaling_describe_adjustment_types/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_adjustment_types
autoscaling_describe_adjustment_types <- function() {
  op <- new_operation(
    name = "DescribeAdjustmentTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$describe_adjustment_types_input()
  output <- .autoscaling$describe_adjustment_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_adjustment_types <- autoscaling_describe_adjustment_types

#' Gets information about the Auto Scaling groups in the account and Region
#'
#' @description
#' Gets information about the Auto Scaling groups in the account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_auto_scaling_groups/](https://www.paws-r-sdk.com/docs/autoscaling_describe_auto_scaling_groups/) for full documentation.
#'
#' @param AutoScalingGroupNames The names of the Auto Scaling groups. By default, you can only specify
#' up to 50 names. You can optionally increase this limit using the
#' `MaxRecords` property.
#' 
#' If you omit this property, all Auto Scaling groups are described.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#' @param Filters One or more filters to limit the results based on specific tags.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_auto_scaling_groups
autoscaling_describe_auto_scaling_groups <- function(AutoScalingGroupNames = NULL, NextToken = NULL, MaxRecords = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeAutoScalingGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "AutoScalingGroups")
  )
  input <- .autoscaling$describe_auto_scaling_groups_input(AutoScalingGroupNames = AutoScalingGroupNames, NextToken = NextToken, MaxRecords = MaxRecords, Filters = Filters)
  output <- .autoscaling$describe_auto_scaling_groups_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_auto_scaling_groups <- autoscaling_describe_auto_scaling_groups

#' Gets information about the Auto Scaling instances in the account and
#' Region
#'
#' @description
#' Gets information about the Auto Scaling instances in the account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_auto_scaling_instances/](https://www.paws-r-sdk.com/docs/autoscaling_describe_auto_scaling_instances/) for full documentation.
#'
#' @param InstanceIds The IDs of the instances. If you omit this property, all Auto Scaling
#' instances are described. If you specify an ID that does not exist, it is
#' ignored with no error.
#' 
#' Array Members: Maximum number of 50 items.
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `50`.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_auto_scaling_instances
autoscaling_describe_auto_scaling_instances <- function(InstanceIds = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAutoScalingInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "AutoScalingInstances")
  )
  input <- .autoscaling$describe_auto_scaling_instances_input(InstanceIds = InstanceIds, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .autoscaling$describe_auto_scaling_instances_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_auto_scaling_instances <- autoscaling_describe_auto_scaling_instances

#' Describes the notification types that are supported by Amazon EC2 Auto
#' Scaling
#'
#' @description
#' Describes the notification types that are supported by Amazon EC2 Auto Scaling.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_auto_scaling_notification_types/](https://www.paws-r-sdk.com/docs/autoscaling_describe_auto_scaling_notification_types/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_auto_scaling_notification_types
autoscaling_describe_auto_scaling_notification_types <- function() {
  op <- new_operation(
    name = "DescribeAutoScalingNotificationTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$describe_auto_scaling_notification_types_input()
  output <- .autoscaling$describe_auto_scaling_notification_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_auto_scaling_notification_types <- autoscaling_describe_auto_scaling_notification_types

#' Gets information about the instance refreshes for the specified Auto
#' Scaling group from the previous six weeks
#'
#' @description
#' Gets information about the instance refreshes for the specified Auto Scaling group from the previous six weeks.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_instance_refreshes/](https://www.paws-r-sdk.com/docs/autoscaling_describe_instance_refreshes/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param InstanceRefreshIds One or more instance refresh IDs.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_instance_refreshes
autoscaling_describe_instance_refreshes <- function(AutoScalingGroupName, InstanceRefreshIds = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeInstanceRefreshes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken")
  )
  input <- .autoscaling$describe_instance_refreshes_input(AutoScalingGroupName = AutoScalingGroupName, InstanceRefreshIds = InstanceRefreshIds, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_instance_refreshes_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_instance_refreshes <- autoscaling_describe_instance_refreshes

#' Gets information about the launch configurations in the account and
#' Region
#'
#' @description
#' Gets information about the launch configurations in the account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_launch_configurations/](https://www.paws-r-sdk.com/docs/autoscaling_describe_launch_configurations/) for full documentation.
#'
#' @param LaunchConfigurationNames The launch configuration names. If you omit this property, all launch
#' configurations are described.
#' 
#' Array Members: Maximum number of 50 items.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_launch_configurations
autoscaling_describe_launch_configurations <- function(LaunchConfigurationNames = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeLaunchConfigurations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "LaunchConfigurations")
  )
  input <- .autoscaling$describe_launch_configurations_input(LaunchConfigurationNames = LaunchConfigurationNames, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_launch_configurations_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_launch_configurations <- autoscaling_describe_launch_configurations

#' Describes the available types of lifecycle hooks
#'
#' @description
#' Describes the available types of lifecycle hooks.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_lifecycle_hook_types/](https://www.paws-r-sdk.com/docs/autoscaling_describe_lifecycle_hook_types/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_lifecycle_hook_types
autoscaling_describe_lifecycle_hook_types <- function() {
  op <- new_operation(
    name = "DescribeLifecycleHookTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$describe_lifecycle_hook_types_input()
  output <- .autoscaling$describe_lifecycle_hook_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_lifecycle_hook_types <- autoscaling_describe_lifecycle_hook_types

#' Gets information about the lifecycle hooks for the specified Auto
#' Scaling group
#'
#' @description
#' Gets information about the lifecycle hooks for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_lifecycle_hooks/](https://www.paws-r-sdk.com/docs/autoscaling_describe_lifecycle_hooks/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LifecycleHookNames The names of one or more lifecycle hooks. If you omit this property, all
#' lifecycle hooks are described.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_lifecycle_hooks
autoscaling_describe_lifecycle_hooks <- function(AutoScalingGroupName, LifecycleHookNames = NULL) {
  op <- new_operation(
    name = "DescribeLifecycleHooks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$describe_lifecycle_hooks_input(AutoScalingGroupName = AutoScalingGroupName, LifecycleHookNames = LifecycleHookNames)
  output <- .autoscaling$describe_lifecycle_hooks_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_lifecycle_hooks <- autoscaling_describe_lifecycle_hooks

#' This API operation is superseded by DescribeTrafficSources, which can
#' describe multiple traffic sources types
#'
#' @description
#' This API operation is superseded by [`describe_traffic_sources`][autoscaling_describe_traffic_sources], which can describe multiple traffic sources types. We recommend using [`detach_traffic_sources`][autoscaling_detach_traffic_sources] to simplify how you manage traffic sources. However, we continue to support [`describe_load_balancer_target_groups`][autoscaling_describe_load_balancer_target_groups]. You can use both the original [`describe_load_balancer_target_groups`][autoscaling_describe_load_balancer_target_groups] API operation and [`describe_traffic_sources`][autoscaling_describe_traffic_sources] on the same Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_load_balancer_target_groups/](https://www.paws-r-sdk.com/docs/autoscaling_describe_load_balancer_target_groups/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `100` and the maximum value is `100`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_load_balancer_target_groups
autoscaling_describe_load_balancer_target_groups <- function(AutoScalingGroupName, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancerTargetGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken")
  )
  input <- .autoscaling$describe_load_balancer_target_groups_input(AutoScalingGroupName = AutoScalingGroupName, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_load_balancer_target_groups_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_load_balancer_target_groups <- autoscaling_describe_load_balancer_target_groups

#' This API operation is superseded by DescribeTrafficSources, which can
#' describe multiple traffic sources types
#'
#' @description
#' This API operation is superseded by [`describe_traffic_sources`][autoscaling_describe_traffic_sources], which can describe multiple traffic sources types. We recommend using [`describe_traffic_sources`][autoscaling_describe_traffic_sources] to simplify how you manage traffic sources. However, we continue to support [`describe_load_balancers`][autoscaling_describe_load_balancers]. You can use both the original [`describe_load_balancers`][autoscaling_describe_load_balancers] API operation and [`describe_traffic_sources`][autoscaling_describe_traffic_sources] on the same Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_load_balancers/](https://www.paws-r-sdk.com/docs/autoscaling_describe_load_balancers/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `100` and the maximum value is `100`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_load_balancers
autoscaling_describe_load_balancers <- function(AutoScalingGroupName, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken")
  )
  input <- .autoscaling$describe_load_balancers_input(AutoScalingGroupName = AutoScalingGroupName, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_load_balancers_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_load_balancers <- autoscaling_describe_load_balancers

#' Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling
#'
#' @description
#' Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_metric_collection_types/](https://www.paws-r-sdk.com/docs/autoscaling_describe_metric_collection_types/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_metric_collection_types
autoscaling_describe_metric_collection_types <- function() {
  op <- new_operation(
    name = "DescribeMetricCollectionTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$describe_metric_collection_types_input()
  output <- .autoscaling$describe_metric_collection_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_metric_collection_types <- autoscaling_describe_metric_collection_types

#' Gets information about the Amazon SNS notifications that are configured
#' for one or more Auto Scaling groups
#'
#' @description
#' Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_notification_configurations/](https://www.paws-r-sdk.com/docs/autoscaling_describe_notification_configurations/) for full documentation.
#'
#' @param AutoScalingGroupNames The name of the Auto Scaling group.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_notification_configurations
autoscaling_describe_notification_configurations <- function(AutoScalingGroupNames = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeNotificationConfigurations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "NotificationConfigurations")
  )
  input <- .autoscaling$describe_notification_configurations_input(AutoScalingGroupNames = AutoScalingGroupNames, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_notification_configurations_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_notification_configurations <- autoscaling_describe_notification_configurations

#' Gets information about the scaling policies in the account and Region
#'
#' @description
#' Gets information about the scaling policies in the account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_policies/](https://www.paws-r-sdk.com/docs/autoscaling_describe_policies/) for full documentation.
#'
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param PolicyNames The names of one or more policies. If you omit this property, all
#' policies are described. If a group name is provided, the results are
#' limited to that group. If you specify an unknown policy name, it is
#' ignored with no error.
#' 
#' Array Members: Maximum number of 50 items.
#' @param PolicyTypes One or more policy types. The valid values are `SimpleScaling`,
#' `StepScaling`, `TargetTrackingScaling`, and `PredictiveScaling`.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to be returned with each call. The default
#' value is `50` and the maximum value is `100`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_policies
autoscaling_describe_policies <- function(AutoScalingGroupName = NULL, PolicyNames = NULL, PolicyTypes = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribePolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "ScalingPolicies")
  )
  input <- .autoscaling$describe_policies_input(AutoScalingGroupName = AutoScalingGroupName, PolicyNames = PolicyNames, PolicyTypes = PolicyTypes, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_policies_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_policies <- autoscaling_describe_policies

#' Gets information about the scaling activities in the account and Region
#'
#' @description
#' Gets information about the scaling activities in the account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_scaling_activities/](https://www.paws-r-sdk.com/docs/autoscaling_describe_scaling_activities/) for full documentation.
#'
#' @param ActivityIds The activity IDs of the desired scaling activities. If you omit this
#' property, all activities for the past six weeks are described. If
#' unknown activities are requested, they are ignored with no error. If you
#' specify an Auto Scaling group, the results are limited to that group.
#' 
#' Array Members: Maximum number of 50 IDs.
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param IncludeDeletedGroups Indicates whether to include scaling activity from deleted Auto Scaling
#' groups.
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `100` and the maximum value is `100`.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_scaling_activities
autoscaling_describe_scaling_activities <- function(ActivityIds = NULL, AutoScalingGroupName = NULL, IncludeDeletedGroups = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingActivities",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "Activities")
  )
  input <- .autoscaling$describe_scaling_activities_input(ActivityIds = ActivityIds, AutoScalingGroupName = AutoScalingGroupName, IncludeDeletedGroups = IncludeDeletedGroups, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .autoscaling$describe_scaling_activities_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_scaling_activities <- autoscaling_describe_scaling_activities

#' Describes the scaling process types for use with the ResumeProcesses and
#' SuspendProcesses APIs
#'
#' @description
#' Describes the scaling process types for use with the [`resume_processes`][autoscaling_resume_processes] and [`suspend_processes`][autoscaling_suspend_processes] APIs.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_scaling_process_types/](https://www.paws-r-sdk.com/docs/autoscaling_describe_scaling_process_types/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_scaling_process_types
autoscaling_describe_scaling_process_types <- function() {
  op <- new_operation(
    name = "DescribeScalingProcessTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$describe_scaling_process_types_input()
  output <- .autoscaling$describe_scaling_process_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_scaling_process_types <- autoscaling_describe_scaling_process_types

#' Gets information about the scheduled actions that haven't run or that
#' have not reached their end time
#'
#' @description
#' Gets information about the scheduled actions that haven't run or that have not reached their end time.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_scheduled_actions/](https://www.paws-r-sdk.com/docs/autoscaling_describe_scheduled_actions/) for full documentation.
#'
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param ScheduledActionNames The names of one or more scheduled actions. If you omit this property,
#' all scheduled actions are described. If you specify an unknown scheduled
#' action, it is ignored with no error.
#' 
#' Array Members: Maximum number of 50 actions.
#' @param StartTime The earliest scheduled start time to return. If scheduled action names
#' are provided, this property is ignored.
#' @param EndTime The latest scheduled start time to return. If scheduled action names are
#' provided, this property is ignored.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_scheduled_actions
autoscaling_describe_scheduled_actions <- function(AutoScalingGroupName = NULL, ScheduledActionNames = NULL, StartTime = NULL, EndTime = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeScheduledActions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "ScheduledUpdateGroupActions")
  )
  input <- .autoscaling$describe_scheduled_actions_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledActionNames = ScheduledActionNames, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_scheduled_actions_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_scheduled_actions <- autoscaling_describe_scheduled_actions

#' Describes the specified tags
#'
#' @description
#' Describes the specified tags.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_tags/](https://www.paws-r-sdk.com/docs/autoscaling_describe_tags/) for full documentation.
#'
#' @param Filters One or more filters to scope the tags to return. The maximum number of
#' filters per filter type (for example, `auto-scaling-group`) is 1000.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_tags
autoscaling_describe_tags <- function(Filters = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "Tags")
  )
  input <- .autoscaling$describe_tags_input(Filters = Filters, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_tags_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_tags <- autoscaling_describe_tags

#' Describes the termination policies supported by Amazon EC2 Auto Scaling
#'
#' @description
#' Describes the termination policies supported by Amazon EC2 Auto Scaling.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_termination_policy_types/](https://www.paws-r-sdk.com/docs/autoscaling_describe_termination_policy_types/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_termination_policy_types
autoscaling_describe_termination_policy_types <- function() {
  op <- new_operation(
    name = "DescribeTerminationPolicyTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$describe_termination_policy_types_input()
  output <- .autoscaling$describe_termination_policy_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_termination_policy_types <- autoscaling_describe_termination_policy_types

#' Gets information about the traffic sources for the specified Auto
#' Scaling group
#'
#' @description
#' Gets information about the traffic sources for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_traffic_sources/](https://www.paws-r-sdk.com/docs/autoscaling_describe_traffic_sources/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TrafficSourceType The traffic source type that you want to describe.
#' 
#' The following lists the valid values:
#' 
#' -   `elb` if the traffic source is a Classic Load Balancer.
#' 
#' -   `elbv2` if the traffic source is a Application Load Balancer,
#'     Gateway Load Balancer, or Network Load Balancer.
#' 
#' -   `vpc-lattice` if the traffic source is VPC Lattice.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The maximum value
#' is `50`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_traffic_sources
autoscaling_describe_traffic_sources <- function(AutoScalingGroupName, TrafficSourceType = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeTrafficSources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken")
  )
  input <- .autoscaling$describe_traffic_sources_input(AutoScalingGroupName = AutoScalingGroupName, TrafficSourceType = TrafficSourceType, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_traffic_sources_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_traffic_sources <- autoscaling_describe_traffic_sources

#' Gets information about a warm pool and its instances
#'
#' @description
#' Gets information about a warm pool and its instances.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_describe_warm_pool/](https://www.paws-r-sdk.com/docs/autoscaling_describe_warm_pool/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param MaxRecords The maximum number of instances to return with this call. The maximum
#' value is `50`.
#' @param NextToken The token for the next set of instances to return. (You received this
#' token from a previous call.)
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_warm_pool
autoscaling_describe_warm_pool <- function(AutoScalingGroupName, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWarmPool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxRecords", output_token = "NextToken", result_key = "Instances")
  )
  input <- .autoscaling$describe_warm_pool_input(AutoScalingGroupName = AutoScalingGroupName, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .autoscaling$describe_warm_pool_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_warm_pool <- autoscaling_describe_warm_pool

#' Removes one or more instances from the specified Auto Scaling group
#'
#' @description
#' Removes one or more instances from the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_detach_instances/](https://www.paws-r-sdk.com/docs/autoscaling_detach_instances/) for full documentation.
#'
#' @param InstanceIds The IDs of the instances. You can specify up to 20 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ShouldDecrementDesiredCapacity &#91;required&#93; Indicates whether the Auto Scaling group decrements the desired capacity
#' value by the number of instances detached.
#'
#' @keywords internal
#'
#' @rdname autoscaling_detach_instances
autoscaling_detach_instances <- function(InstanceIds = NULL, AutoScalingGroupName, ShouldDecrementDesiredCapacity) {
  op <- new_operation(
    name = "DetachInstances",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$detach_instances_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName, ShouldDecrementDesiredCapacity = ShouldDecrementDesiredCapacity)
  output <- .autoscaling$detach_instances_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$detach_instances <- autoscaling_detach_instances

#' This API operation is superseded by DetachTrafficSources, which can
#' detach multiple traffic sources types
#'
#' @description
#' This API operation is superseded by [`detach_traffic_sources`][autoscaling_detach_traffic_sources], which can detach multiple traffic sources types. We recommend using [`detach_traffic_sources`][autoscaling_detach_traffic_sources] to simplify how you manage traffic sources. However, we continue to support [`detach_load_balancer_target_groups`][autoscaling_detach_load_balancer_target_groups]. You can use both the original [`detach_load_balancer_target_groups`][autoscaling_detach_load_balancer_target_groups] API operation and [`detach_traffic_sources`][autoscaling_detach_traffic_sources] on the same Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_detach_load_balancer_target_groups/](https://www.paws-r-sdk.com/docs/autoscaling_detach_load_balancer_target_groups/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TargetGroupARNs &#91;required&#93; The Amazon Resource Names (ARN) of the target groups. You can specify up
#' to 10 target groups.
#'
#' @keywords internal
#'
#' @rdname autoscaling_detach_load_balancer_target_groups
autoscaling_detach_load_balancer_target_groups <- function(AutoScalingGroupName, TargetGroupARNs) {
  op <- new_operation(
    name = "DetachLoadBalancerTargetGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$detach_load_balancer_target_groups_input(AutoScalingGroupName = AutoScalingGroupName, TargetGroupARNs = TargetGroupARNs)
  output <- .autoscaling$detach_load_balancer_target_groups_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$detach_load_balancer_target_groups <- autoscaling_detach_load_balancer_target_groups

#' This API operation is superseded by DetachTrafficSources, which can
#' detach multiple traffic sources types
#'
#' @description
#' This API operation is superseded by [`detach_traffic_sources`][autoscaling_detach_traffic_sources], which can detach multiple traffic sources types. We recommend using [`detach_traffic_sources`][autoscaling_detach_traffic_sources] to simplify how you manage traffic sources. However, we continue to support [`detach_load_balancers`][autoscaling_detach_load_balancers]. You can use both the original [`detach_load_balancers`][autoscaling_detach_load_balancers] API operation and [`detach_traffic_sources`][autoscaling_detach_traffic_sources] on the same Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_detach_load_balancers/](https://www.paws-r-sdk.com/docs/autoscaling_detach_load_balancers/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LoadBalancerNames &#91;required&#93; The names of the load balancers. You can specify up to 10 load
#' balancers.
#'
#' @keywords internal
#'
#' @rdname autoscaling_detach_load_balancers
autoscaling_detach_load_balancers <- function(AutoScalingGroupName, LoadBalancerNames) {
  op <- new_operation(
    name = "DetachLoadBalancers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$detach_load_balancers_input(AutoScalingGroupName = AutoScalingGroupName, LoadBalancerNames = LoadBalancerNames)
  output <- .autoscaling$detach_load_balancers_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$detach_load_balancers <- autoscaling_detach_load_balancers

#' Detaches one or more traffic sources from the specified Auto Scaling
#' group
#'
#' @description
#' Detaches one or more traffic sources from the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_detach_traffic_sources/](https://www.paws-r-sdk.com/docs/autoscaling_detach_traffic_sources/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TrafficSources &#91;required&#93; The unique identifiers of one or more traffic sources. You can specify
#' up to 10 traffic sources.
#'
#' @keywords internal
#'
#' @rdname autoscaling_detach_traffic_sources
autoscaling_detach_traffic_sources <- function(AutoScalingGroupName, TrafficSources) {
  op <- new_operation(
    name = "DetachTrafficSources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$detach_traffic_sources_input(AutoScalingGroupName = AutoScalingGroupName, TrafficSources = TrafficSources)
  output <- .autoscaling$detach_traffic_sources_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$detach_traffic_sources <- autoscaling_detach_traffic_sources

#' Disables group metrics collection for the specified Auto Scaling group
#'
#' @description
#' Disables group metrics collection for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_disable_metrics_collection/](https://www.paws-r-sdk.com/docs/autoscaling_disable_metrics_collection/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param Metrics Identifies the metrics to disable.
#' 
#' You can specify one or more of the following metrics:
#' 
#' -   `GroupMinSize`
#' 
#' -   `GroupMaxSize`
#' 
#' -   `GroupDesiredCapacity`
#' 
#' -   `GroupInServiceInstances`
#' 
#' -   `GroupPendingInstances`
#' 
#' -   `GroupStandbyInstances`
#' 
#' -   `GroupTerminatingInstances`
#' 
#' -   `GroupTotalInstances`
#' 
#' -   `GroupInServiceCapacity`
#' 
#' -   `GroupPendingCapacity`
#' 
#' -   `GroupStandbyCapacity`
#' 
#' -   `GroupTerminatingCapacity`
#' 
#' -   `GroupTotalCapacity`
#' 
#' -   `WarmPoolDesiredCapacity`
#' 
#' -   `WarmPoolWarmedCapacity`
#' 
#' -   `WarmPoolPendingCapacity`
#' 
#' -   `WarmPoolTerminatingCapacity`
#' 
#' -   `WarmPoolTotalCapacity`
#' 
#' -   `GroupAndWarmPoolDesiredCapacity`
#' 
#' -   `GroupAndWarmPoolTotalCapacity`
#' 
#' If you omit this property, all metrics are disabled.
#' 
#' For more information, see [Amazon CloudWatch metrics for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @keywords internal
#'
#' @rdname autoscaling_disable_metrics_collection
autoscaling_disable_metrics_collection <- function(AutoScalingGroupName, Metrics = NULL) {
  op <- new_operation(
    name = "DisableMetricsCollection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$disable_metrics_collection_input(AutoScalingGroupName = AutoScalingGroupName, Metrics = Metrics)
  output <- .autoscaling$disable_metrics_collection_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$disable_metrics_collection <- autoscaling_disable_metrics_collection

#' Enables group metrics collection for the specified Auto Scaling group
#'
#' @description
#' Enables group metrics collection for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_enable_metrics_collection/](https://www.paws-r-sdk.com/docs/autoscaling_enable_metrics_collection/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param Metrics Identifies the metrics to enable.
#' 
#' You can specify one or more of the following metrics:
#' 
#' -   `GroupMinSize`
#' 
#' -   `GroupMaxSize`
#' 
#' -   `GroupDesiredCapacity`
#' 
#' -   `GroupInServiceInstances`
#' 
#' -   `GroupPendingInstances`
#' 
#' -   `GroupStandbyInstances`
#' 
#' -   `GroupTerminatingInstances`
#' 
#' -   `GroupTotalInstances`
#' 
#' -   `GroupInServiceCapacity`
#' 
#' -   `GroupPendingCapacity`
#' 
#' -   `GroupStandbyCapacity`
#' 
#' -   `GroupTerminatingCapacity`
#' 
#' -   `GroupTotalCapacity`
#' 
#' -   `WarmPoolDesiredCapacity`
#' 
#' -   `WarmPoolWarmedCapacity`
#' 
#' -   `WarmPoolPendingCapacity`
#' 
#' -   `WarmPoolTerminatingCapacity`
#' 
#' -   `WarmPoolTotalCapacity`
#' 
#' -   `GroupAndWarmPoolDesiredCapacity`
#' 
#' -   `GroupAndWarmPoolTotalCapacity`
#' 
#' If you specify `Granularity` and don't specify any metrics, all metrics
#' are enabled.
#' 
#' For more information, see [Amazon CloudWatch metrics for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-metrics.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param Granularity &#91;required&#93; The frequency at which Amazon EC2 Auto Scaling sends aggregated data to
#' CloudWatch. The only valid value is `1Minute`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_enable_metrics_collection
autoscaling_enable_metrics_collection <- function(AutoScalingGroupName, Metrics = NULL, Granularity) {
  op <- new_operation(
    name = "EnableMetricsCollection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$enable_metrics_collection_input(AutoScalingGroupName = AutoScalingGroupName, Metrics = Metrics, Granularity = Granularity)
  output <- .autoscaling$enable_metrics_collection_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$enable_metrics_collection <- autoscaling_enable_metrics_collection

#' Moves the specified instances into the standby state
#'
#' @description
#' Moves the specified instances into the standby state.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_enter_standby/](https://www.paws-r-sdk.com/docs/autoscaling_enter_standby/) for full documentation.
#'
#' @param InstanceIds The IDs of the instances. You can specify up to 20 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ShouldDecrementDesiredCapacity &#91;required&#93; Indicates whether to decrement the desired capacity of the Auto Scaling
#' group by the number of instances moved to `Standby` mode.
#'
#' @keywords internal
#'
#' @rdname autoscaling_enter_standby
autoscaling_enter_standby <- function(InstanceIds = NULL, AutoScalingGroupName, ShouldDecrementDesiredCapacity) {
  op <- new_operation(
    name = "EnterStandby",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$enter_standby_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName, ShouldDecrementDesiredCapacity = ShouldDecrementDesiredCapacity)
  output <- .autoscaling$enter_standby_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$enter_standby <- autoscaling_enter_standby

#' Executes the specified policy
#'
#' @description
#' Executes the specified policy. This can be useful for testing the design of your scaling policy.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_execute_policy/](https://www.paws-r-sdk.com/docs/autoscaling_execute_policy/) for full documentation.
#'
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param PolicyName &#91;required&#93; The name or ARN of the policy.
#' @param HonorCooldown Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period
#' to complete before executing the policy.
#' 
#' Valid only if the policy type is `SimpleScaling`. For more information,
#' see [Scaling cooldowns for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MetricValue The metric value to compare to `BreachThreshold`. This enables you to
#' execute a policy of type `StepScaling` and determine which step
#' adjustment to use. For example, if the breach threshold is 50 and you
#' want to use a step adjustment with a lower bound of 0 and an upper bound
#' of 10, you can set the metric value to 59.
#' 
#' If you specify a metric value that doesn't correspond to a step
#' adjustment for the policy, the call returns an error.
#' 
#' Required if the policy type is `StepScaling` and not supported
#' otherwise.
#' @param BreachThreshold The breach threshold for the alarm.
#' 
#' Required if the policy type is `StepScaling` and not supported
#' otherwise.
#'
#' @keywords internal
#'
#' @rdname autoscaling_execute_policy
autoscaling_execute_policy <- function(AutoScalingGroupName = NULL, PolicyName, HonorCooldown = NULL, MetricValue = NULL, BreachThreshold = NULL) {
  op <- new_operation(
    name = "ExecutePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$execute_policy_input(AutoScalingGroupName = AutoScalingGroupName, PolicyName = PolicyName, HonorCooldown = HonorCooldown, MetricValue = MetricValue, BreachThreshold = BreachThreshold)
  output <- .autoscaling$execute_policy_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$execute_policy <- autoscaling_execute_policy

#' Moves the specified instances out of the standby state
#'
#' @description
#' Moves the specified instances out of the standby state.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_exit_standby/](https://www.paws-r-sdk.com/docs/autoscaling_exit_standby/) for full documentation.
#'
#' @param InstanceIds The IDs of the instances. You can specify up to 20 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @keywords internal
#'
#' @rdname autoscaling_exit_standby
autoscaling_exit_standby <- function(InstanceIds = NULL, AutoScalingGroupName) {
  op <- new_operation(
    name = "ExitStandby",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$exit_standby_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$exit_standby_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$exit_standby <- autoscaling_exit_standby

#' Retrieves the forecast data for a predictive scaling policy
#'
#' @description
#' Retrieves the forecast data for a predictive scaling policy.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_get_predictive_scaling_forecast/](https://www.paws-r-sdk.com/docs/autoscaling_get_predictive_scaling_forecast/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param PolicyName &#91;required&#93; The name of the policy.
#' @param StartTime &#91;required&#93; The inclusive start time of the time range for the forecast data to get.
#' At most, the date and time can be one year before the current date and
#' time.
#' @param EndTime &#91;required&#93; The exclusive end time of the time range for the forecast data to get.
#' The maximum time duration between the start and end time is 30 days.
#' 
#' Although this parameter can accept a date and time that is more than two
#' days in the future, the availability of forecast data has limits. Amazon
#' EC2 Auto Scaling only issues forecasts for periods of two days in
#' advance.
#'
#' @keywords internal
#'
#' @rdname autoscaling_get_predictive_scaling_forecast
autoscaling_get_predictive_scaling_forecast <- function(AutoScalingGroupName, PolicyName, StartTime, EndTime) {
  op <- new_operation(
    name = "GetPredictiveScalingForecast",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$get_predictive_scaling_forecast_input(AutoScalingGroupName = AutoScalingGroupName, PolicyName = PolicyName, StartTime = StartTime, EndTime = EndTime)
  output <- .autoscaling$get_predictive_scaling_forecast_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$get_predictive_scaling_forecast <- autoscaling_get_predictive_scaling_forecast

#' Creates or updates a lifecycle hook for the specified Auto Scaling group
#'
#' @description
#' Creates or updates a lifecycle hook for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_put_lifecycle_hook/](https://www.paws-r-sdk.com/docs/autoscaling_put_lifecycle_hook/) for full documentation.
#'
#' @param LifecycleHookName &#91;required&#93; The name of the lifecycle hook.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LifecycleTransition The lifecycle transition. For Auto Scaling groups, there are two major
#' lifecycle transitions.
#' 
#' -   To create a lifecycle hook for scale-out events, specify
#'     `autoscaling:EC2_INSTANCE_LAUNCHING`.
#' 
#' -   To create a lifecycle hook for scale-in events, specify
#'     `autoscaling:EC2_INSTANCE_TERMINATING`.
#' 
#' Required for new lifecycle hooks, but optional when updating existing
#' hooks.
#' @param RoleARN The ARN of the IAM role that allows the Auto Scaling group to publish to
#' the specified notification target.
#' 
#' Valid only if the notification target is an Amazon SNS topic or an
#' Amazon SQS queue. Required for new lifecycle hooks, but optional when
#' updating existing hooks.
#' @param NotificationTargetARN The Amazon Resource Name (ARN) of the notification target that Amazon
#' EC2 Auto Scaling uses to notify you when an instance is in a wait state
#' for the lifecycle hook. You can specify either an Amazon SNS topic or an
#' Amazon SQS queue.
#' 
#' If you specify an empty string, this overrides the current ARN.
#' 
#' This operation uses the JSON format when sending notifications to an
#' Amazon SQS queue, and an email key-value pair format when sending
#' notifications to an Amazon SNS topic.
#' 
#' When you specify a notification target, Amazon EC2 Auto Scaling sends it
#' a test message. Test messages contain the following additional key-value
#' pair: `"Event": "autoscaling:TEST_NOTIFICATION"`.
#' @param NotificationMetadata Additional information that you want to include any time Amazon EC2 Auto
#' Scaling sends a message to the notification target.
#' @param HeartbeatTimeout The maximum time, in seconds, that can elapse before the lifecycle hook
#' times out. The range is from `30` to `7200` seconds. The default value
#' is `3600` seconds (1 hour).
#' @param DefaultResult The action the Auto Scaling group takes when the lifecycle hook timeout
#' elapses or if an unexpected failure occurs. The default value is
#' `ABANDON`.
#' 
#' Valid values: `CONTINUE` | `ABANDON`
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_lifecycle_hook
autoscaling_put_lifecycle_hook <- function(LifecycleHookName, AutoScalingGroupName, LifecycleTransition = NULL, RoleARN = NULL, NotificationTargetARN = NULL, NotificationMetadata = NULL, HeartbeatTimeout = NULL, DefaultResult = NULL) {
  op <- new_operation(
    name = "PutLifecycleHook",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$put_lifecycle_hook_input(LifecycleHookName = LifecycleHookName, AutoScalingGroupName = AutoScalingGroupName, LifecycleTransition = LifecycleTransition, RoleARN = RoleARN, NotificationTargetARN = NotificationTargetARN, NotificationMetadata = NotificationMetadata, HeartbeatTimeout = HeartbeatTimeout, DefaultResult = DefaultResult)
  output <- .autoscaling$put_lifecycle_hook_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_lifecycle_hook <- autoscaling_put_lifecycle_hook

#' Configures an Auto Scaling group to send notifications when specified
#' events take place
#'
#' @description
#' Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the specified topic can have messages delivered to an endpoint such as a web server or an email address.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_put_notification_configuration/](https://www.paws-r-sdk.com/docs/autoscaling_put_notification_configuration/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TopicARN &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon SNS topic.
#' @param NotificationTypes &#91;required&#93; The type of event that causes the notification to be sent. To query the
#' notification types supported by Amazon EC2 Auto Scaling, call the
#' [`describe_auto_scaling_notification_types`][autoscaling_describe_auto_scaling_notification_types]
#' API.
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_notification_configuration
autoscaling_put_notification_configuration <- function(AutoScalingGroupName, TopicARN, NotificationTypes) {
  op <- new_operation(
    name = "PutNotificationConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$put_notification_configuration_input(AutoScalingGroupName = AutoScalingGroupName, TopicARN = TopicARN, NotificationTypes = NotificationTypes)
  output <- .autoscaling$put_notification_configuration_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_notification_configuration <- autoscaling_put_notification_configuration

#' Creates or updates a scaling policy for an Auto Scaling group
#'
#' @description
#' Creates or updates a scaling policy for an Auto Scaling group. Scaling policies are used to scale an Auto Scaling group based on configurable metrics. If no policies are defined, the dynamic scaling and predictive scaling features are not used.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_put_scaling_policy/](https://www.paws-r-sdk.com/docs/autoscaling_put_scaling_policy/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param PolicyName &#91;required&#93; The name of the policy.
#' @param PolicyType One of the following policy types:
#' 
#' -   `TargetTrackingScaling`
#' 
#' -   `StepScaling`
#' 
#' -   `SimpleScaling` (default)
#' 
#' -   `PredictiveScaling`
#' @param AdjustmentType Specifies how the scaling adjustment is interpreted (for example, an
#' absolute number or a percentage). The valid values are
#' `ChangeInCapacity`, `ExactCapacity`, and `PercentChangeInCapacity`.
#' 
#' Required if the policy type is `StepScaling` or `SimpleScaling`. For
#' more information, see [Scaling adjustment
#' types](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MinAdjustmentStep Available for backward compatibility. Use `MinAdjustmentMagnitude`
#' instead.
#' @param MinAdjustmentMagnitude The minimum value to scale by when the adjustment type is
#' `PercentChangeInCapacity`. For example, suppose that you create a step
#' scaling policy to scale out an Auto Scaling group by 25 percent and you
#' specify a `MinAdjustmentMagnitude` of 2. If the group has 4 instances
#' and the scaling policy is performed, 25 percent of 4 is 1. However,
#' because you specified a `MinAdjustmentMagnitude` of 2, Amazon EC2 Auto
#' Scaling scales out the group by 2 instances.
#' 
#' Valid only if the policy type is `StepScaling` or `SimpleScaling`. For
#' more information, see [Scaling adjustment
#' types](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Some Auto Scaling groups use instance weights. In this case, set the
#' `MinAdjustmentMagnitude` to a value that is at least as large as your
#' largest instance weight.
#' @param ScalingAdjustment The amount by which to scale, based on the specified adjustment type. A
#' positive value adds to the current capacity while a negative number
#' removes from the current capacity. For exact capacity, you must specify
#' a non-negative value.
#' 
#' Required if the policy type is `SimpleScaling`. (Not used with any other
#' policy type.)
#' @param Cooldown A cooldown period, in seconds, that applies to a specific simple scaling
#' policy. When a cooldown period is specified here, it overrides the
#' default cooldown.
#' 
#' Valid only if the policy type is `SimpleScaling`. For more information,
#' see [Scaling cooldowns for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Default: None
#' @param MetricAggregationType The aggregation type for the CloudWatch metrics. The valid values are
#' `Minimum`, `Maximum`, and `Average`. If the aggregation type is null,
#' the value is treated as `Average`.
#' 
#' Valid only if the policy type is `StepScaling`.
#' @param StepAdjustments A set of adjustments that enable you to scale based on the size of the
#' alarm breach.
#' 
#' Required if the policy type is `StepScaling`. (Not used with any other
#' policy type.)
#' @param EstimatedInstanceWarmup *Not needed if the default instance warmup is defined for the group.*
#' 
#' The estimated time, in seconds, until a newly launched instance can
#' contribute to the CloudWatch metrics. This warm-up period applies to
#' instances launched due to a specific target tracking or step scaling
#' policy. When a warm-up period is specified here, it overrides the
#' default instance warmup.
#' 
#' Valid only if the policy type is `TargetTrackingScaling` or
#' `StepScaling`.
#' 
#' The default is to use the value for the default instance warmup defined
#' for the group. If default instance warmup is null, then
#' `EstimatedInstanceWarmup` falls back to the value of default cooldown.
#' @param TargetTrackingConfiguration A target tracking scaling policy. Provides support for predefined or
#' custom metrics.
#' 
#' The following predefined metrics are available:
#' 
#' -   `ASGAverageCPUUtilization`
#' 
#' -   `ASGAverageNetworkIn`
#' 
#' -   `ASGAverageNetworkOut`
#' 
#' -   `ALBRequestCountPerTarget`
#' 
#' If you specify `ALBRequestCountPerTarget` for the metric, you must
#' specify the `ResourceLabel` property with the
#' `PredefinedMetricSpecification`.
#' 
#' For more information, see
#' [TargetTrackingConfiguration](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html)
#' in the *Amazon EC2 Auto Scaling API Reference*.
#' 
#' Required if the policy type is `TargetTrackingScaling`.
#' @param Enabled Indicates whether the scaling policy is enabled or disabled. The default
#' is enabled. For more information, see [Disable a scaling policy for an
#' Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param PredictiveScalingConfiguration A predictive scaling policy. Provides support for predefined and custom
#' metrics.
#' 
#' Predefined metrics include CPU utilization, network in/out, and the
#' Application Load Balancer request count.
#' 
#' For more information, see
#' [PredictiveScalingConfiguration](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html)
#' in the *Amazon EC2 Auto Scaling API Reference*.
#' 
#' Required if the policy type is `PredictiveScaling`.
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_scaling_policy
autoscaling_put_scaling_policy <- function(AutoScalingGroupName, PolicyName, PolicyType = NULL, AdjustmentType = NULL, MinAdjustmentStep = NULL, MinAdjustmentMagnitude = NULL, ScalingAdjustment = NULL, Cooldown = NULL, MetricAggregationType = NULL, StepAdjustments = NULL, EstimatedInstanceWarmup = NULL, TargetTrackingConfiguration = NULL, Enabled = NULL, PredictiveScalingConfiguration = NULL) {
  op <- new_operation(
    name = "PutScalingPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$put_scaling_policy_input(AutoScalingGroupName = AutoScalingGroupName, PolicyName = PolicyName, PolicyType = PolicyType, AdjustmentType = AdjustmentType, MinAdjustmentStep = MinAdjustmentStep, MinAdjustmentMagnitude = MinAdjustmentMagnitude, ScalingAdjustment = ScalingAdjustment, Cooldown = Cooldown, MetricAggregationType = MetricAggregationType, StepAdjustments = StepAdjustments, EstimatedInstanceWarmup = EstimatedInstanceWarmup, TargetTrackingConfiguration = TargetTrackingConfiguration, Enabled = Enabled, PredictiveScalingConfiguration = PredictiveScalingConfiguration)
  output <- .autoscaling$put_scaling_policy_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_scaling_policy <- autoscaling_put_scaling_policy

#' Creates or updates a scheduled scaling action for an Auto Scaling group
#'
#' @description
#' Creates or updates a scheduled scaling action for an Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_put_scheduled_update_group_action/](https://www.paws-r-sdk.com/docs/autoscaling_put_scheduled_update_group_action/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScheduledActionName &#91;required&#93; The name of this scaling action.
#' @param Time This property is no longer used.
#' @param StartTime The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ
#' format in UTC/GMT only and in quotes (for example,
#' `"2021-06-01T00:00:00Z"`).
#' 
#' If you specify `Recurrence` and `StartTime`, Amazon EC2 Auto Scaling
#' performs the action at this time, and then performs the action based on
#' the specified recurrence.
#' @param EndTime The date and time for the recurring schedule to end, in UTC. For
#' example, `"2021-06-01T00:00:00Z"`.
#' @param Recurrence The recurring schedule for this action. This format consists of five
#' fields separated by white spaces: \[Minute\] \[Hour\] \[Day_of_Month\]
#' \[Month_of_Year\] \[Day_of_Week\]. The value must be in quotes (for
#' example, `"30 0 1 1,6,12 *"`). For more information about this format,
#' see [Crontab](http://crontab.org/).
#' 
#' When `StartTime` and `EndTime` are specified with `Recurrence`, they
#' form the boundaries of when the recurring action starts and stops.
#' 
#' Cron expressions use Universal Coordinated Time (UTC) by default.
#' @param MinSize The minimum size of the Auto Scaling group.
#' @param MaxSize The maximum size of the Auto Scaling group.
#' @param DesiredCapacity The desired capacity is the initial capacity of the Auto Scaling group
#' after the scheduled action runs and the capacity it attempts to
#' maintain. It can scale beyond this capacity if you add more scaling
#' conditions.
#' 
#' You must specify at least one of the following properties: `MaxSize`,
#' `MinSize`, or `DesiredCapacity`.
#' @param TimeZone Specifies the time zone for a cron expression. If a time zone is not
#' provided, UTC is used by default.
#' 
#' Valid values are the canonical names of the IANA time zones, derived
#' from the IANA Time Zone Database (such as `Etc/GMT+9` or
#' `Pacific/Tahiti`). For more information, see
#' <https://en.wikipedia.org/wiki/List_of_tz_database_time_zones>.
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_scheduled_update_group_action
autoscaling_put_scheduled_update_group_action <- function(AutoScalingGroupName, ScheduledActionName, Time = NULL, StartTime = NULL, EndTime = NULL, Recurrence = NULL, MinSize = NULL, MaxSize = NULL, DesiredCapacity = NULL, TimeZone = NULL) {
  op <- new_operation(
    name = "PutScheduledUpdateGroupAction",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$put_scheduled_update_group_action_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledActionName = ScheduledActionName, Time = Time, StartTime = StartTime, EndTime = EndTime, Recurrence = Recurrence, MinSize = MinSize, MaxSize = MaxSize, DesiredCapacity = DesiredCapacity, TimeZone = TimeZone)
  output <- .autoscaling$put_scheduled_update_group_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_scheduled_update_group_action <- autoscaling_put_scheduled_update_group_action

#' Creates or updates a warm pool for the specified Auto Scaling group
#'
#' @description
#' Creates or updates a warm pool for the specified Auto Scaling group. A warm pool is a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling group. Whenever your application needs to scale out, the Auto Scaling group can draw on the warm pool to meet its new desired capacity.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_put_warm_pool/](https://www.paws-r-sdk.com/docs/autoscaling_put_warm_pool/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param MaxGroupPreparedCapacity Specifies the maximum number of instances that are allowed to be in the
#' warm pool or in any state except `Terminated` for the Auto Scaling
#' group. This is an optional property. Specify it only if you do not want
#' the warm pool size to be determined by the difference between the
#' group's maximum capacity and its desired capacity.
#' 
#' If a value for `MaxGroupPreparedCapacity` is not specified, Amazon EC2
#' Auto Scaling launches and maintains the difference between the group's
#' maximum capacity and its desired capacity. If you specify a value for
#' `MaxGroupPreparedCapacity`, Amazon EC2 Auto Scaling uses the difference
#' between the `MaxGroupPreparedCapacity` and the desired capacity instead.
#' 
#' The size of the warm pool is dynamic. Only when
#' `MaxGroupPreparedCapacity` and `MinSize` are set to the same value does
#' the warm pool have an absolute size.
#' 
#' If the desired capacity of the Auto Scaling group is higher than the
#' `MaxGroupPreparedCapacity`, the capacity of the warm pool is 0, unless
#' you specify a value for `MinSize`. To remove a value that you previously
#' set, include the property but specify -1 for the value.
#' @param MinSize Specifies the minimum number of instances to maintain in the warm pool.
#' This helps you to ensure that there is always a certain number of warmed
#' instances available to handle traffic spikes. Defaults to 0 if not
#' specified.
#' @param PoolState Sets the instance state to transition to after the lifecycle actions are
#' complete. Default is `Stopped`.
#' @param InstanceReusePolicy Indicates whether instances in the Auto Scaling group can be returned to
#' the warm pool on scale in. The default is to terminate instances in the
#' Auto Scaling group when the group scales in.
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_warm_pool
autoscaling_put_warm_pool <- function(AutoScalingGroupName, MaxGroupPreparedCapacity = NULL, MinSize = NULL, PoolState = NULL, InstanceReusePolicy = NULL) {
  op <- new_operation(
    name = "PutWarmPool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$put_warm_pool_input(AutoScalingGroupName = AutoScalingGroupName, MaxGroupPreparedCapacity = MaxGroupPreparedCapacity, MinSize = MinSize, PoolState = PoolState, InstanceReusePolicy = InstanceReusePolicy)
  output <- .autoscaling$put_warm_pool_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_warm_pool <- autoscaling_put_warm_pool

#' Records a heartbeat for the lifecycle action associated with the
#' specified token or instance
#'
#' @description
#' Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the timeout by the length of time defined using the [`put_lifecycle_hook`][autoscaling_put_lifecycle_hook] API call.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_record_lifecycle_action_heartbeat/](https://www.paws-r-sdk.com/docs/autoscaling_record_lifecycle_action_heartbeat/) for full documentation.
#'
#' @param LifecycleHookName &#91;required&#93; The name of the lifecycle hook.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LifecycleActionToken A token that uniquely identifies a specific lifecycle action associated
#' with an instance. Amazon EC2 Auto Scaling sends this token to the
#' notification target that you specified when you created the lifecycle
#' hook.
#' @param InstanceId The ID of the instance.
#'
#' @keywords internal
#'
#' @rdname autoscaling_record_lifecycle_action_heartbeat
autoscaling_record_lifecycle_action_heartbeat <- function(LifecycleHookName, AutoScalingGroupName, LifecycleActionToken = NULL, InstanceId = NULL) {
  op <- new_operation(
    name = "RecordLifecycleActionHeartbeat",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$record_lifecycle_action_heartbeat_input(LifecycleHookName = LifecycleHookName, AutoScalingGroupName = AutoScalingGroupName, LifecycleActionToken = LifecycleActionToken, InstanceId = InstanceId)
  output <- .autoscaling$record_lifecycle_action_heartbeat_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$record_lifecycle_action_heartbeat <- autoscaling_record_lifecycle_action_heartbeat

#' Resumes the specified suspended auto scaling processes, or all suspended
#' process, for the specified Auto Scaling group
#'
#' @description
#' Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_resume_processes/](https://www.paws-r-sdk.com/docs/autoscaling_resume_processes/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScalingProcesses One or more of the following processes:
#' 
#' -   `Launch`
#' 
#' -   `Terminate`
#' 
#' -   `AddToLoadBalancer`
#' 
#' -   `AlarmNotification`
#' 
#' -   `AZRebalance`
#' 
#' -   `HealthCheck`
#' 
#' -   `InstanceRefresh`
#' 
#' -   `ReplaceUnhealthy`
#' 
#' -   `ScheduledActions`
#' 
#' If you omit this property, all processes are specified.
#'
#' @keywords internal
#'
#' @rdname autoscaling_resume_processes
autoscaling_resume_processes <- function(AutoScalingGroupName, ScalingProcesses = NULL) {
  op <- new_operation(
    name = "ResumeProcesses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$resume_processes_input(AutoScalingGroupName = AutoScalingGroupName, ScalingProcesses = ScalingProcesses)
  output <- .autoscaling$resume_processes_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$resume_processes <- autoscaling_resume_processes

#' Cancels an instance refresh that is in progress and rolls back any
#' changes that it made
#'
#' @description
#' Cancels an instance refresh that is in progress and rolls back any changes that it made. Amazon EC2 Auto Scaling replaces any instances that were replaced during the instance refresh. This restores your Auto Scaling group to the configuration that it was using before the start of the instance refresh.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_rollback_instance_refresh/](https://www.paws-r-sdk.com/docs/autoscaling_rollback_instance_refresh/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @keywords internal
#'
#' @rdname autoscaling_rollback_instance_refresh
autoscaling_rollback_instance_refresh <- function(AutoScalingGroupName) {
  op <- new_operation(
    name = "RollbackInstanceRefresh",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$rollback_instance_refresh_input(AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$rollback_instance_refresh_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$rollback_instance_refresh <- autoscaling_rollback_instance_refresh

#' Sets the size of the specified Auto Scaling group
#'
#' @description
#' Sets the size of the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_set_desired_capacity/](https://www.paws-r-sdk.com/docs/autoscaling_set_desired_capacity/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param DesiredCapacity &#91;required&#93; The desired capacity is the initial capacity of the Auto Scaling group
#' after this operation completes and the capacity it attempts to maintain.
#' @param HonorCooldown Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period
#' to complete before initiating a scaling activity to set your Auto
#' Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling
#' does not honor the cooldown period during manual scaling activities.
#'
#' @keywords internal
#'
#' @rdname autoscaling_set_desired_capacity
autoscaling_set_desired_capacity <- function(AutoScalingGroupName, DesiredCapacity, HonorCooldown = NULL) {
  op <- new_operation(
    name = "SetDesiredCapacity",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$set_desired_capacity_input(AutoScalingGroupName = AutoScalingGroupName, DesiredCapacity = DesiredCapacity, HonorCooldown = HonorCooldown)
  output <- .autoscaling$set_desired_capacity_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$set_desired_capacity <- autoscaling_set_desired_capacity

#' Sets the health status of the specified instance
#'
#' @description
#' Sets the health status of the specified instance.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_set_instance_health/](https://www.paws-r-sdk.com/docs/autoscaling_set_instance_health/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param HealthStatus &#91;required&#93; The health status of the instance. Set to `Healthy` to have the instance
#' remain in service. Set to `Unhealthy` to have the instance be out of
#' service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy
#' instance.
#' @param ShouldRespectGracePeriod If the Auto Scaling group of the specified instance has a
#' `HealthCheckGracePeriod` specified for the group, by default, this call
#' respects the grace period. Set this to `False`, to have the call not
#' respect the grace period associated with the group.
#' 
#' For more information about the health check grace period, see [Set the
#' health check grace period for an Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @keywords internal
#'
#' @rdname autoscaling_set_instance_health
autoscaling_set_instance_health <- function(InstanceId, HealthStatus, ShouldRespectGracePeriod = NULL) {
  op <- new_operation(
    name = "SetInstanceHealth",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$set_instance_health_input(InstanceId = InstanceId, HealthStatus = HealthStatus, ShouldRespectGracePeriod = ShouldRespectGracePeriod)
  output <- .autoscaling$set_instance_health_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$set_instance_health <- autoscaling_set_instance_health

#' Updates the instance protection settings of the specified instances
#'
#' @description
#' Updates the instance protection settings of the specified instances. This operation cannot be called on instances in a warm pool.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_set_instance_protection/](https://www.paws-r-sdk.com/docs/autoscaling_set_instance_protection/) for full documentation.
#'
#' @param InstanceIds &#91;required&#93; One or more instance IDs. You can specify up to 50 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ProtectedFromScaleIn &#91;required&#93; Indicates whether the instance is protected from termination by Amazon
#' EC2 Auto Scaling when scaling in.
#'
#' @keywords internal
#'
#' @rdname autoscaling_set_instance_protection
autoscaling_set_instance_protection <- function(InstanceIds, AutoScalingGroupName, ProtectedFromScaleIn) {
  op <- new_operation(
    name = "SetInstanceProtection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$set_instance_protection_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName, ProtectedFromScaleIn = ProtectedFromScaleIn)
  output <- .autoscaling$set_instance_protection_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$set_instance_protection <- autoscaling_set_instance_protection

#' Starts an instance refresh
#'
#' @description
#' Starts an instance refresh.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_start_instance_refresh/](https://www.paws-r-sdk.com/docs/autoscaling_start_instance_refresh/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param Strategy The strategy to use for the instance refresh. The only valid value is
#' `Rolling`.
#' @param DesiredConfiguration The desired configuration. For example, the desired configuration can
#' specify a new launch template or a new version of the current launch
#' template.
#' 
#' Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the
#' settings of the Auto Scaling group to reflect the new desired
#' configuration.
#' 
#' When you specify a new launch template or a new version of the current
#' launch template for your desired configuration, consider enabling the
#' `SkipMatching` property in preferences. If it's enabled, Amazon EC2 Auto
#' Scaling skips replacing instances that already use the specified launch
#' template and instance types. This can help you reduce the number of
#' replacements that are required to apply updates.
#' @param Preferences Sets your preferences for the instance refresh so that it performs as
#' expected when you start it. Includes the instance warmup time, the
#' minimum and maximum healthy percentages, and the behaviors that you want
#' Amazon EC2 Auto Scaling to use if instances that are in `Standby` state
#' or protected from scale in are found. You can also choose to enable
#' additional features, such as the following:
#' 
#' -   Auto rollback
#' 
#' -   Checkpoints
#' 
#' -   CloudWatch alarms
#' 
#' -   Skip matching
#'
#' @keywords internal
#'
#' @rdname autoscaling_start_instance_refresh
autoscaling_start_instance_refresh <- function(AutoScalingGroupName, Strategy = NULL, DesiredConfiguration = NULL, Preferences = NULL) {
  op <- new_operation(
    name = "StartInstanceRefresh",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$start_instance_refresh_input(AutoScalingGroupName = AutoScalingGroupName, Strategy = Strategy, DesiredConfiguration = DesiredConfiguration, Preferences = Preferences)
  output <- .autoscaling$start_instance_refresh_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$start_instance_refresh <- autoscaling_start_instance_refresh

#' Suspends the specified auto scaling processes, or all processes, for the
#' specified Auto Scaling group
#'
#' @description
#' Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_suspend_processes/](https://www.paws-r-sdk.com/docs/autoscaling_suspend_processes/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScalingProcesses One or more of the following processes:
#' 
#' -   `Launch`
#' 
#' -   `Terminate`
#' 
#' -   `AddToLoadBalancer`
#' 
#' -   `AlarmNotification`
#' 
#' -   `AZRebalance`
#' 
#' -   `HealthCheck`
#' 
#' -   `InstanceRefresh`
#' 
#' -   `ReplaceUnhealthy`
#' 
#' -   `ScheduledActions`
#' 
#' If you omit this property, all processes are specified.
#'
#' @keywords internal
#'
#' @rdname autoscaling_suspend_processes
autoscaling_suspend_processes <- function(AutoScalingGroupName, ScalingProcesses = NULL) {
  op <- new_operation(
    name = "SuspendProcesses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$suspend_processes_input(AutoScalingGroupName = AutoScalingGroupName, ScalingProcesses = ScalingProcesses)
  output <- .autoscaling$suspend_processes_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$suspend_processes <- autoscaling_suspend_processes

#' Terminates the specified instance and optionally adjusts the desired
#' group size
#'
#' @description
#' Terminates the specified instance and optionally adjusts the desired group size. This operation cannot be called on instances in a warm pool.
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_terminate_instance_in_auto_scaling_group/](https://www.paws-r-sdk.com/docs/autoscaling_terminate_instance_in_auto_scaling_group/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param ShouldDecrementDesiredCapacity &#91;required&#93; Indicates whether terminating the instance also decrements the size of
#' the Auto Scaling group.
#'
#' @keywords internal
#'
#' @rdname autoscaling_terminate_instance_in_auto_scaling_group
autoscaling_terminate_instance_in_auto_scaling_group <- function(InstanceId, ShouldDecrementDesiredCapacity) {
  op <- new_operation(
    name = "TerminateInstanceInAutoScalingGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$terminate_instance_in_auto_scaling_group_input(InstanceId = InstanceId, ShouldDecrementDesiredCapacity = ShouldDecrementDesiredCapacity)
  output <- .autoscaling$terminate_instance_in_auto_scaling_group_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$terminate_instance_in_auto_scaling_group <- autoscaling_terminate_instance_in_auto_scaling_group

#' We strongly recommend that all Auto Scaling groups use launch templates
#' to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2
#'
#' @description
#' **We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.**
#'
#' See [https://www.paws-r-sdk.com/docs/autoscaling_update_auto_scaling_group/](https://www.paws-r-sdk.com/docs/autoscaling_update_auto_scaling_group/) for full documentation.
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LaunchConfigurationName The name of the launch configuration. If you specify
#' `LaunchConfigurationName` in your update request, you can't specify
#' `LaunchTemplate` or `MixedInstancesPolicy`.
#' @param LaunchTemplate The launch template and version to use to specify the updates. If you
#' specify `LaunchTemplate` in your update request, you can't specify
#' `LaunchConfigurationName` or `MixedInstancesPolicy`.
#' @param MixedInstancesPolicy The mixed instances policy. For more information, see [Auto Scaling
#' groups with multiple instance types and purchase
#' options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MinSize The minimum size of the Auto Scaling group.
#' @param MaxSize The maximum size of the Auto Scaling group.
#' 
#' With a mixed instances policy that uses instance weighting, Amazon EC2
#' Auto Scaling may need to go above `MaxSize` to meet your capacity
#' requirements. In this event, Amazon EC2 Auto Scaling will never go above
#' `MaxSize` by more than your largest instance weight (weights that define
#' how many units each instance contributes to the desired capacity of the
#' group).
#' @param DesiredCapacity The desired capacity is the initial capacity of the Auto Scaling group
#' after this operation completes and the capacity it attempts to maintain.
#' This number must be greater than or equal to the minimum size of the
#' group and less than or equal to the maximum size of the group.
#' @param DefaultCooldown *Only needed if you use simple scaling policies.*
#' 
#' The amount of time, in seconds, between one scaling activity ending and
#' another one starting due to simple scaling policies. For more
#' information, see [Scaling cooldowns for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param AvailabilityZones One or more Availability Zones for the group.
#' @param HealthCheckType A comma-separated value string of one or more health check types.
#' 
#' The valid values are `EC2`, `EBS`, `ELB`, and `VPC_LATTICE`. `EC2` is
#' the default health check and cannot be disabled. For more information,
#' see [Health checks for instances in an Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Only specify `EC2` if you must clear a value that was previously set.
#' @param HealthCheckGracePeriod The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
#' before checking the health status of an EC2 instance that has come into
#' service and marking it unhealthy due to a failed health check. This is
#' useful if your instances do not immediately pass their health checks
#' after they enter the `InService` state. For more information, see [Set
#' the health check grace period for an Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param PlacementGroup The name of an existing placement group into which to launch your
#' instances. For more information, see [Placement
#' groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' A *cluster* placement group is a logical grouping of instances within a
#' single Availability Zone. You cannot specify multiple Availability Zones
#' and a cluster placement group.
#' @param VPCZoneIdentifier A comma-separated list of subnet IDs for a virtual private cloud (VPC).
#' If you specify `VPCZoneIdentifier` with `AvailabilityZones`, the subnets
#' that you specify must reside in those Availability Zones.
#' @param TerminationPolicies A policy or a list of policies that are used to select the instances to
#' terminate. The policies are executed in the order that you list them.
#' For more information, see [Configure termination policies for Amazon EC2
#' Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Valid values: `Default` | `AllocationStrategy` |
#' `ClosestToNextInstanceHour` | `NewestInstance` | `OldestInstance` |
#' `OldestLaunchConfiguration` | `OldestLaunchTemplate` |
#' `arn:aws:lambda:region:account-id:function:my-function:my-alias`
#' @param NewInstancesProtectedFromScaleIn Indicates whether newly launched instances are protected from
#' termination by Amazon EC2 Auto Scaling when scaling in. For more
#' information about preventing instances from terminating on scale in, see
#' [Use instance scale-in
#' protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param ServiceLinkedRoleARN The Amazon Resource Name (ARN) of the service-linked role that the Auto
#' Scaling group uses to call other Amazon Web Services on your behalf. For
#' more information, see [Service-linked
#' roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MaxInstanceLifetime The maximum amount of time, in seconds, that an instance can be in
#' service. The default is null. If specified, the value must be either 0
#' or a number equal to or greater than 86,400 seconds (1 day). To clear a
#' previously set value, specify a new value of 0. For more information,
#' see [Replacing Auto Scaling instances based on maximum instance
#' lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param CapacityRebalance Enables or disables Capacity Rebalancing. For more information, see [Use
#' Capacity Rebalancing to handle Amazon EC2 Spot
#' Interruptions](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param Context Reserved.
#' @param DesiredCapacityType The unit of measurement for the value specified for desired capacity.
#' Amazon EC2 Auto Scaling supports `DesiredCapacityType` for
#' attribute-based instance type selection only. For more information, see
#' [Create a mixed instances group using attribute-based instance type
#' selection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' By default, Amazon EC2 Auto Scaling specifies `units`, which translates
#' into number of instances.
#' 
#' Valid values: `units` | `vcpu` | `memory-mib`
#' @param DefaultInstanceWarmup The amount of time, in seconds, until a new instance is considered to
#' have finished initializing and resource consumption to become stable
#' after it enters the `InService` state.
#' 
#' During an instance refresh, Amazon EC2 Auto Scaling waits for the
#' warm-up period after it replaces an instance before it moves on to
#' replacing the next instance. Amazon EC2 Auto Scaling also waits for the
#' warm-up period before aggregating the metrics for new instances with
#' existing instances in the Amazon CloudWatch metrics that are used for
#' scaling, resulting in more reliable usage data. For more information,
#' see [Set the default instance warmup for an Auto Scaling
#' group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' To manage various warm-up settings at the group level, we recommend that
#' you set the default instance warmup, *even if it is set to 0 seconds*.
#' To remove a value that you previously set, include the property but
#' specify `-1` for the value. However, we strongly recommend keeping the
#' default instance warmup enabled by specifying a value of `0` or other
#' nominal value.
#' @param InstanceMaintenancePolicy An instance maintenance policy. For more information, see [Set instance
#' maintenance
#' policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @keywords internal
#'
#' @rdname autoscaling_update_auto_scaling_group
autoscaling_update_auto_scaling_group <- function(AutoScalingGroupName, LaunchConfigurationName = NULL, LaunchTemplate = NULL, MixedInstancesPolicy = NULL, MinSize = NULL, MaxSize = NULL, DesiredCapacity = NULL, DefaultCooldown = NULL, AvailabilityZones = NULL, HealthCheckType = NULL, HealthCheckGracePeriod = NULL, PlacementGroup = NULL, VPCZoneIdentifier = NULL, TerminationPolicies = NULL, NewInstancesProtectedFromScaleIn = NULL, ServiceLinkedRoleARN = NULL, MaxInstanceLifetime = NULL, CapacityRebalance = NULL, Context = NULL, DesiredCapacityType = NULL, DefaultInstanceWarmup = NULL, InstanceMaintenancePolicy = NULL) {
  op <- new_operation(
    name = "UpdateAutoScalingGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .autoscaling$update_auto_scaling_group_input(AutoScalingGroupName = AutoScalingGroupName, LaunchConfigurationName = LaunchConfigurationName, LaunchTemplate = LaunchTemplate, MixedInstancesPolicy = MixedInstancesPolicy, MinSize = MinSize, MaxSize = MaxSize, DesiredCapacity = DesiredCapacity, DefaultCooldown = DefaultCooldown, AvailabilityZones = AvailabilityZones, HealthCheckType = HealthCheckType, HealthCheckGracePeriod = HealthCheckGracePeriod, PlacementGroup = PlacementGroup, VPCZoneIdentifier = VPCZoneIdentifier, TerminationPolicies = TerminationPolicies, NewInstancesProtectedFromScaleIn = NewInstancesProtectedFromScaleIn, ServiceLinkedRoleARN = ServiceLinkedRoleARN, MaxInstanceLifetime = MaxInstanceLifetime, CapacityRebalance = CapacityRebalance, Context = Context, DesiredCapacityType = DesiredCapacityType, DefaultInstanceWarmup = DefaultInstanceWarmup, InstanceMaintenancePolicy = InstanceMaintenancePolicy)
  output <- .autoscaling$update_auto_scaling_group_output()
  config <- get_config()
  svc <- .autoscaling$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$update_auto_scaling_group <- autoscaling_update_auto_scaling_group
