# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include licensemanager_service.R
NULL

#' Accepts the specified grant
#'
#' @description
#' Accepts the specified grant.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_accept_grant/](https://www.paws-r-sdk.com/docs/licensemanager_accept_grant/) for full documentation.
#'
#' @param GrantArn &#91;required&#93; Amazon Resource Name (ARN) of the grant.
#'
#' @keywords internal
#'
#' @rdname licensemanager_accept_grant
licensemanager_accept_grant <- function(GrantArn) {
  op <- new_operation(
    name = "AcceptGrant",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$accept_grant_input(GrantArn = GrantArn)
  output <- .licensemanager$accept_grant_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$accept_grant <- licensemanager_accept_grant

#' Checks in the specified license
#'
#' @description
#' Checks in the specified license. Check in a license when it is no longer in use.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_check_in_license/](https://www.paws-r-sdk.com/docs/licensemanager_check_in_license/) for full documentation.
#'
#' @param LicenseConsumptionToken &#91;required&#93; License consumption token.
#' @param Beneficiary License beneficiary.
#'
#' @keywords internal
#'
#' @rdname licensemanager_check_in_license
licensemanager_check_in_license <- function(LicenseConsumptionToken, Beneficiary = NULL) {
  op <- new_operation(
    name = "CheckInLicense",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$check_in_license_input(LicenseConsumptionToken = LicenseConsumptionToken, Beneficiary = Beneficiary)
  output <- .licensemanager$check_in_license_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$check_in_license <- licensemanager_check_in_license

#' Checks out the specified license for offline use
#'
#' @description
#' Checks out the specified license for offline use.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_checkout_borrow_license/](https://www.paws-r-sdk.com/docs/licensemanager_checkout_borrow_license/) for full documentation.
#'
#' @param LicenseArn &#91;required&#93; Amazon Resource Name (ARN) of the license. The license must use the
#' borrow consumption configuration.
#' @param Entitlements &#91;required&#93; License entitlements. Partial checkouts are not supported.
#' @param DigitalSignatureMethod &#91;required&#93; Digital signature method. The possible value is JSON Web Signature (JWS)
#' algorithm PS384. For more information, see [RFC 7518 Digital Signature
#' with
#' RSASSA-PSS](https://datatracker.ietf.org/doc/html/rfc7518#section-3.5).
#' @param NodeId Node ID.
#' @param CheckoutMetadata Information about constraints.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname licensemanager_checkout_borrow_license
licensemanager_checkout_borrow_license <- function(LicenseArn, Entitlements, DigitalSignatureMethod, NodeId = NULL, CheckoutMetadata = NULL, ClientToken) {
  op <- new_operation(
    name = "CheckoutBorrowLicense",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$checkout_borrow_license_input(LicenseArn = LicenseArn, Entitlements = Entitlements, DigitalSignatureMethod = DigitalSignatureMethod, NodeId = NodeId, CheckoutMetadata = CheckoutMetadata, ClientToken = ClientToken)
  output <- .licensemanager$checkout_borrow_license_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$checkout_borrow_license <- licensemanager_checkout_borrow_license

#' Checks out the specified license
#'
#' @description
#' Checks out the specified license.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_checkout_license/](https://www.paws-r-sdk.com/docs/licensemanager_checkout_license/) for full documentation.
#'
#' @param ProductSKU &#91;required&#93; Product SKU.
#' @param CheckoutType &#91;required&#93; Checkout type.
#' @param KeyFingerprint &#91;required&#93; Key fingerprint identifying the license.
#' @param Entitlements &#91;required&#93; License entitlements.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param Beneficiary License beneficiary.
#' @param NodeId Node ID.
#'
#' @keywords internal
#'
#' @rdname licensemanager_checkout_license
licensemanager_checkout_license <- function(ProductSKU, CheckoutType, KeyFingerprint, Entitlements, ClientToken, Beneficiary = NULL, NodeId = NULL) {
  op <- new_operation(
    name = "CheckoutLicense",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$checkout_license_input(ProductSKU = ProductSKU, CheckoutType = CheckoutType, KeyFingerprint = KeyFingerprint, Entitlements = Entitlements, ClientToken = ClientToken, Beneficiary = Beneficiary, NodeId = NodeId)
  output <- .licensemanager$checkout_license_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$checkout_license <- licensemanager_checkout_license

#' Creates a grant for the specified license
#'
#' @description
#' Creates a grant for the specified license. A grant shares the use of license entitlements with a specific Amazon Web Services account, an organization, or an organizational unit (OU). For more information, see [Granted licenses in License Manager](https://docs.aws.amazon.com/license-manager/latest/userguide/granted-licenses.html) in the *License Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_create_grant/](https://www.paws-r-sdk.com/docs/licensemanager_create_grant/) for full documentation.
#'
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param GrantName &#91;required&#93; Grant name.
#' @param LicenseArn &#91;required&#93; Amazon Resource Name (ARN) of the license.
#' @param Principals &#91;required&#93; The grant principals. You can specify one of the following as an Amazon
#' Resource Name (ARN):
#' 
#' -   An Amazon Web Services account, which includes only the account
#'     specified.
#' 
#' 
#' -   An organizational unit (OU), which includes all accounts in the OU.
#' 
#' 
#' -   An organization, which will include all accounts across your
#'     organization.
#' @param HomeRegion &#91;required&#93; Home Region of the grant.
#' @param AllowedOperations &#91;required&#93; Allowed operations for the grant.
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_grant
licensemanager_create_grant <- function(ClientToken, GrantName, LicenseArn, Principals, HomeRegion, AllowedOperations) {
  op <- new_operation(
    name = "CreateGrant",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$create_grant_input(ClientToken = ClientToken, GrantName = GrantName, LicenseArn = LicenseArn, Principals = Principals, HomeRegion = HomeRegion, AllowedOperations = AllowedOperations)
  output <- .licensemanager$create_grant_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_grant <- licensemanager_create_grant

#' Creates a new version of the specified grant
#'
#' @description
#' Creates a new version of the specified grant. For more information, see [Granted licenses in License Manager](https://docs.aws.amazon.com/license-manager/latest/userguide/granted-licenses.html) in the *License Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_create_grant_version/](https://www.paws-r-sdk.com/docs/licensemanager_create_grant_version/) for full documentation.
#'
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param GrantArn &#91;required&#93; Amazon Resource Name (ARN) of the grant.
#' @param GrantName Grant name.
#' @param AllowedOperations Allowed operations for the grant.
#' @param Status Grant status.
#' @param StatusReason Grant status reason.
#' @param SourceVersion Current version of the grant.
#' @param Options The options specified for the grant.
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_grant_version
licensemanager_create_grant_version <- function(ClientToken, GrantArn, GrantName = NULL, AllowedOperations = NULL, Status = NULL, StatusReason = NULL, SourceVersion = NULL, Options = NULL) {
  op <- new_operation(
    name = "CreateGrantVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$create_grant_version_input(ClientToken = ClientToken, GrantArn = GrantArn, GrantName = GrantName, AllowedOperations = AllowedOperations, Status = Status, StatusReason = StatusReason, SourceVersion = SourceVersion, Options = Options)
  output <- .licensemanager$create_grant_version_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_grant_version <- licensemanager_create_grant_version

#' Creates a license
#'
#' @description
#' Creates a license.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_create_license/](https://www.paws-r-sdk.com/docs/licensemanager_create_license/) for full documentation.
#'
#' @param LicenseName &#91;required&#93; License name.
#' @param ProductName &#91;required&#93; Product name.
#' @param ProductSKU &#91;required&#93; Product SKU.
#' @param Issuer &#91;required&#93; License issuer.
#' @param HomeRegion &#91;required&#93; Home Region for the license.
#' @param Validity &#91;required&#93; Date and time range during which the license is valid, in ISO8601-UTC
#' format.
#' @param Entitlements &#91;required&#93; License entitlements.
#' @param Beneficiary &#91;required&#93; License beneficiary.
#' @param ConsumptionConfiguration &#91;required&#93; Configuration for consumption of the license. Choose a provisional
#' configuration for workloads running with continuous connectivity. Choose
#' a borrow configuration for workloads with offline usage.
#' @param LicenseMetadata Information about the license.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_license
licensemanager_create_license <- function(LicenseName, ProductName, ProductSKU, Issuer, HomeRegion, Validity, Entitlements, Beneficiary, ConsumptionConfiguration, LicenseMetadata = NULL, ClientToken) {
  op <- new_operation(
    name = "CreateLicense",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$create_license_input(LicenseName = LicenseName, ProductName = ProductName, ProductSKU = ProductSKU, Issuer = Issuer, HomeRegion = HomeRegion, Validity = Validity, Entitlements = Entitlements, Beneficiary = Beneficiary, ConsumptionConfiguration = ConsumptionConfiguration, LicenseMetadata = LicenseMetadata, ClientToken = ClientToken)
  output <- .licensemanager$create_license_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_license <- licensemanager_create_license

#' Creates a license configuration
#'
#' @description
#' Creates a license configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_create_license_configuration/](https://www.paws-r-sdk.com/docs/licensemanager_create_license_configuration/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the license configuration.
#' @param Description Description of the license configuration.
#' @param LicenseCountingType &#91;required&#93; Dimension used to track the license inventory.
#' @param LicenseCount Number of licenses managed by the license configuration.
#' @param LicenseCountHardLimit Indicates whether hard or soft license enforcement is used. Exceeding a
#' hard limit blocks the launch of new instances.
#' @param LicenseRules License rules. The syntax is #name=value (for example,
#' #allowedTenancy=EC2-DedicatedHost). The available rules vary by
#' dimension, as follows.
#' 
#' -   `Cores` dimension: `allowedTenancy` | `licenseAffinityToHost` |
#'     `maximumCores` | `minimumCores`
#' 
#' -   `Instances` dimension: `allowedTenancy` | `maximumCores` |
#'     `minimumCores` | `maximumSockets` | `minimumSockets` |
#'     `maximumVcpus` | `minimumVcpus`
#' 
#' -   `Sockets` dimension: `allowedTenancy` | `licenseAffinityToHost` |
#'     `maximumSockets` | `minimumSockets`
#' 
#' -   `vCPUs` dimension: `allowedTenancy` | `honorVcpuOptimization` |
#'     `maximumVcpus` | `minimumVcpus`
#' 
#' The unit for `licenseAffinityToHost` is days and the range is 1 to 180.
#' The possible values for `allowedTenancy` are `EC2-Default`,
#' `EC2-DedicatedHost`, and `EC2-DedicatedInstance`. The possible values
#' for `honorVcpuOptimization` are `True` and `False`.
#' @param Tags Tags to add to the license configuration.
#' @param DisassociateWhenNotFound When true, disassociates a resource when software is uninstalled.
#' @param ProductInformationList Product information.
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_license_configuration
licensemanager_create_license_configuration <- function(Name, Description = NULL, LicenseCountingType, LicenseCount = NULL, LicenseCountHardLimit = NULL, LicenseRules = NULL, Tags = NULL, DisassociateWhenNotFound = NULL, ProductInformationList = NULL) {
  op <- new_operation(
    name = "CreateLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$create_license_configuration_input(Name = Name, Description = Description, LicenseCountingType = LicenseCountingType, LicenseCount = LicenseCount, LicenseCountHardLimit = LicenseCountHardLimit, LicenseRules = LicenseRules, Tags = Tags, DisassociateWhenNotFound = DisassociateWhenNotFound, ProductInformationList = ProductInformationList)
  output <- .licensemanager$create_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_license_configuration <- licensemanager_create_license_configuration

#' Creates a new license conversion task
#'
#' @description
#' Creates a new license conversion task.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_create_license_conversion_task_for_resource/](https://www.paws-r-sdk.com/docs/licensemanager_create_license_conversion_task_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the resource you are converting the
#' license type for.
#' @param SourceLicenseContext &#91;required&#93; Information that identifies the license type you are converting from.
#' For the structure of the source license, see [Convert a license type
#' using the
#' CLI](https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli)
#' in the *License Manager User Guide*.
#' @param DestinationLicenseContext &#91;required&#93; Information that identifies the license type you are converting to. For
#' the structure of the destination license, see [Convert a license type
#' using the
#' CLI](https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli)
#' in the *License Manager User Guide*.
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_license_conversion_task_for_resource
licensemanager_create_license_conversion_task_for_resource <- function(ResourceArn, SourceLicenseContext, DestinationLicenseContext) {
  op <- new_operation(
    name = "CreateLicenseConversionTaskForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$create_license_conversion_task_for_resource_input(ResourceArn = ResourceArn, SourceLicenseContext = SourceLicenseContext, DestinationLicenseContext = DestinationLicenseContext)
  output <- .licensemanager$create_license_conversion_task_for_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_license_conversion_task_for_resource <- licensemanager_create_license_conversion_task_for_resource

#' Creates a report generator
#'
#' @description
#' Creates a report generator.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_create_license_manager_report_generator/](https://www.paws-r-sdk.com/docs/licensemanager_create_license_manager_report_generator/) for full documentation.
#'
#' @param ReportGeneratorName &#91;required&#93; Name of the report generator.
#' @param Type &#91;required&#93; Type of reports to generate. The following report types an be generated:
#' 
#' -   License configuration report - Reports the number and details of
#'     consumed licenses for a license configuration.
#' 
#' -   Resource report - Reports the tracked licenses and resource
#'     consumption for a license configuration.
#' @param ReportContext &#91;required&#93; Defines the type of license configuration the report generator tracks.
#' @param ReportFrequency &#91;required&#93; Frequency by which reports are generated. Reports can be generated
#' daily, monthly, or weekly.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param Description Description of the report generator.
#' @param Tags Tags to add to the report generator.
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_license_manager_report_generator
licensemanager_create_license_manager_report_generator <- function(ReportGeneratorName, Type, ReportContext, ReportFrequency, ClientToken, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateLicenseManagerReportGenerator",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$create_license_manager_report_generator_input(ReportGeneratorName = ReportGeneratorName, Type = Type, ReportContext = ReportContext, ReportFrequency = ReportFrequency, ClientToken = ClientToken, Description = Description, Tags = Tags)
  output <- .licensemanager$create_license_manager_report_generator_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_license_manager_report_generator <- licensemanager_create_license_manager_report_generator

#' Creates a new version of the specified license
#'
#' @description
#' Creates a new version of the specified license.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_create_license_version/](https://www.paws-r-sdk.com/docs/licensemanager_create_license_version/) for full documentation.
#'
#' @param LicenseArn &#91;required&#93; Amazon Resource Name (ARN) of the license.
#' @param LicenseName &#91;required&#93; License name.
#' @param ProductName &#91;required&#93; Product name.
#' @param Issuer &#91;required&#93; License issuer.
#' @param HomeRegion &#91;required&#93; Home Region of the license.
#' @param Validity &#91;required&#93; Date and time range during which the license is valid, in ISO8601-UTC
#' format.
#' @param LicenseMetadata Information about the license.
#' @param Entitlements &#91;required&#93; License entitlements.
#' @param ConsumptionConfiguration &#91;required&#93; Configuration for consumption of the license. Choose a provisional
#' configuration for workloads running with continuous connectivity. Choose
#' a borrow configuration for workloads with offline usage.
#' @param Status &#91;required&#93; License status.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param SourceVersion Current version of the license.
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_license_version
licensemanager_create_license_version <- function(LicenseArn, LicenseName, ProductName, Issuer, HomeRegion, Validity, LicenseMetadata = NULL, Entitlements, ConsumptionConfiguration, Status, ClientToken, SourceVersion = NULL) {
  op <- new_operation(
    name = "CreateLicenseVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$create_license_version_input(LicenseArn = LicenseArn, LicenseName = LicenseName, ProductName = ProductName, Issuer = Issuer, HomeRegion = HomeRegion, Validity = Validity, LicenseMetadata = LicenseMetadata, Entitlements = Entitlements, ConsumptionConfiguration = ConsumptionConfiguration, Status = Status, ClientToken = ClientToken, SourceVersion = SourceVersion)
  output <- .licensemanager$create_license_version_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_license_version <- licensemanager_create_license_version

#' Creates a long-lived token
#'
#' @description
#' Creates a long-lived token.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_create_token/](https://www.paws-r-sdk.com/docs/licensemanager_create_token/) for full documentation.
#'
#' @param LicenseArn &#91;required&#93; Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud
#' claim of the JWT token.
#' @param RoleArns Amazon Resource Name (ARN) of the IAM roles to embed in the token.
#' License Manager does not check whether the roles are in use.
#' @param ExpirationInDays Token expiration, in days, counted from token creation. The default is
#' 365 days.
#' @param TokenProperties Data specified by the caller to be included in the JWT token. The data
#' is mapped to the amr claim of the JWT token.
#' @param ClientToken &#91;required&#93; Idempotency token, valid for 10 minutes.
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_token
licensemanager_create_token <- function(LicenseArn, RoleArns = NULL, ExpirationInDays = NULL, TokenProperties = NULL, ClientToken) {
  op <- new_operation(
    name = "CreateToken",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$create_token_input(LicenseArn = LicenseArn, RoleArns = RoleArns, ExpirationInDays = ExpirationInDays, TokenProperties = TokenProperties, ClientToken = ClientToken)
  output <- .licensemanager$create_token_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_token <- licensemanager_create_token

#' Deletes the specified grant
#'
#' @description
#' Deletes the specified grant.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_delete_grant/](https://www.paws-r-sdk.com/docs/licensemanager_delete_grant/) for full documentation.
#'
#' @param GrantArn &#91;required&#93; Amazon Resource Name (ARN) of the grant.
#' @param StatusReason The Status reason for the delete request.
#' @param Version &#91;required&#93; Current version of the grant.
#'
#' @keywords internal
#'
#' @rdname licensemanager_delete_grant
licensemanager_delete_grant <- function(GrantArn, StatusReason = NULL, Version) {
  op <- new_operation(
    name = "DeleteGrant",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$delete_grant_input(GrantArn = GrantArn, StatusReason = StatusReason, Version = Version)
  output <- .licensemanager$delete_grant_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$delete_grant <- licensemanager_delete_grant

#' Deletes the specified license
#'
#' @description
#' Deletes the specified license.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_delete_license/](https://www.paws-r-sdk.com/docs/licensemanager_delete_license/) for full documentation.
#'
#' @param LicenseArn &#91;required&#93; Amazon Resource Name (ARN) of the license.
#' @param SourceVersion &#91;required&#93; Current version of the license.
#'
#' @keywords internal
#'
#' @rdname licensemanager_delete_license
licensemanager_delete_license <- function(LicenseArn, SourceVersion) {
  op <- new_operation(
    name = "DeleteLicense",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$delete_license_input(LicenseArn = LicenseArn, SourceVersion = SourceVersion)
  output <- .licensemanager$delete_license_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$delete_license <- licensemanager_delete_license

#' Deletes the specified license configuration
#'
#' @description
#' Deletes the specified license configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_delete_license_configuration/](https://www.paws-r-sdk.com/docs/licensemanager_delete_license_configuration/) for full documentation.
#'
#' @param LicenseConfigurationArn &#91;required&#93; ID of the license configuration.
#'
#' @keywords internal
#'
#' @rdname licensemanager_delete_license_configuration
licensemanager_delete_license_configuration <- function(LicenseConfigurationArn) {
  op <- new_operation(
    name = "DeleteLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$delete_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn)
  output <- .licensemanager$delete_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$delete_license_configuration <- licensemanager_delete_license_configuration

#' Deletes the specified report generator
#'
#' @description
#' Deletes the specified report generator.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_delete_license_manager_report_generator/](https://www.paws-r-sdk.com/docs/licensemanager_delete_license_manager_report_generator/) for full documentation.
#'
#' @param LicenseManagerReportGeneratorArn &#91;required&#93; Amazon Resource Name (ARN) of the report generator to be deleted.
#'
#' @keywords internal
#'
#' @rdname licensemanager_delete_license_manager_report_generator
licensemanager_delete_license_manager_report_generator <- function(LicenseManagerReportGeneratorArn) {
  op <- new_operation(
    name = "DeleteLicenseManagerReportGenerator",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$delete_license_manager_report_generator_input(LicenseManagerReportGeneratorArn = LicenseManagerReportGeneratorArn)
  output <- .licensemanager$delete_license_manager_report_generator_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$delete_license_manager_report_generator <- licensemanager_delete_license_manager_report_generator

#' Deletes the specified token
#'
#' @description
#' Deletes the specified token. Must be called in the license home Region.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_delete_token/](https://www.paws-r-sdk.com/docs/licensemanager_delete_token/) for full documentation.
#'
#' @param TokenId &#91;required&#93; Token ID.
#'
#' @keywords internal
#'
#' @rdname licensemanager_delete_token
licensemanager_delete_token <- function(TokenId) {
  op <- new_operation(
    name = "DeleteToken",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$delete_token_input(TokenId = TokenId)
  output <- .licensemanager$delete_token_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$delete_token <- licensemanager_delete_token

#' Extends the expiration date for license consumption
#'
#' @description
#' Extends the expiration date for license consumption.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_extend_license_consumption/](https://www.paws-r-sdk.com/docs/licensemanager_extend_license_consumption/) for full documentation.
#'
#' @param LicenseConsumptionToken &#91;required&#93; License consumption token.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request. Provides an error response if you do not
#' have the required permissions.
#'
#' @keywords internal
#'
#' @rdname licensemanager_extend_license_consumption
licensemanager_extend_license_consumption <- function(LicenseConsumptionToken, DryRun = NULL) {
  op <- new_operation(
    name = "ExtendLicenseConsumption",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$extend_license_consumption_input(LicenseConsumptionToken = LicenseConsumptionToken, DryRun = DryRun)
  output <- .licensemanager$extend_license_consumption_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$extend_license_consumption <- licensemanager_extend_license_consumption

#' Gets a temporary access token to use with AssumeRoleWithWebIdentity
#'
#' @description
#' Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_get_access_token/](https://www.paws-r-sdk.com/docs/licensemanager_get_access_token/) for full documentation.
#'
#' @param Token &#91;required&#93; Refresh token, encoded as a JWT token.
#' @param TokenProperties Token properties to validate against those present in the JWT token.
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_access_token
licensemanager_get_access_token <- function(Token, TokenProperties = NULL) {
  op <- new_operation(
    name = "GetAccessToken",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$get_access_token_input(Token = Token, TokenProperties = TokenProperties)
  output <- .licensemanager$get_access_token_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_access_token <- licensemanager_get_access_token

#' Gets detailed information about the specified grant
#'
#' @description
#' Gets detailed information about the specified grant.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_get_grant/](https://www.paws-r-sdk.com/docs/licensemanager_get_grant/) for full documentation.
#'
#' @param GrantArn &#91;required&#93; Amazon Resource Name (ARN) of the grant.
#' @param Version Grant version.
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_grant
licensemanager_get_grant <- function(GrantArn, Version = NULL) {
  op <- new_operation(
    name = "GetGrant",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$get_grant_input(GrantArn = GrantArn, Version = Version)
  output <- .licensemanager$get_grant_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_grant <- licensemanager_get_grant

#' Gets detailed information about the specified license
#'
#' @description
#' Gets detailed information about the specified license.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_get_license/](https://www.paws-r-sdk.com/docs/licensemanager_get_license/) for full documentation.
#'
#' @param LicenseArn &#91;required&#93; Amazon Resource Name (ARN) of the license.
#' @param Version License version.
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_license
licensemanager_get_license <- function(LicenseArn, Version = NULL) {
  op <- new_operation(
    name = "GetLicense",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$get_license_input(LicenseArn = LicenseArn, Version = Version)
  output <- .licensemanager$get_license_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_license <- licensemanager_get_license

#' Gets detailed information about the specified license configuration
#'
#' @description
#' Gets detailed information about the specified license configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_get_license_configuration/](https://www.paws-r-sdk.com/docs/licensemanager_get_license_configuration/) for full documentation.
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_license_configuration
licensemanager_get_license_configuration <- function(LicenseConfigurationArn) {
  op <- new_operation(
    name = "GetLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$get_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn)
  output <- .licensemanager$get_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_license_configuration <- licensemanager_get_license_configuration

#' Gets information about the specified license type conversion task
#'
#' @description
#' Gets information about the specified license type conversion task.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_get_license_conversion_task/](https://www.paws-r-sdk.com/docs/licensemanager_get_license_conversion_task/) for full documentation.
#'
#' @param LicenseConversionTaskId &#91;required&#93; ID of the license type conversion task to retrieve information on.
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_license_conversion_task
licensemanager_get_license_conversion_task <- function(LicenseConversionTaskId) {
  op <- new_operation(
    name = "GetLicenseConversionTask",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$get_license_conversion_task_input(LicenseConversionTaskId = LicenseConversionTaskId)
  output <- .licensemanager$get_license_conversion_task_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_license_conversion_task <- licensemanager_get_license_conversion_task

#' Gets information about the specified report generator
#'
#' @description
#' Gets information about the specified report generator.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_get_license_manager_report_generator/](https://www.paws-r-sdk.com/docs/licensemanager_get_license_manager_report_generator/) for full documentation.
#'
#' @param LicenseManagerReportGeneratorArn &#91;required&#93; Amazon Resource Name (ARN) of the report generator.
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_license_manager_report_generator
licensemanager_get_license_manager_report_generator <- function(LicenseManagerReportGeneratorArn) {
  op <- new_operation(
    name = "GetLicenseManagerReportGenerator",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$get_license_manager_report_generator_input(LicenseManagerReportGeneratorArn = LicenseManagerReportGeneratorArn)
  output <- .licensemanager$get_license_manager_report_generator_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_license_manager_report_generator <- licensemanager_get_license_manager_report_generator

#' Gets detailed information about the usage of the specified license
#'
#' @description
#' Gets detailed information about the usage of the specified license.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_get_license_usage/](https://www.paws-r-sdk.com/docs/licensemanager_get_license_usage/) for full documentation.
#'
#' @param LicenseArn &#91;required&#93; Amazon Resource Name (ARN) of the license.
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_license_usage
licensemanager_get_license_usage <- function(LicenseArn) {
  op <- new_operation(
    name = "GetLicenseUsage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$get_license_usage_input(LicenseArn = LicenseArn)
  output <- .licensemanager$get_license_usage_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_license_usage <- licensemanager_get_license_usage

#' Gets the License Manager settings for the current Region
#'
#' @description
#' Gets the License Manager settings for the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_get_service_settings/](https://www.paws-r-sdk.com/docs/licensemanager_get_service_settings/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname licensemanager_get_service_settings
licensemanager_get_service_settings <- function() {
  op <- new_operation(
    name = "GetServiceSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$get_service_settings_input()
  output <- .licensemanager$get_service_settings_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_service_settings <- licensemanager_get_service_settings

#' Lists the resource associations for the specified license configuration
#'
#' @description
#' Lists the resource associations for the specified license configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_associations_for_license_configuration/](https://www.paws-r-sdk.com/docs/licensemanager_list_associations_for_license_configuration/) for full documentation.
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name (ARN) of a license configuration.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_associations_for_license_configuration
licensemanager_list_associations_for_license_configuration <- function(LicenseConfigurationArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociationsForLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_associations_for_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanager$list_associations_for_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_associations_for_license_configuration <- licensemanager_list_associations_for_license_configuration

#' Lists the grants distributed for the specified license
#'
#' @description
#' Lists the grants distributed for the specified license.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_distributed_grants/](https://www.paws-r-sdk.com/docs/licensemanager_list_distributed_grants/) for full documentation.
#'
#' @param GrantArns Amazon Resource Names (ARNs) of the grants.
#' @param Filters Filters to scope the results. The following filters are supported:
#' 
#' -   `LicenseArn`
#' 
#' -   `GrantStatus`
#' 
#' -   `GranteePrincipalARN`
#' 
#' -   `ProductSKU`
#' 
#' -   `LicenseIssuerName`
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_distributed_grants
licensemanager_list_distributed_grants <- function(GrantArns = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDistributedGrants",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_distributed_grants_input(GrantArns = GrantArns, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_distributed_grants_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_distributed_grants <- licensemanager_list_distributed_grants

#' Lists the license configuration operations that failed
#'
#' @description
#' Lists the license configuration operations that failed.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_failures_for_license_configuration_operations/](https://www.paws-r-sdk.com/docs/licensemanager_list_failures_for_license_configuration_operations/) for full documentation.
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name of the license configuration.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_failur_for_licens_config_operat
licensemanager_list_failures_for_license_configuration_operations <- function(LicenseConfigurationArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFailuresForLicenseConfigurationOperations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_failures_for_license_configuration_operations_input(LicenseConfigurationArn = LicenseConfigurationArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanager$list_failures_for_license_configuration_operations_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_failures_for_license_configuration_operations <- licensemanager_list_failures_for_license_configuration_operations

#' Lists the license configurations for your account
#'
#' @description
#' Lists the license configurations for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_license_configurations/](https://www.paws-r-sdk.com/docs/licensemanager_list_license_configurations/) for full documentation.
#'
#' @param LicenseConfigurationArns Amazon Resource Names (ARN) of the license configurations.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#' @param Filters Filters to scope the results. The following filters and logical
#' operators are supported:
#' 
#' -   `licenseCountingType` - The dimension for which licenses are
#'     counted. Possible values are `vCPU` | `Instance` | `Core` |
#'     `Socket`. Logical operators are `EQUALS` | `NOT_EQUALS`.
#' 
#' -   `enforceLicenseCount` - A Boolean value that indicates whether hard
#'     license enforcement is used. Logical operators are `EQUALS` |
#'     `NOT_EQUALS`.
#' 
#' -   `usagelimitExceeded` - A Boolean value that indicates whether the
#'     available licenses have been exceeded. Logical operators are
#'     `EQUALS` | `NOT_EQUALS`.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_configurations
licensemanager_list_license_configurations <- function(LicenseConfigurationArns = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListLicenseConfigurations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_license_configurations_input(LicenseConfigurationArns = LicenseConfigurationArns, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_license_configurations_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_configurations <- licensemanager_list_license_configurations

#' Lists the license type conversion tasks for your account
#'
#' @description
#' Lists the license type conversion tasks for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_license_conversion_tasks/](https://www.paws-r-sdk.com/docs/licensemanager_list_license_conversion_tasks/) for full documentation.
#'
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param Filters Filters to scope the results. Valid filters are `ResourceArns` and
#' `Status`.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_conversion_tasks
licensemanager_list_license_conversion_tasks <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListLicenseConversionTasks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_license_conversion_tasks_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .licensemanager$list_license_conversion_tasks_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_conversion_tasks <- licensemanager_list_license_conversion_tasks

#' Lists the report generators for your account
#'
#' @description
#' Lists the report generators for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_license_manager_report_generators/](https://www.paws-r-sdk.com/docs/licensemanager_list_license_manager_report_generators/) for full documentation.
#'
#' @param Filters Filters to scope the results. The following filters are supported:
#' 
#' -   `LicenseConfigurationArn`
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_manager_report_generators
licensemanager_list_license_manager_report_generators <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLicenseManagerReportGenerators",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_license_manager_report_generators_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_license_manager_report_generators_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_manager_report_generators <- licensemanager_list_license_manager_report_generators

#' Describes the license configurations for the specified resource
#'
#' @description
#' Describes the license configurations for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_license_specifications_for_resource/](https://www.paws-r-sdk.com/docs/licensemanager_list_license_specifications_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of a resource that has an associated license
#' configuration.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_specifications_for_resource
licensemanager_list_license_specifications_for_resource <- function(ResourceArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLicenseSpecificationsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_license_specifications_for_resource_input(ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanager$list_license_specifications_for_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_specifications_for_resource <- licensemanager_list_license_specifications_for_resource

#' Lists all versions of the specified license
#'
#' @description
#' Lists all versions of the specified license.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_license_versions/](https://www.paws-r-sdk.com/docs/licensemanager_list_license_versions/) for full documentation.
#'
#' @param LicenseArn &#91;required&#93; Amazon Resource Name (ARN) of the license.
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_versions
licensemanager_list_license_versions <- function(LicenseArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLicenseVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_license_versions_input(LicenseArn = LicenseArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_license_versions_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_versions <- licensemanager_list_license_versions

#' Lists the licenses for your account
#'
#' @description
#' Lists the licenses for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_licenses/](https://www.paws-r-sdk.com/docs/licensemanager_list_licenses/) for full documentation.
#'
#' @param LicenseArns Amazon Resource Names (ARNs) of the licenses.
#' @param Filters Filters to scope the results. The following filters are supported:
#' 
#' -   `Beneficiary`
#' 
#' -   `ProductSKU`
#' 
#' -   `Fingerprint`
#' 
#' -   `Status`
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_licenses
licensemanager_list_licenses <- function(LicenseArns = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLicenses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_licenses_input(LicenseArns = LicenseArns, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_licenses_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_licenses <- licensemanager_list_licenses

#' Lists grants that are received
#'
#' @description
#' Lists grants that are received. Received grants are grants created while specifying the recipient as this Amazon Web Services account, your organization, or an organizational unit (OU) to which this member account belongs.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_received_grants/](https://www.paws-r-sdk.com/docs/licensemanager_list_received_grants/) for full documentation.
#'
#' @param GrantArns Amazon Resource Names (ARNs) of the grants.
#' @param Filters Filters to scope the results. The following filters are supported:
#' 
#' -   `ProductSKU`
#' 
#' -   `LicenseIssuerName`
#' 
#' -   `LicenseArn`
#' 
#' -   `GrantStatus`
#' 
#' -   `GranterAccountId`
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_received_grants
licensemanager_list_received_grants <- function(GrantArns = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListReceivedGrants",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_received_grants_input(GrantArns = GrantArns, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_received_grants_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_received_grants <- licensemanager_list_received_grants

#' Lists the grants received for all accounts in the organization
#'
#' @description
#' Lists the grants received for all accounts in the organization.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_received_grants_for_organization/](https://www.paws-r-sdk.com/docs/licensemanager_list_received_grants_for_organization/) for full documentation.
#'
#' @param LicenseArn &#91;required&#93; The Amazon Resource Name (ARN) of the received license.
#' @param Filters Filters to scope the results. The following filters are supported:
#' 
#' -   `ParentArn`
#' 
#' -   `GranteePrincipalArn`
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_received_grants_for_organization
licensemanager_list_received_grants_for_organization <- function(LicenseArn, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListReceivedGrantsForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_received_grants_for_organization_input(LicenseArn = LicenseArn, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_received_grants_for_organization_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_received_grants_for_organization <- licensemanager_list_received_grants_for_organization

#' Lists received licenses
#'
#' @description
#' Lists received licenses.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_received_licenses/](https://www.paws-r-sdk.com/docs/licensemanager_list_received_licenses/) for full documentation.
#'
#' @param LicenseArns Amazon Resource Names (ARNs) of the licenses.
#' @param Filters Filters to scope the results. The following filters are supported:
#' 
#' -   `ProductSKU`
#' 
#' -   `Status`
#' 
#' -   `Fingerprint`
#' 
#' -   `IssuerName`
#' 
#' -   `Beneficiary`
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_received_licenses
licensemanager_list_received_licenses <- function(LicenseArns = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListReceivedLicenses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_received_licenses_input(LicenseArns = LicenseArns, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_received_licenses_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_received_licenses <- licensemanager_list_received_licenses

#' Lists the licenses received for all accounts in the organization
#'
#' @description
#' Lists the licenses received for all accounts in the organization.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_received_licenses_for_organization/](https://www.paws-r-sdk.com/docs/licensemanager_list_received_licenses_for_organization/) for full documentation.
#'
#' @param Filters Filters to scope the results. The following filters are supported:
#' 
#' -   `Beneficiary`
#' 
#' -   `ProductSKU`
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_received_licenses_for_organization
licensemanager_list_received_licenses_for_organization <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListReceivedLicensesForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_received_licenses_for_organization_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_received_licenses_for_organization_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_received_licenses_for_organization <- licensemanager_list_received_licenses_for_organization

#' Lists resources managed using Systems Manager inventory
#'
#' @description
#' Lists resources managed using Systems Manager inventory.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_resource_inventory/](https://www.paws-r-sdk.com/docs/licensemanager_list_resource_inventory/) for full documentation.
#'
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#' @param Filters Filters to scope the results. The following filters and logical
#' operators are supported:
#' 
#' -   `account_id` - The ID of the Amazon Web Services account that owns
#'     the resource. Logical operators are `EQUALS` | `NOT_EQUALS`.
#' 
#' -   `application_name` - The name of the application. Logical operators
#'     are `EQUALS` | `BEGINS_WITH`.
#' 
#' -   `license_included` - The type of license included. Logical operators
#'     are `EQUALS` | `NOT_EQUALS`. Possible values are
#'     `sql-server-enterprise` | `sql-server-standard` | `sql-server-web` |
#'     `windows-server-datacenter`.
#' 
#' -   `platform` - The platform of the resource. Logical operators are
#'     `EQUALS` | `BEGINS_WITH`.
#' 
#' -   `resource_id` - The ID of the resource. Logical operators are
#'     `EQUALS` | `NOT_EQUALS`.
#' 
#' -   `tag:<key>` - The key/value combination of a tag assigned to the
#'     resource. Logical operators are `EQUALS` (single account) or
#'     `EQUALS` | `NOT_EQUALS` (cross account).
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_resource_inventory
licensemanager_list_resource_inventory <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResourceInventory",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_resource_inventory_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_resource_inventory_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_resource_inventory <- licensemanager_list_resource_inventory

#' Lists the tags for the specified license configuration
#'
#' @description
#' Lists the tags for the specified license configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/licensemanager_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_tags_for_resource
licensemanager_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .licensemanager$list_tags_for_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_tags_for_resource <- licensemanager_list_tags_for_resource

#' Lists your tokens
#'
#' @description
#' Lists your tokens.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_tokens/](https://www.paws-r-sdk.com/docs/licensemanager_list_tokens/) for full documentation.
#'
#' @param TokenIds Token IDs.
#' @param Filters Filters to scope the results. The following filter is supported:
#' 
#' -   `LicenseArns`
#' @param NextToken Token for the next set of results.
#' @param MaxResults Maximum number of results to return in a single call.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_tokens
licensemanager_list_tokens <- function(TokenIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTokens",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_tokens_input(TokenIds = TokenIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .licensemanager$list_tokens_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_tokens <- licensemanager_list_tokens

#' Lists all license usage records for a license configuration, displaying
#' license consumption details by resource at a selected point in time
#'
#' @description
#' Lists all license usage records for a license configuration, displaying license consumption details by resource at a selected point in time. Use this action to audit the current license consumption for any license inventory and configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_list_usage_for_license_configuration/](https://www.paws-r-sdk.com/docs/licensemanager_list_usage_for_license_configuration/) for full documentation.
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#' @param Filters Filters to scope the results. The following filters and logical
#' operators are supported:
#' 
#' -   `resourceArn` - The ARN of the license configuration resource.
#'     Logical operators are `EQUALS` | `NOT_EQUALS`.
#' 
#' -   `resourceType` - The resource type (`EC2_INSTANCE` | `EC2_HOST` |
#'     `EC2_AMI` | `SYSTEMS_MANAGER_MANAGED_INSTANCE`). Logical operators
#'     are `EQUALS` | `NOT_EQUALS`.
#' 
#' -   `resourceAccount` - The ID of the account that owns the resource.
#'     Logical operators are `EQUALS` | `NOT_EQUALS`.
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_usage_for_license_configuration
licensemanager_list_usage_for_license_configuration <- function(LicenseConfigurationArn, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListUsageForLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$list_usage_for_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_usage_for_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_usage_for_license_configuration <- licensemanager_list_usage_for_license_configuration

#' Rejects the specified grant
#'
#' @description
#' Rejects the specified grant.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_reject_grant/](https://www.paws-r-sdk.com/docs/licensemanager_reject_grant/) for full documentation.
#'
#' @param GrantArn &#91;required&#93; Amazon Resource Name (ARN) of the grant.
#'
#' @keywords internal
#'
#' @rdname licensemanager_reject_grant
licensemanager_reject_grant <- function(GrantArn) {
  op <- new_operation(
    name = "RejectGrant",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$reject_grant_input(GrantArn = GrantArn)
  output <- .licensemanager$reject_grant_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$reject_grant <- licensemanager_reject_grant

#' Adds the specified tags to the specified license configuration
#'
#' @description
#' Adds the specified tags to the specified license configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_tag_resource/](https://www.paws-r-sdk.com/docs/licensemanager_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#' @param Tags &#91;required&#93; One or more tags.
#'
#' @keywords internal
#'
#' @rdname licensemanager_tag_resource
licensemanager_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .licensemanager$tag_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$tag_resource <- licensemanager_tag_resource

#' Removes the specified tags from the specified license configuration
#'
#' @description
#' Removes the specified tags from the specified license configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_untag_resource/](https://www.paws-r-sdk.com/docs/licensemanager_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#' @param TagKeys &#91;required&#93; Keys identifying the tags to remove.
#'
#' @keywords internal
#'
#' @rdname licensemanager_untag_resource
licensemanager_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .licensemanager$untag_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$untag_resource <- licensemanager_untag_resource

#' Modifies the attributes of an existing license configuration
#'
#' @description
#' Modifies the attributes of an existing license configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_update_license_configuration/](https://www.paws-r-sdk.com/docs/licensemanager_update_license_configuration/) for full documentation.
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#' @param LicenseConfigurationStatus New status of the license configuration.
#' @param LicenseRules New license rule. The only rule that you can add after you create a
#' license configuration is licenseAffinityToHost.
#' @param LicenseCount New number of licenses managed by the license configuration.
#' @param LicenseCountHardLimit New hard limit of the number of available licenses.
#' @param Name New name of the license configuration.
#' @param Description New description of the license configuration.
#' @param ProductInformationList New product information.
#' @param DisassociateWhenNotFound When true, disassociates a resource when software is uninstalled.
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_license_configuration
licensemanager_update_license_configuration <- function(LicenseConfigurationArn, LicenseConfigurationStatus = NULL, LicenseRules = NULL, LicenseCount = NULL, LicenseCountHardLimit = NULL, Name = NULL, Description = NULL, ProductInformationList = NULL, DisassociateWhenNotFound = NULL) {
  op <- new_operation(
    name = "UpdateLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$update_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, LicenseConfigurationStatus = LicenseConfigurationStatus, LicenseRules = LicenseRules, LicenseCount = LicenseCount, LicenseCountHardLimit = LicenseCountHardLimit, Name = Name, Description = Description, ProductInformationList = ProductInformationList, DisassociateWhenNotFound = DisassociateWhenNotFound)
  output <- .licensemanager$update_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_license_configuration <- licensemanager_update_license_configuration

#' Updates a report generator
#'
#' @description
#' Updates a report generator.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_update_license_manager_report_generator/](https://www.paws-r-sdk.com/docs/licensemanager_update_license_manager_report_generator/) for full documentation.
#'
#' @param LicenseManagerReportGeneratorArn &#91;required&#93; Amazon Resource Name (ARN) of the report generator to update.
#' @param ReportGeneratorName &#91;required&#93; Name of the report generator.
#' @param Type &#91;required&#93; Type of reports to generate. The following report types are supported:
#' 
#' -   License configuration report - Reports the number and details of
#'     consumed licenses for a license configuration.
#' 
#' -   Resource report - Reports the tracked licenses and resource
#'     consumption for a license configuration.
#' @param ReportContext &#91;required&#93; The report context.
#' @param ReportFrequency &#91;required&#93; Frequency by which reports are generated.
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param Description Description of the report generator.
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_license_manager_report_generator
licensemanager_update_license_manager_report_generator <- function(LicenseManagerReportGeneratorArn, ReportGeneratorName, Type, ReportContext, ReportFrequency, ClientToken, Description = NULL) {
  op <- new_operation(
    name = "UpdateLicenseManagerReportGenerator",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$update_license_manager_report_generator_input(LicenseManagerReportGeneratorArn = LicenseManagerReportGeneratorArn, ReportGeneratorName = ReportGeneratorName, Type = Type, ReportContext = ReportContext, ReportFrequency = ReportFrequency, ClientToken = ClientToken, Description = Description)
  output <- .licensemanager$update_license_manager_report_generator_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_license_manager_report_generator <- licensemanager_update_license_manager_report_generator

#' Adds or removes the specified license configurations for the specified
#' Amazon Web Services resource
#'
#' @description
#' Adds or removes the specified license configurations for the specified Amazon Web Services resource.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_update_license_specifications_for_resource/](https://www.paws-r-sdk.com/docs/licensemanager_update_license_specifications_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the Amazon Web Services resource.
#' @param AddLicenseSpecifications ARNs of the license configurations to add.
#' @param RemoveLicenseSpecifications ARNs of the license configurations to remove.
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_license_specifications_for_resource
licensemanager_update_license_specifications_for_resource <- function(ResourceArn, AddLicenseSpecifications = NULL, RemoveLicenseSpecifications = NULL) {
  op <- new_operation(
    name = "UpdateLicenseSpecificationsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$update_license_specifications_for_resource_input(ResourceArn = ResourceArn, AddLicenseSpecifications = AddLicenseSpecifications, RemoveLicenseSpecifications = RemoveLicenseSpecifications)
  output <- .licensemanager$update_license_specifications_for_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_license_specifications_for_resource <- licensemanager_update_license_specifications_for_resource

#' Updates License Manager settings for the current Region
#'
#' @description
#' Updates License Manager settings for the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanager_update_service_settings/](https://www.paws-r-sdk.com/docs/licensemanager_update_service_settings/) for full documentation.
#'
#' @param S3BucketArn Amazon Resource Name (ARN) of the Amazon S3 bucket where the License
#' Manager information is stored.
#' @param SnsTopicArn Amazon Resource Name (ARN) of the Amazon SNS topic used for License
#' Manager alerts.
#' @param OrganizationConfiguration Enables integration with Organizations for cross-account discovery.
#' @param EnableCrossAccountsDiscovery Activates cross-account discovery.
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_service_settings
licensemanager_update_service_settings <- function(S3BucketArn = NULL, SnsTopicArn = NULL, OrganizationConfiguration = NULL, EnableCrossAccountsDiscovery = NULL) {
  op <- new_operation(
    name = "UpdateServiceSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .licensemanager$update_service_settings_input(S3BucketArn = S3BucketArn, SnsTopicArn = SnsTopicArn, OrganizationConfiguration = OrganizationConfiguration, EnableCrossAccountsDiscovery = EnableCrossAccountsDiscovery)
  output <- .licensemanager$update_service_settings_output()
  config <- get_config()
  svc <- .licensemanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_service_settings <- licensemanager_update_service_settings
