% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_remove_permission}
\alias{cloudwatchevents_remove_permission}
\title{Revokes the permission of another Amazon Web Services account to be able
to put events to the specified event bus}
\usage{
cloudwatchevents_remove_permission(
  StatementId = NULL,
  RemoveAllPermissions = NULL,
  EventBusName = NULL
)
}
\arguments{
\item{StatementId}{The statement ID corresponding to the account that is no longer allowed
to put events to the default event bus.}

\item{RemoveAllPermissions}{Specifies whether to remove all permissions.}

\item{EventBusName}{The name of the event bus to revoke permissions for. If you omit this,
the default event bus is used.}
}
\description{
Revokes the permission of another Amazon Web Services account to be able to put events to the specified event bus. Specify the account to revoke by the \code{StatementId} value that you associated with the account when you granted it permission with \code{\link[=cloudwatchevents_put_permission]{put_permission}}. You can find the \code{StatementId} by using \code{\link[=cloudwatchevents_describe_event_bus]{describe_event_bus}}.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchevents_remove_permission/} for full documentation.
}
\keyword{internal}
