% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_untag_resource}
\alias{cloudwatchlogs_untag_resource}
\title{Removes one or more tags from the specified resource}
\usage{
cloudwatchlogs_untag_resource(resourceArn, tagKeys)
}
\arguments{
\item{resourceArn}{[required] The ARN of the CloudWatch Logs resource that you're removing tags from.

The ARN format of a log group is
\code{arn:aws:logs:Region:account-id:log-group:log-group-name }

The ARN format of a destination is
\code{arn:aws:logs:Region:account-id:destination:destination-name }

For more information about ARN format, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html}{CloudWatch Logs resources and operations}.}

\item{tagKeys}{[required] The list of tag keys to remove from the resource.}
}
\description{
Removes one or more tags from the specified resource.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_untag_resource/} for full documentation.
}
\keyword{internal}
