% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationautoscaling_operations.R
\name{applicationautoscaling_get_predictive_scaling_forecast}
\alias{applicationautoscaling_get_predictive_scaling_forecast}
\title{Retrieves the forecast data for a predictive scaling policy}
\usage{
applicationautoscaling_get_predictive_scaling_forecast(
  ServiceNamespace,
  ResourceId,
  ScalableDimension,
  PolicyName,
  StartTime,
  EndTime
)
}
\arguments{
\item{ServiceNamespace}{[required] The namespace of the Amazon Web Services service that provides the
resource. For a resource provided by your own application or service,
use \code{custom-resource} instead.}

\item{ResourceId}{[required] The identifier of the resource.}

\item{ScalableDimension}{[required] The scalable dimension.}

\item{PolicyName}{[required] The name of the policy.}

\item{StartTime}{[required] The inclusive start time of the time range for the forecast data to get.
At most, the date and time can be one year before the current date and
time}

\item{EndTime}{[required] The exclusive end time of the time range for the forecast data to get.
The maximum time duration between the start and end time is 30 days.}
}
\description{
Retrieves the forecast data for a predictive scaling policy.

See \url{https://www.paws-r-sdk.com/docs/applicationautoscaling_get_predictive_scaling_forecast/} for full documentation.
}
\keyword{internal}
