% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_anomaly_detector}
\alias{cloudwatch_put_anomaly_detector}
\title{Creates an anomaly detection model for a CloudWatch metric}
\usage{
cloudwatch_put_anomaly_detector(
  Namespace = NULL,
  MetricName = NULL,
  Dimensions = NULL,
  Stat = NULL,
  Configuration = NULL,
  MetricCharacteristics = NULL,
  SingleMetricAnomalyDetector = NULL,
  MetricMathAnomalyDetector = NULL
)
}
\arguments{
\item{Namespace}{The namespace of the metric to create the anomaly detection model for.}

\item{MetricName}{The name of the metric to create the anomaly detection model for.}

\item{Dimensions}{The metric dimensions to create the anomaly detection model for.}

\item{Stat}{The statistic to use for the metric and the anomaly detection model.}

\item{Configuration}{The configuration specifies details about how the anomaly detection
model is to be trained, including time ranges to exclude when training
and updating the model. You can specify as many as 10 time ranges.

The configuration can also include the time zone to use for the metric.}

\item{MetricCharacteristics}{Use this object to include parameters to provide information about your
metric to CloudWatch to help it build more accurate anomaly detection
models. Currently, it includes the \code{PeriodicSpikes} parameter.}

\item{SingleMetricAnomalyDetector}{A single metric anomaly detector to be created.

When using \code{SingleMetricAnomalyDetector}, you cannot include the
following parameters in the same operation:
\itemize{
\item \code{Dimensions}
\item \code{MetricName}
\item \code{Namespace}
\item \code{Stat}
\item the \code{MetricMathAnomalyDetector} parameters of
\code{PutAnomalyDetectorInput}
}

Instead, specify the single metric anomaly detector attributes as part
of the property \code{SingleMetricAnomalyDetector}.}

\item{MetricMathAnomalyDetector}{The metric math anomaly detector to be created.

When using \code{MetricMathAnomalyDetector}, you cannot include the following
parameters in the same operation:
\itemize{
\item \code{Dimensions}
\item \code{MetricName}
\item \code{Namespace}
\item \code{Stat}
\item the \code{SingleMetricAnomalyDetector} parameters of
\code{PutAnomalyDetectorInput}
}

Instead, specify the metric math anomaly detector attributes as part of
the property \code{MetricMathAnomalyDetector}.}
}
\description{
Creates an anomaly detection model for a CloudWatch metric. You can use the model to display a band of expected normal values when the metric is graphed.

See \url{https://www.paws-r-sdk.com/docs/cloudwatch_put_anomaly_detector/} for full documentation.
}
\keyword{internal}
