% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_create_feature}
\alias{cloudwatchevidently_create_feature}
\title{Creates an Evidently feature that you want to launch or test}
\usage{
cloudwatchevidently_create_feature(
  defaultVariation = NULL,
  description = NULL,
  entityOverrides = NULL,
  evaluationStrategy = NULL,
  name,
  project,
  tags = NULL,
  variations
)
}
\arguments{
\item{defaultVariation}{The name of the variation to use as the default variation. The default
variation is served to users who are not allocated to any ongoing
launches or experiments of this feature.

This variation must also be listed in the \code{variations} structure.

If you omit \code{defaultVariation}, the first variation listed in the
\code{variations} structure is used as the default variation.}

\item{description}{An optional description of the feature.}

\item{entityOverrides}{Specify users that should always be served a specific variation of a
feature. Each user is specified by a key-value pair . For each key,
specify a user by entering their user ID, account ID, or some other
identifier. For the value, specify the name of the variation that they
are to be served.

This parameter is limited to 2500 overrides or a total of 40KB. The 40KB
limit includes an overhead of 6 bytes per override.}

\item{evaluationStrategy}{Specify \code{ALL_RULES} to activate the traffic allocation specified by any
ongoing launches or experiments. Specify \code{DEFAULT_VARIATION} to serve
the default variation to all users instead.}

\item{name}{[required] The name for the new feature.}

\item{project}{[required] The name or ARN of the project that is to contain the new feature.}

\item{tags}{Assigns one or more tags (key-value pairs) to the feature.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.

Tags don't have any semantic meaning to Amazon Web Services and are
interpreted strictly as strings of characters.

You can associate as many as 50 tags with a feature.

For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}.}

\item{variations}{[required] An array of structures that contain the configuration of the feature's
different variations.}
}
\description{
Creates an Evidently \emph{feature} that you want to launch or test. You can define up to five variations of a feature, and use these variations in your launches and experiments. A feature must be created in a project. For information about creating a project, see \code{\link[=cloudwatchevidently_create_project]{create_project}}.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_feature/} for full documentation.
}
\keyword{internal}
