# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include account_service.R
NULL

#' Accepts the request that originated from StartPrimaryEmailUpdate to
#' update the primary email address (also known as the root user email
#' address) for the specified account
#'
#' @description
#' Accepts the request that originated from [`start_primary_email_update`][account_start_primary_email_update] to update the primary email address (also known as the root user email address) for the specified account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_accept_primary_email_update/](https://www.paws-r-sdk.com/docs/account_accept_primary_email_update/) for full documentation.
#'
#' @param AccountId &#91;required&#93; Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. To use
#' this parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' This operation can only be called from the management account or the
#' delegated administrator account of an organization for a member account.
#' 
#' The management account can't specify its own `AccountId`.
#' @param Otp &#91;required&#93; The OTP code sent to the `PrimaryEmail` specified on the
#' [`start_primary_email_update`][account_start_primary_email_update] API
#' call.
#' @param PrimaryEmail &#91;required&#93; The new primary email address for use with the specified account. This
#' must match the `PrimaryEmail` from the
#' [`start_primary_email_update`][account_start_primary_email_update] API
#' call.
#'
#' @keywords internal
#'
#' @rdname account_accept_primary_email_update
account_accept_primary_email_update <- function(AccountId, Otp, PrimaryEmail) {
  op <- new_operation(
    name = "AcceptPrimaryEmailUpdate",
    http_method = "POST",
    http_path = "/acceptPrimaryEmailUpdate",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$accept_primary_email_update_input(AccountId = AccountId, Otp = Otp, PrimaryEmail = PrimaryEmail)
  output <- .account$accept_primary_email_update_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$accept_primary_email_update <- account_accept_primary_email_update

#' Deletes the specified alternate contact from an Amazon Web Services
#' account
#'
#' @description
#' Deletes the specified alternate contact from an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_delete_alternate_contact/](https://www.paws-r-sdk.com/docs/account_delete_alternate_contact/) for full documentation.
#'
#' @param AccountId Specifies the 12 digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation.
#' 
#' If you do not specify this parameter, it defaults to the Amazon Web
#' Services account of the identity used to call the operation.
#' 
#' To use this parameter, the caller must be an identity in the
#' [organization's management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account, and the specified account ID must
#' be a member account in the same organization. The organization must have
#' [all features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`; it must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, then don't specify this parameter, and call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param AlternateContactType &#91;required&#93; Specifies which of the alternate contacts to delete.
#'
#' @keywords internal
#'
#' @rdname account_delete_alternate_contact
account_delete_alternate_contact <- function(AccountId = NULL, AlternateContactType) {
  op <- new_operation(
    name = "DeleteAlternateContact",
    http_method = "POST",
    http_path = "/deleteAlternateContact",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$delete_alternate_contact_input(AccountId = AccountId, AlternateContactType = AlternateContactType)
  output <- .account$delete_alternate_contact_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$delete_alternate_contact <- account_delete_alternate_contact

#' Disables (opts-out) a particular Region for an account
#'
#' @description
#' Disables (opts-out) a particular Region for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_disable_region/](https://www.paws-r-sdk.com/docs/account_disable_region/) for full documentation.
#'
#' @param AccountId Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. If you
#' don't specify this parameter, it defaults to the Amazon Web Services
#' account of the identity used to call the operation. To use this
#' parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`. It must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, don't specify this parameter. Instead, call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param RegionName &#91;required&#93; Specifies the Region-code for a given Region name (for example,
#' `af-south-1`). When you disable a Region, Amazon Web Services performs
#' actions to deactivate that Region in your account, such as destroying
#' IAM resources in the Region. This process takes a few minutes for most
#' accounts, but this can take several hours. You cannot enable the Region
#' until the disabling process is fully completed.
#'
#' @keywords internal
#'
#' @rdname account_disable_region
account_disable_region <- function(AccountId = NULL, RegionName) {
  op <- new_operation(
    name = "DisableRegion",
    http_method = "POST",
    http_path = "/disableRegion",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$disable_region_input(AccountId = AccountId, RegionName = RegionName)
  output <- .account$disable_region_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$disable_region <- account_disable_region

#' Enables (opts-in) a particular Region for an account
#'
#' @description
#' Enables (opts-in) a particular Region for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_enable_region/](https://www.paws-r-sdk.com/docs/account_enable_region/) for full documentation.
#'
#' @param AccountId Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. If you
#' don't specify this parameter, it defaults to the Amazon Web Services
#' account of the identity used to call the operation. To use this
#' parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`. It must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, don't specify this parameter. Instead, call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param RegionName &#91;required&#93; Specifies the Region-code for a given Region name (for example,
#' `af-south-1`). When you enable a Region, Amazon Web Services performs
#' actions to prepare your account in that Region, such as distributing
#' your IAM resources to the Region. This process takes a few minutes for
#' most accounts, but it can take several hours. You cannot use the Region
#' until this process is complete. Furthermore, you cannot disable the
#' Region until the enabling process is fully completed.
#'
#' @keywords internal
#'
#' @rdname account_enable_region
account_enable_region <- function(AccountId = NULL, RegionName) {
  op <- new_operation(
    name = "EnableRegion",
    http_method = "POST",
    http_path = "/enableRegion",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$enable_region_input(AccountId = AccountId, RegionName = RegionName)
  output <- .account$enable_region_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$enable_region <- account_enable_region

#' Retrieves the specified alternate contact attached to an Amazon Web
#' Services account
#'
#' @description
#' Retrieves the specified alternate contact attached to an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_get_alternate_contact/](https://www.paws-r-sdk.com/docs/account_get_alternate_contact/) for full documentation.
#'
#' @param AccountId Specifies the 12 digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation.
#' 
#' If you do not specify this parameter, it defaults to the Amazon Web
#' Services account of the identity used to call the operation.
#' 
#' To use this parameter, the caller must be an identity in the
#' [organization's management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account, and the specified account ID must
#' be a member account in the same organization. The organization must have
#' [all features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`; it must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, then don't specify this parameter, and call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param AlternateContactType &#91;required&#93; Specifies which alternate contact you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname account_get_alternate_contact
account_get_alternate_contact <- function(AccountId = NULL, AlternateContactType) {
  op <- new_operation(
    name = "GetAlternateContact",
    http_method = "POST",
    http_path = "/getAlternateContact",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$get_alternate_contact_input(AccountId = AccountId, AlternateContactType = AlternateContactType)
  output <- .account$get_alternate_contact_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$get_alternate_contact <- account_get_alternate_contact

#' Retrieves the primary contact information of an Amazon Web Services
#' account
#'
#' @description
#' Retrieves the primary contact information of an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_get_contact_information/](https://www.paws-r-sdk.com/docs/account_get_contact_information/) for full documentation.
#'
#' @param AccountId Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. If you
#' don't specify this parameter, it defaults to the Amazon Web Services
#' account of the identity used to call the operation. To use this
#' parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`. It must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, don't specify this parameter. Instead, call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#'
#' @keywords internal
#'
#' @rdname account_get_contact_information
account_get_contact_information <- function(AccountId = NULL) {
  op <- new_operation(
    name = "GetContactInformation",
    http_method = "POST",
    http_path = "/getContactInformation",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$get_contact_information_input(AccountId = AccountId)
  output <- .account$get_contact_information_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$get_contact_information <- account_get_contact_information

#' Retrieves the primary email address for the specified account
#'
#' @description
#' Retrieves the primary email address for the specified account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_get_primary_email/](https://www.paws-r-sdk.com/docs/account_get_primary_email/) for full documentation.
#'
#' @param AccountId &#91;required&#93; Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. To use
#' this parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' This operation can only be called from the management account or the
#' delegated administrator account of an organization for a member account.
#' 
#' The management account can't specify its own `AccountId`.
#'
#' @keywords internal
#'
#' @rdname account_get_primary_email
account_get_primary_email <- function(AccountId) {
  op <- new_operation(
    name = "GetPrimaryEmail",
    http_method = "POST",
    http_path = "/getPrimaryEmail",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$get_primary_email_input(AccountId = AccountId)
  output <- .account$get_primary_email_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$get_primary_email <- account_get_primary_email

#' Retrieves the opt-in status of a particular Region
#'
#' @description
#' Retrieves the opt-in status of a particular Region.
#'
#' See [https://www.paws-r-sdk.com/docs/account_get_region_opt_status/](https://www.paws-r-sdk.com/docs/account_get_region_opt_status/) for full documentation.
#'
#' @param AccountId Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. If you
#' don't specify this parameter, it defaults to the Amazon Web Services
#' account of the identity used to call the operation. To use this
#' parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`. It must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, don't specify this parameter. Instead, call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param RegionName &#91;required&#93; Specifies the Region-code for a given Region name (for example,
#' `af-south-1`). This function will return the status of whatever Region
#' you pass into this parameter.
#'
#' @keywords internal
#'
#' @rdname account_get_region_opt_status
account_get_region_opt_status <- function(AccountId = NULL, RegionName) {
  op <- new_operation(
    name = "GetRegionOptStatus",
    http_method = "POST",
    http_path = "/getRegionOptStatus",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$get_region_opt_status_input(AccountId = AccountId, RegionName = RegionName)
  output <- .account$get_region_opt_status_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$get_region_opt_status <- account_get_region_opt_status

#' Lists all the Regions for a given account and their respective opt-in
#' statuses
#'
#' @description
#' Lists all the Regions for a given account and their respective opt-in statuses. Optionally, this list can be filtered by the `region-opt-status-contains` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/account_list_regions/](https://www.paws-r-sdk.com/docs/account_list_regions/) for full documentation.
#'
#' @param AccountId Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. If you
#' don't specify this parameter, it defaults to the Amazon Web Services
#' account of the identity used to call the operation. To use this
#' parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`. It must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, don't specify this parameter. Instead, call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param MaxResults The total number of items to return in the command’s output. If the
#' total number of items available is more than the value specified, a
#' `NextToken` is provided in the command’s output. To resume pagination,
#' provide the `NextToken` value in the `starting-token` argument of a
#' subsequent command. Do not use the `NextToken` response element directly
#' outside of the Amazon Web Services CLI. For usage examples, see
#' [Pagination](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-pagination.html)
#' in the *Amazon Web Services Command Line Interface User Guide*.
#' @param NextToken A token used to specify where to start paginating. This is the
#' `NextToken` from a previously truncated response. For usage examples,
#' see
#' [Pagination](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-pagination.html)
#' in the *Amazon Web Services Command Line Interface User Guide*.
#' @param RegionOptStatusContains A list of Region statuses (Enabling, Enabled, Disabling, Disabled,
#' Enabled_by_default) to use to filter the list of Regions for a given
#' account. For example, passing in a value of ENABLING will only return a
#' list of Regions with a Region status of ENABLING.
#'
#' @keywords internal
#'
#' @rdname account_list_regions
account_list_regions <- function(AccountId = NULL, MaxResults = NULL, NextToken = NULL, RegionOptStatusContains = NULL) {
  op <- new_operation(
    name = "ListRegions",
    http_method = "POST",
    http_path = "/listRegions",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Regions")
  )
  input <- .account$list_regions_input(AccountId = AccountId, MaxResults = MaxResults, NextToken = NextToken, RegionOptStatusContains = RegionOptStatusContains)
  output <- .account$list_regions_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$list_regions <- account_list_regions

#' Modifies the specified alternate contact attached to an Amazon Web
#' Services account
#'
#' @description
#' Modifies the specified alternate contact attached to an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_put_alternate_contact/](https://www.paws-r-sdk.com/docs/account_put_alternate_contact/) for full documentation.
#'
#' @param AccountId Specifies the 12 digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation.
#' 
#' If you do not specify this parameter, it defaults to the Amazon Web
#' Services account of the identity used to call the operation.
#' 
#' To use this parameter, the caller must be an identity in the
#' [organization's management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account, and the specified account ID must
#' be a member account in the same organization. The organization must have
#' [all features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`; it must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, then don't specify this parameter, and call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param AlternateContactType &#91;required&#93; Specifies which alternate contact you want to create or update.
#' @param EmailAddress &#91;required&#93; Specifies an email address for the alternate contact.
#' @param Name &#91;required&#93; Specifies a name for the alternate contact.
#' @param PhoneNumber &#91;required&#93; Specifies a phone number for the alternate contact.
#' @param Title &#91;required&#93; Specifies a title for the alternate contact.
#'
#' @keywords internal
#'
#' @rdname account_put_alternate_contact
account_put_alternate_contact <- function(AccountId = NULL, AlternateContactType, EmailAddress, Name, PhoneNumber, Title) {
  op <- new_operation(
    name = "PutAlternateContact",
    http_method = "POST",
    http_path = "/putAlternateContact",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$put_alternate_contact_input(AccountId = AccountId, AlternateContactType = AlternateContactType, EmailAddress = EmailAddress, Name = Name, PhoneNumber = PhoneNumber, Title = Title)
  output <- .account$put_alternate_contact_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$put_alternate_contact <- account_put_alternate_contact

#' Updates the primary contact information of an Amazon Web Services
#' account
#'
#' @description
#' Updates the primary contact information of an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_put_contact_information/](https://www.paws-r-sdk.com/docs/account_put_contact_information/) for full documentation.
#'
#' @param AccountId Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. If you
#' don't specify this parameter, it defaults to the Amazon Web Services
#' account of the identity used to call the operation. To use this
#' parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' The management account can't specify its own `AccountId`. It must call
#' the operation in standalone context by not including the `AccountId`
#' parameter.
#' 
#' To call this operation on an account that is not a member of an
#' organization, don't specify this parameter. Instead, call the operation
#' using an identity belonging to the account whose contacts you wish to
#' retrieve or modify.
#' @param ContactInformation &#91;required&#93; Contains the details of the primary contact information associated with
#' an Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname account_put_contact_information
account_put_contact_information <- function(AccountId = NULL, ContactInformation) {
  op <- new_operation(
    name = "PutContactInformation",
    http_method = "POST",
    http_path = "/putContactInformation",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$put_contact_information_input(AccountId = AccountId, ContactInformation = ContactInformation)
  output <- .account$put_contact_information_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$put_contact_information <- account_put_contact_information

#' Starts the process to update the primary email address for the specified
#' account
#'
#' @description
#' Starts the process to update the primary email address for the specified account.
#'
#' See [https://www.paws-r-sdk.com/docs/account_start_primary_email_update/](https://www.paws-r-sdk.com/docs/account_start_primary_email_update/) for full documentation.
#'
#' @param AccountId &#91;required&#93; Specifies the 12-digit account ID number of the Amazon Web Services
#' account that you want to access or modify with this operation. To use
#' this parameter, the caller must be an identity in the [organization's
#' management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' or a delegated administrator account. The specified account ID must be a
#' member account in the same organization. The organization must have [all
#' features
#' enabled](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html),
#' and the organization must have [trusted
#' access](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' enabled for the Account Management service, and optionally a [delegated
#' admin](https://docs.aws.amazon.com/organizations/latest/userguide/)
#' account assigned.
#' 
#' This operation can only be called from the management account or the
#' delegated administrator account of an organization for a member account.
#' 
#' The management account can't specify its own `AccountId`.
#' @param PrimaryEmail &#91;required&#93; The new primary email address (also known as the root user email
#' address) to use in the specified account.
#'
#' @keywords internal
#'
#' @rdname account_start_primary_email_update
account_start_primary_email_update <- function(AccountId, PrimaryEmail) {
  op <- new_operation(
    name = "StartPrimaryEmailUpdate",
    http_method = "POST",
    http_path = "/startPrimaryEmailUpdate",
    host_prefix = "",
    paginator = list()
  )
  input <- .account$start_primary_email_update_input(AccountId = AccountId, PrimaryEmail = PrimaryEmail)
  output <- .account$start_primary_email_update_output()
  config <- get_config()
  svc <- .account$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.account$operations$start_primary_email_update <- account_start_primary_email_update
