% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhLoglikehood.r
\name{lik.fn}
\alias{lik.fn}
\title{Penetrance Function}
\usage{
lik.fn(
  i,
  data,
  alpha_male,
  alpha_female,
  beta_male,
  beta_female,
  delta_male,
  delta_female,
  gamma_male,
  gamma_female,
  max_age,
  baselineRisk,
  BaselineNC,
  prev
)
}
\arguments{
\item{i}{Integer, index of the individual in the data set.}

\item{data}{Data frame, containing individual demographic and genetic information. Must include columns for 'sex', 'age', 'aff' (affection status), and 'geno' (genotype).}

\item{alpha_male}{Numeric, Weibull distribution shape parameter for males.}

\item{alpha_female}{Numeric, Weibull distribution shape parameter for females.}

\item{beta_male}{Numeric, Weibull distribution scale parameter for males.}

\item{beta_female}{Numeric, Weibull distribution scale parameter for females.}

\item{delta_male}{Numeric, shift parameter for the Weibull function for males.}

\item{delta_female}{Numeric, shift parameter for the Weibull function for females.}

\item{gamma_male}{Numeric, asymptote parameter for males (only scales the entire distribution).}

\item{gamma_female}{Numeric, asymptote parameter for females (only scales the entire distribution).}

\item{max_age}{Integer, maximum age considered in the analysis.}

\item{baselineRisk}{Numeric matrix, baseline risk for each age by sex. Rows correspond to sex (1 for male, 2 for female) and columns to age.}

\item{BaselineNC}{Logical, indicates if non-carrier penetrance should be based on SEER data.}

\item{prev}{Numeric, prevalence of the risk allele in the population.}
}
\value{
Numeric vector, containing penetrance values for unaffected and affected individuals.
}
\description{
Calculates the penetrance for an individual based on Weibull distribution parameters.
This function estimates the probability of developing cancer given the individual's genetic and demographic information.
}
