% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{remove_peripheral_compartment}
\alias{remove_peripheral_compartment}
\title{remove_peripheral_compartment}
\usage{
remove_peripheral_compartment(model, name = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{name}{(str) Name of compartment to remove peripheral compartment from.}
}
\value{
(Model) Pharmpy model object
}
\description{
Remove a peripheral distribution compartment from model

If name is set, a peripheral compartment will be removed from the compartment
with the specified name.

Initial estimates:

==  ===================================================
n
==  ===================================================
2   (equation could not be rendered, see API doc on website)
3   (equation could not be rendered, see API doc on website)
==  ===================================================
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- set_peripheral_compartments(model, 2)
model <- remove_peripheral_compartment(model)
model$statements$ode_system
}
}
\seealso{
set_peripheral_compartment

add_peripheral_compartment
}
