% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenololine.R
\name{phenololine}
\alias{phenololine}
\title{Return time-series curve given the time-series model and parameter values}
\usage{
phenololine(param, x, method)
}
\arguments{
\item{param}{Vector of model parameter values.}

\item{x}{Vector of time (e.g. vector of dates).}

\item{method}{Character name of the time-series model. At present, only "logisLateDicr" is accepted.}
}
\value{
phenololine function returns the trait values given x.
}
\description{
phenololine function returns the predicted values given the
model name and model parameters.
}
\details{
If method = "logisLateDicr", param should be the vector of c(K, d0, r, a, d1).
}
\examples{
library(phenolocrop)
y <- riceCH_eg |>
   logisLateDicr("x", "height") |>
   phenololine(x = 1:160, method = "logisLateDicr")
plot(1:160, y, type = "l")

}
