% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.r
\name{wl_range}
\alias{wl_range}
\alias{range}
\alias{range.waveband}
\alias{range.generic_spct}
\alias{range.generic_mspct}
\title{Wavelength range}
\usage{
wl_range(x, na.rm = FALSE)

\method{range}{waveband}(..., na.rm = FALSE)

\method{range}{generic_spct}(..., na.rm = FALSE)

\method{range}{generic_mspct}(..., na.rm = FALSE, idx = "spct.idx")
}
\arguments{
\item{x}{generic_spct, generic_mspct or waveband object.}

\item{na.rm}{ignored}

\item{...}{a single R object}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
a length-two vector for individual objects or numeric vectors
  or a data frame for collections of spectra.
}
\description{
A method specialization that returns the wavelength range [\eqn{nm}] from
objects of classes \code{waveband} or of class \code{generic_spct} or
derived.
}
\section{Methods (by class)}{
\itemize{
\item \code{range(generic_spct)}: 

\item \code{range(generic_mspct)}: 

}}
\examples{
range(sun.spct)
wl_range(sun.spct)

range(sun.spct)

}
\seealso{
Other wavelength summaries: 
\code{\link{wl_midpoint}()},
\code{\link{wl_min}()},
\code{\link{wl_stepsize}()}
}
\concept{wavelength summaries}
