% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cieillum.data.r
\docType{data}
\name{A.illuminant.spct}
\alias{A.illuminant.spct}
\title{CIE A illuminant data}
\format{
A source spectrum with 531 rows and 2 variables.

\itemize{ \item w.length (nm) \item s.e.irrad (rel. units) }
}
\usage{
A.illuminant.spct
}
\description{
A dataset containing wavelengths at a 5 nm interval (300 nm to
  830 nm) and the corresponding spectral energy irradiance normalized to 1 at
  560 nm. Spectrum approximates typical, domestic, tungsten-filament lighting
  and 'corresponds' to a black body a 2856 K. CIE standard illuminant A is
  intended to represent typical, domestic, tungsten-filament lighting.
  Original data from CIE downloaded on 2024-11-30.
}
\note{
This and other CIE illuminant spectra can be downloaded from
  \url{https://cie.co.at/data-tables} as .CSV files.
}
\examples{
A.illuminant.spct

}
\references{
CIE 2018, CIE standard illuminant A - 1 nm, International
Commission on Illumination (CIE), Vienna, Austria,
\doi{10.25039/CIE.DS.8jsxjrsn}.
}
\seealso{
Other Spectral data examples: 
\code{\link{D50.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun.spct}},
\code{\link{sun_daily.spct}},
\code{\link{sun_evening.spct}},
\code{\link{two_filters.spct}},
\code{\link{water.spct}},
\code{\link{white_led.source_spct}}
}
\author{
CIE
}
\concept{Spectral data examples}
\keyword{datasets}
