% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.data.r
\docType{data}
\name{sun.spct}
\alias{sun.spct}
\alias{sun.data}
\title{Solar spectral irradiance (simulated)}
\format{
A \code{source_spct} object and a \code{data.frame}, each with 511
rows and 3 variables

An object of class \code{data.frame} with 508 rows and 3 columns.
}
\usage{
sun.spct

sun.data
}
\description{
A dataset containing the wavelengths at a 1 nm interval and the
  corresponding spectral (energy) irradiance and spectral photon irradiance.
  Values simulated for 22 June 2010, near midday, at Helsinki, under partly
  cloudy conditions. The variables are as follows:
}
\details{
\itemize{ \item w.length (nm), range 293 to 800 nm. \item s.e.irrad
(W m-2 nm-1) \item s.q.irrad (mol m-2 nm-1) }
}
\note{
Package 'photobiologySun' contains data sets for the daylight spectrum
  under different conditions in and outside vegetation, stored in objects of
  these same classes, ready to be used with package 'photobiology'.
}
\examples{
sun.spct
summary(sun.spct)

}
\references{
Lindfors, A.; Heikkilä, A.; Kaurola, J.; Koskela, T. & Lakkala,
K. (2009) Reconstruction of Solar Spectral Surface UV Irradiances Using
Radiative Transfer Simulations. Photochemistry and Photobiology, 85:
1233-1239
}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D50.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun_daily.spct}},
\code{\link{sun_evening.spct}},
\code{\link{two_filters.spct}},
\code{\link{water.spct}},
\code{\link{white_led.source_spct}}
}
\author{
Anders K. Lindfors (data)
}
\concept{Spectral data examples}
\keyword{datasets}
