% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fraunhofer.r
\name{diffraction_single_slit}
\alias{diffraction_single_slit}
\alias{diffraction_double_slit}
\title{Diffraction}
\usage{
diffraction_single_slit(w.length, slit.width, angle)

diffraction_double_slit(w.length, slit.width, slit.distance, angle)
}
\arguments{
\item{w.length}{numeric Wavelength (nm).}

\item{slit.width}{numeric Width of the slit (m).}

\item{angle}{numeric vector Angle (radians).}

\item{slit.distance}{numeric Distance between the centres of the two slits
(m).}
}
\value{
A numeric vector of the same length as \code{angle}, containing
  relative intensities.
}
\description{
Diffraction of optical radiation passing through a single slit can
be computed with function \code{diffraction_single_slit()}, which
implements Fraunhofer's equation. Diffraction plus interference for a
pair of slits can be computed with \code{diffraction_double_slit()}.
}
\examples{
diffraction_single_slit(w.length = 550,
                             slit.width = 1e-5,
                             angle = 0)

# use odd number for length.out so that 0 is in the sequence
angles <- pi * seq(from = -1/2, to = 1/2, length.out = 501)

plot(angles,
     diffraction_single_slit(w.length = 550, # 550 nm
                             slit.width = 6e-6, # 6 um
                             angle = angles),
     type = "l",
     ylab = "Relative irradiance (/1)",
     xlab = "Angle (radian)")

plot(angles,
     diffraction_double_slit(w.length = 550, # 550 nm
                             slit.width = 6e-6, # 6 um
                             slit.distance = 18e-6, # 18 um
                             angle = angles),
     type = "l",
     ylab = "Relative irradiance (/1)",
     xlab = "Angle (radian)")

}
