% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.median.r
\name{s_median}
\alias{s_median}
\alias{s_median.default}
\alias{s_median.generic_spct}
\alias{s_median.source_mspct}
\alias{s_median.response_mspct}
\alias{s_median.filter_mspct}
\alias{s_median.reflector_mspct}
\alias{s_median.calibration_mspct}
\alias{s_median.cps_mspct}
\alias{s_median.raw_mspct}
\title{Median of a collection of spectra}
\usage{
s_median(x, na.rm, ...)

\method{s_median}{default}(x, na.rm = FALSE, ...)

\method{s_median}{generic_spct}(x, na.rm = FALSE, ...)

\method{s_median}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_median}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_median}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_median}{reflector_mspct}(x, na.rm = FALSE, ...)

\method{s_median}{calibration_mspct}(x, na.rm = FALSE, ...)

\method{s_median}{cps_mspct}(x, na.rm = FALSE, ...)

\method{s_median}{raw_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections
of spectral objects.}

\item{na.rm}{logical. A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  \code{"filter_mspct"} object, the returned object is of same class as the
  members of the collection, such as \code{"filter_spct"}, containing the
  summary spectrum, with variables with names tagged for summaries other
  than mean or median.
}
\description{
Method to compute the "parallel" median of values across members of a
collection of spectra or of a spectral object containing multiple spectra in
long form.
}
\details{
Method specializations compute the median at each wavelength across
  a group of spectra stored in an object of one of the classes defined in
  package 'photobiology'. Omission of NAs is done
  separately at each wavelength. Interpolation is not applied, so all spectra
  in \code{x} must share the same set of wavelengths. An error is triggered
  if this condition is nor fulfilled.
}
\section{Methods (by class)}{
\itemize{
\item \code{s_median(default)}: 

\item \code{s_median(generic_spct)}: 

\item \code{s_median(source_mspct)}: 

\item \code{s_median(response_mspct)}: 

\item \code{s_median(filter_mspct)}: 

\item \code{s_median(reflector_mspct)}: 

\item \code{s_median(calibration_mspct)}: 

\item \code{s_median(cps_mspct)}: 

\item \code{s_median(raw_mspct)}: 

}}
\note{
Objects of classes \code{raw_spct} and \code{cps_spct} can contain data
  from multiple scans in multiple variables or "columns". The methods accept
  as arguments objects of these classes only if spectra contain data for a
  single spectrometer scan. In the case of \code{cps_spct} objects, a single
  column can also contain data from multiple scans spliced into a single
  variable.
}
\examples{
s_median(sun_evening.mspct)

}
\seealso{
See \code{\link[stats]{median}} for the \code{median()} method used
  for the computations.
}
