% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plant-qq-ratios.r
\name{R_FR}
\alias{R_FR}
\title{Calculate R:FR photon ratio from spectral irradiance.}
\usage{
R_FR(spct, std = "Smith10", use.cached.mult = FALSE, use.hinges = TRUE)
}
\arguments{
\item{spct}{an object of class "source.spct".}

\item{std}{select which definition of red and far-red should be used,
defaults to "Smith".}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls.}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors.}
}
\value{
a single numeric dimensionless value giving the R:FR photon ratio,
  with name attribute set to the name of the wavebands, with "(q:q)"
  appended.
}
\description{
This function returns the red:far-red photon ratio of a light source
spectrum.
}
\examples{
R_FR(sun.spct)

}
\seealso{
\code{\link[photobiologyWavebands]{Red}},
  \code{\link[photobiologyWavebands]{Far_red}} and
  \code{\link[photobiology]{q_ratio}}.
}
