% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rast.pd.ses.R
\name{rast.pd}
\alias{rast.pd}
\title{Calculate phylogenetic diversity for raster data}
\usage{
rast.pd(x, tree, edge.path, branch.length, filename = "", ...)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) will be sorted according to the
tree order. See the phylo.pres function.}

\item{tree}{phylo. A dated tree.}

\item{edge.path}{matrix representing the paths through the tree from root
to each tip. See \code{\link{phylo.pres}}}

\item{branch.length}{numeric. A Named numeric vector of branch length for
each species. See \code{\link{phylo.pres}}}

\item{filename}{character. Output filename}

\item{...}{additional arguments passed for terra::app}
}
\value{
SpatRaster
}
\description{
Calculate the sum of the branch length for species present in
each cell of the raster.
}
\examples{
\donttest{
library(terra)
library(phyloraster)
x <- rast(system.file("extdata", "rast.presab.tif",
package="phyloraster"))
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package="phyloraster"))
data <- phylo.pres(x[[1:3]], tree)
pd <- rast.pd(data$x, edge.path = data$edge.path,
branch.length = data$branch.length)
plot(pd)
}
}
\references{
Faith, D. P. (1992). Conservation evaluation and
phylogenetic diversity. Biological conservation, 61(1), 1-10.
}
\author{
Neander Marcel Heming and Gabriela Alves-Ferreira
}
