% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{allele_diff_indices_parallel2}
\alias{allele_diff_indices_parallel2}
\title{Calculate SNPs or their count for each germline-input sequence pair with optional parallel execution.}
\usage{
allele_diff_indices_parallel2(
  germs,
  inputs,
  X = 0L,
  parallel = FALSE,
  return_count = FALSE,
  non_mismatch_chars_nullable = NULL
)
}
\arguments{
\item{germs}{A vector of strings representing germline sequences.}

\item{inputs}{A vector of strings representing input sequences.}

\item{X}{The threshold index from which to return SNP indices or counts (default: 0).}

\item{parallel}{A boolean flag to enable parallel processing (default: FALSE).}

\item{return_count}{A boolean flag to return the count of mutations instead of their indices (default: FALSE).}

\item{non_mismatch_chars_nullable}{A set of characters that are ignored when comparing sequences (default: 'N', '.', '-').}
}
\value{
A list of integer vectors (if \code{return_count = FALSE}) or a vector of integers (if \code{return_count = TRUE}).
}
\description{
This function compares germline sequences (\code{germs}) and input sequences (\code{inputs})
and identifies single nucleotide polymorphisms (SNPs) or their counts, with optional parallel execution.
The comparison ignores specified non-mismatch characters (e.g., gaps or ambiguous bases).
}
\examples{
# Example usage
germs <- c("ATCG", "ATCC")
inputs <- c("ATTG", "ATTA")
X <- 0

# Return indices of SNPs
result_indices <- allele_diff_indices_parallel2(germs, inputs, X, 
parallel = TRUE, return_count = FALSE)
print(result_indices)  # list(c(4), c(3, 4))

# Return counts of SNPs
result_counts <- allele_diff_indices_parallel2(germs, inputs, X, 
parallel = FALSE, return_count = TRUE)
print(result_counts)  # c(1, 2)

}
