% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pii.R
\name{pii}
\alias{pii}
\title{Predictive Information Index (PII)}
\usage{
pii(y, score_pred, full_pred = NULL, type = c("r2", "rm", "v"))
}
\arguments{
\item{y}{Observed outcome vector.}

\item{score_pred}{Predictions from score-based model.}

\item{full_pred}{Predictions from the full model.}

\item{type}{Character. One of "r2", "rm", or "v".}
}
\value{
A numeric value between 0 and 1.
}
\description{
Computes the Predictive Information Index using one of three methods:
"r2" (R-squared ratio), "rm" (RMSE-based), or "v" (variance ratio).
}
\examples{
set.seed(1)
y     <- rnorm(100)
full  <- y + rnorm(100, sd = 0.3)
score <- y + rnorm(100, sd = 0.5)
pii(y, score, full, type = "r2")
pii(y, score, full, type = "rm")
pii(y, score, full, type = "v")
}
