% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_plate.R
\name{read_plate}
\alias{read_plate}
\title{Read a plater-formatted file and turn it into a tidy data frame.}
\usage{
read_plate(file, well_ids_column = "Wells", sep = ",")
}
\arguments{
\item{file}{The path of a .csv file formatted as described below.}

\item{well_ids_column}{The name to give the column that will contain the well
identifiers. Default "Wells".}

\item{sep}{The character used to separate columns in the file (e.g. "," or ";"). 
Defaults to ",".}
}
\value{
Returns a data frame with each well as a row. One column will be 
named with \code{well_ids_column} and contain the well names (A01, A02..). 
There will be as many additional columns as layouts in \code{file}. Empty 
wells are omitted.
}
\description{
Converts data from \code{plater} format to a data frame with one well 
per row identified by well name.
}
\section{\code{plater} format}{

The .csv file should be formatted as a microtiter plate. The top-left most 
cell contains the name to use for the column representing that plate. For 
example, for a 96-well plate, the subsequent wells in the top row should be 
labeled 1-12. The subsequent cells in the first column should be labeled A-H. 
That is:

\tabular{ccccc}{
ColName      \tab \strong{1} \tab \strong{2} \tab \strong{3} \tab \strong{...}\cr
\strong{A}   \tab A01        \tab A02        \tab A03        \tab ... \cr
\strong{B}   \tab B01        \tab B02        \tab B03        \tab ... \cr
\strong{...} \tab ...        \tab ...        \tab ...        \tab ... \cr
}

In this example, the cells within the plate contain the well IDs ("A01", 
"A02"), but they may contain arbitrary characters: numbers, letters, or 
punctuation. Any cell may also be blank.

Note that Microsoft Excel will sometimes include cells that appear to be 
blank in the .csv files it produces, so the files may have spurious columns
or rows outside of the plate, causing errors. To solve this problem, copy and
paste just the cells within the plate to a fresh worksheet and save it.
}

\section{Multiple columns}{
 
Multiple columns of information about a plate can be included in a single 
file. After the first plate, leave one row blank, and then add another plate
formatted as described above. (The "blank" row should appear as blank in a 
spreadsheet editor, but as a row of commas when viewed as plain text.) As 
many plates as necessary can be included in a single file (e.g. data 
measured, subject, treatment, replicate, etc.).
}

\examples{
file_path <- system.file("extdata", "example-1.csv", package = "plater")

# Data are stored in plate-shaped form
data <- read_plate(
   file = file_path,
   well_ids_column = "Wells")

# Now data are tidy
head(data)
}
