% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcli_wrappers.r
\name{plotcli_box}
\alias{plotcli_box}
\title{Box plot using plotcli}
\usage{
plotcli_box(
  y,
  plot_width = getOption("plotcli.plot_width", 80),
  plot_height = getOption("plotcli.plot_height", 40),
  x_label = "x",
  y_label = "y",
  color = NULL,
  braille = getOption("plotcli.braille", TRUE),
  name = "boxplot",
  ...
)
}
\arguments{
\item{y}{A list of numeric vectors of values}

\item{plot_width}{Width of the plot (default: 80)}

\item{plot_height}{Height of the plot (default: 40)}

\item{x_label}{Label for the x-axis (default: "x")}

\item{y_label}{Label for the y-axis (default: "y")}

\item{color}{Color of the plot elements (default: NULL)}

\item{braille}{Use Braille characters for the plot (default: TRUE)}

\item{name}{Name of the plot element (default: "boxplot")}

\item{...}{Additional arguments passed to the plotcli$new() function}

\item{x}{A vector of categories}
}
\description{
Create a box plot using plotcli. Short alias: \code{pclbx}.
}
\examples{
y <- rnorm(50, mean = 0)
plotcli_box(y)
}
