% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.R
\name{SplitBarPlotAtomic}
\alias{SplitBarPlotAtomic}
\title{SplitBarPlotAtomic}
\usage{
SplitBarPlotAtomic(
  data,
  x,
  y,
  y_sep = "_",
  flip = FALSE,
  alpha_by = NULL,
  alpha_reverse = FALSE,
  alpha_name = NULL,
  order_y = list(`+` = c("x_desc", "alpha_desc"), `-` = c("x_desc", "alpha_asc")),
  bar_height = 0.9,
  lineheight = 0.5,
  max_charwidth = 80,
  fill_by = NULL,
  fill_by_sep = "_",
  fill_name = NULL,
  direction_pos_name = "positive",
  direction_neg_name = "negative",
  theme = "theme_this",
  theme_args = list(),
  palette = "Spectral",
  palcolor = NULL,
  facet_by = NULL,
  facet_scales = "free_y",
  facet_nrow = NULL,
  facet_ncol = NULL,
  facet_byrow = TRUE,
  aspect.ratio = 1,
  x_min = NULL,
  x_max = NULL,
  legend.position = "right",
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  keep_empty = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{The column name of the terms on the x axis. There should be both negative and positive values.}

\item{y}{The column name(s) of the values. If there are multiple columns, they will be concatenated.}

\item{y_sep}{A character string to concatenate the x columns if there are multiple.}

\item{flip}{A logical value indicating whether to flip the x and y axes.}

\item{alpha_by}{A character string indicating the column name to use for the transparency of the bars.}

\item{alpha_reverse}{A logical value indicating whether to reverse the transparency.}

\item{alpha_name}{A character string indicating the legend name of the transparency.}

\item{order_y}{A list of character strings indicating the order of the y axis.
The keys are "+", "-", or "\emph{". However, "+/-" should not be mixed with "}".
The values are "x_asc", "x_desc", "alpha_asc", or "alpha_desc", indicating how to order the y axis.
The default is \code{list("+" = c("x_desc", "alpha_desc"), "-" = c("x_desc", "alpha_asc"))}, meaning
the positive values are ordered by the x-axis values in descending order and the alpha values in descending order,
and the negative values are ordered by the x-axis values in descending order and the alpha values in ascending order.
The "*" key is used to order the y axis without considering the direction.}

\item{bar_height}{A numeric value indicating the height of the bars.}

\item{lineheight}{A numeric value indicating the height of the text.}

\item{max_charwidth}{A numeric value indicating the maximum width of the text.}

\item{fill_by}{A character string indicating the column name to use for the fill of the bars.}

\item{fill_by_sep}{A character string to concatenate the fill columns if there are multiple.}

\item{fill_name}{A character string indicating the legend name of the fill.}

\item{direction_pos_name}{A character string indicating the name of the positive direction.}

\item{direction_neg_name}{A character string indicating the name of the negative direction.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.}

\item{palcolor}{A character string specifying the color to use in the palette.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{x_min}{A numeric value indicating the minimum value of the x axis.}

\item{x_max}{A numeric value indicating the maximum value of the x axis.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{keep_empty}{A logical value indicating whether to keep empty groups.
If FALSE, empty groups will be removed.}

\item{...}{Additional arguments.}
}
\description{
Create a split bar plot without splitting the data.
}
\keyword{internal}
