% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_objects.R
\name{run_kurtosis}
\alias{run_kurtosis}
\title{Calculate the Kurtosis of Sample Runs}
\usage{
run_kurtosis(data_only)
}
\arguments{
\item{data_only}{a \eqn{p \times n} data.frame, where \eqn{p} is the number
of peptides and \eqn{n} is the number of samples.}
}
\value{
data.frame with two elements: Sample, a character vector giving the
  sample names; and Kurtosis, a numeric vector giving the kurtosis
}
\description{
This function calculates the kurtosis across data for each sample run.
}
\details{
Kurtosis is calculated by method 2 in the \code{e1071} package,
  which is unbiased under normality. Within a sample NA values are ignorned
  in the kurtosis calculation. If all peptide abundance values are missing
  within a sample, the kurtosis is replaced by the overall mean of nonmissing
  kurtosis values for the data.
}
\author{
Lisa Bramer
}
