% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmlb.R
\name{graceful_download}
\alias{graceful_download}
\title{Download a File Gracefully with Retry Mechanism}
\usage{
graceful_download(url, destfile, retries = 3)
}
\arguments{
\item{url}{Character. The URL of the file to download.}

\item{destfile}{Character. The path to the destination file where the downloaded content will be saved.}

\item{retries}{Integer. The maximum number of download attempts (default is 3).}
}
\value{
Logical. Returns `TRUE` if the download succeeds, `FALSE` otherwise.
}
\description{
Attempts to download a file from a specified URL, retrying a set number of times if the download fails.
This function meets CRAN's requirement for gracefully handling the use of internet resources by
catching errors and returning a warning message if the download ultimately fails.
}
\examples{
\dontrun{
dataset_url <- "https://example.com/dataset.csv"
tmp <- tempfile(fileext = ".csv")
success <- download_file_gracefully(dataset_url, tmp)
if (!success) {
  message("Continuing gracefully without the dataset.")
}
}
}
