% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{dinit}
\alias{dinit}
\alias{dinit,ANY-method}
\alias{dinit,missing-method}
\alias{dinit,pomp-method}
\title{dinit workhorse}
\usage{
\S4method{dinit}{pomp}(
  object,
  ...,
  params = coef(object),
  t0 = timezero(object),
  x,
  log = FALSE
)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{...}{additional arguments are ignored.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{t0}{the initial time, i.e., the time corresponding to the initial-state distribution.}

\item{x}{an array containing states of the unobserved process.
The dimensions of \code{x} are \code{nvars} x \code{nrep} x \code{ntimes},
where \code{nvars} is the number of state variables,
\code{nrep} is the number of replicates,
and \code{ntimes} is the length of \code{times}.
One can also pass \code{x} as a named numeric vector, which is equivalent to the \code{nrep=1}, \code{ntimes=1} case.}

\item{log}{if TRUE, log probabilities are returned.}
}
\value{
\code{dinit} returns a 1-D numerical array containing the likelihoods (or log likelihoods if \code{log=TRUE}).
By default, \code{t0} is the initial time defined when the \sQuote{pomp} object ws constructed.
}
\description{
Evaluates the initial-state density.
}
\seealso{
Specification of the initial-state distribution: \link{dinit_spec}

More on \pkg{pomp} workhorse functions: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{vmeasure}()},
\code{\link{workhorses}}
}
\concept{extending the pomp package}
\concept{low-level interface}
\concept{pomp workhorses}
