% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pop_Gen_Functions.R
\name{BootStrap3}
\alias{BootStrap3}
\title{Perform Bootstrap Analysis}
\usage{
BootStrap3(A = data.frame, Rep = 20, Stat = 1)
}
\arguments{
\item{A}{Data frame containing data as read in by \link{LoadData}}

\item{Rep}{Number of bootstrap replicates.}

\item{Stat}{Type of statistic to compute (1 for AlRich, 2 for TwoLevelGST)}
}
\value{
Either a matrix of AlRich statistics or a list containing various
statistics computed using TwoLevelGST.
}
\description{
This function performs bootstrap analysis on genetic data.
}
\examples{
genetic_data <- data.frame(
Locus = c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2),
Locus_allele = c("Marker1", "n", 1, 2, 3, "Marker2", "n", 1, 2, 3),
Sample1 = c(NA, 10, 0.5, 0.5, 0, NA, 10, 0.2, 0.3, 0.5),
Sample2 = c(NA, 20, 0.1, 0.2, 0.7, NA, 20, 0.3, 0.4, 0.3),
Sample3 = c(NA, 30, 0.3, 0.4, 0.3, NA, 30, 0.4, 0.2, 0.4)
)

BootStrap3(A=genetic_data, Rep=10, Stat=1)
BootStrap3(A=genetic_data, Rep=10, Stat=2)
}
