% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_Q2}
\alias{compute_Q2}
\alias{.compute_Q2}
\title{compute_Q2}
\usage{
.compute_Q2(refcount, totcount, nblocks, block_id, verbose)
}
\arguments{
\item{refcount}{Matrix of nsnpxnpop with counts (genotype or reads) for the reference allele}

\item{totcount}{Matrix of nsnpxnpop with total counts or read coverages}

\item{nblocks}{Integer giving the number of block-jackknife blocs (may be 0 if no block-jackknife)}

\item{block_id}{Integer vector of length nsnps with the (0-indexed) id of the block to which each SNP belongs (-1 for SNPs outside blocks)}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return a matrix with npops*(npops-1)/2 and nblocks+1 column giving the mean Q2 of each pairwise pop comp. within each block and for all SNPs (last column)
}
\description{
Compute all Q2 for each block-jackknife block (if any) and overall SNPs (within or outside blocks)
}
\details{
Compute all Q2 for each block-jackknife block (if any) and overall SNPs (within or outside blocks).
}
\examples{
#
}
