% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{interpolate.XY}
\alias{interpolate.XY}
\title{Interpolate an \code{XY} object onto a given 2theta scale.}
\usage{
\method{interpolate}{XY}(x, new_tth, ...)
}
\arguments{
\item{x}{an \code{XY} object.}

\item{new_tth}{a numeric vector of the new 2theta scale.}

\item{...}{other arguments}
}
\value{
an \code{XY} object.
}
\description{
\code{interpolate} takes an \code{XY} object and interpolates the
data onto a new 2theta scale using a cubic spline.
}
\examples{
data(rockjock_mixtures)

#Define a new 2theta scale:
tth <- seq(10, 60, 0.04)

#interpolate data onto new scale
i1 <- interpolate(rockjock_mixtures$Mix1, new_tth = tth)
}
