% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-power.R
\name{plot_power_contour}
\alias{plot_power_contour}
\title{Plot Bayesian Power / Assurance Contour (Multi-Effect Grid Friendly)}
\usage{
plot_power_contour(
  power_results,
  power_metric = c("direction", "threshold", "rope"),
  x_effect = NULL,
  y_effect = "n",
  facet_by = NULL,
  power_threshold = 0.8,
  show_threshold_line = TRUE,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results}{Output from a \code{brms_inla_power} function.}

\item{power_metric}{Which metric to plot: \code{"direction"}, \code{"threshold"}, or \code{"rope"}.}

\item{x_effect}{Name of effect grid column for x-axis (default = first effect).}

\item{y_effect}{Name of effect grid column for y-axis (default = "n").}

\item{facet_by}{Optional effect grid column(s) to facet by.}

\item{power_threshold}{Optional contour line for assurance (default 0.8).}

\item{show_threshold_line}{Logical; add a red contour at \code{power_threshold}.}

\item{title, subtitle}{Optional plot labels.}
}
\value{
A ggplot object.
}
\description{
Draw a filled contour plot of assurance for a chosen metric,
as a function of two effect grid columns and sample size.
}
