% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.test.equiv.R
\name{prop.test.equiv}
\alias{prop.test.equiv}
\title{Power calculation for test of equivalence of two proportions}
\usage{
prop.test.equiv(
  n1 = NULL,
  n.ratio = 1,
  p1 = NULL,
  p2 = NULL,
  margin = NULL,
  alpha = 0.05,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{n1}{The sample size for group 1.}

\item{n.ratio}{The ratio n2/n1 between the sample sizes of two groups; defaults to 1 (equal group sizes).}

\item{p1}{The outcome proportion in group 1.}

\item{p2}{The outcome proportion in group 2.}

\item{margin}{The equivalence margin.}

\item{alpha}{The significance level or type 1 error rate; defaults to 0.05.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs power and sample size calculations for a test of equivalence for two
proportions. Can solve for power, n1, n.ratio or alpha.
}
\examples{
prop.test.equiv(n1 = NULL, p1 = 0.5, p2 = 0.5, margin = 0.1, alpha = 0.05, power = 0.8)
}
