% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinatorics.R
\name{get.p}
\alias{get.p}
\title{Calculate the probability of missing a given population fraction}
\usage{
get.p(n, f = 0.05)
}
\arguments{
\item{n}{the number of grains in the detrital sample}

\item{f}{the size of the smallest resolvable fraction
(0<\code{f}<1)}
}
\value{
the probability that all \code{n} grains in the sample have
    missed at least one fraction of size \code{f}
}
\description{
For a given sample size, returns the likelihood of missing any
fraction greater than a given size
}
\examples{
print(get.p(60))
print(get.p(117))
}
\references{
Vermeesch,
    Pieter. "How many grains are needed for a provenance study?."
    Earth and Planetary Science Letters 224.3 (2004): 441-451.
}
