% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk.R
\name{ps_disk_io_counters}
\alias{ps_disk_io_counters}
\title{System-wide disk I/O counters}
\usage{
ps_disk_io_counters()
}
\value{
A data frame of one row per disk of I/O stats, with columns
\code{name}, \code{read_count} \code{read_merged_count} \code{read_bytes}, \code{read_time},
\code{write_count}, \code{write_merged_count}, \code{write_bytes} \code{write_time}, and
\code{busy_time}.
}
\description{
Returns a data.frame of system-wide disk I/O counters.
}
\details{
Includes the following non-NA fields for all supported platforms:
\itemize{
\item \code{read_count}: number of reads
\item \code{write_count}: number of writes
\item \code{read_bytes}: number of bytes read
\item \code{write_bytes}: number of bytes written
}

And for only some platforms:
\itemize{
\item \code{read_time}: time spent reading from disk (in milliseconds)
\item \code{write_time}: time spent writing to disk (in milliseconds)
\item \code{busy_time}: time spent doing actual I/Os (in milliseconds)
\item \code{read_merged_count}: number of merged reads (see iostats doc)
\item \code{write_merged_count}: number of merged writes (see iostats doc)
}
}
\examples{
\dontshow{if (ps:::ps_os_name() \%in\% c("LINUX", "WINDOWS") && !ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_disk_io_counters()
\dontshow{\}) # examplesIf}
}
\seealso{
Other disk functions: 
\code{\link{ps_disk_partitions}()},
\code{\link{ps_disk_usage}()}
}
\concept{disk functions}
