% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_main_function.R
\name{pvEBayes_tune}
\alias{pvEBayes_tune}
\title{Select hyperparameter and obtain the optimal general-gamma or efron model
based on AIC and BIC}
\usage{
pvEBayes_tune(
  contin_table,
  model = "general-gamma",
  alpha_vec = NULL,
  p_vec = NULL,
  c0_vec = NULL,
  use_AIC = TRUE,
  n_posterior_draws = 1000,
  return_all_fit = FALSE,
  return_all_AIC = TRUE,
  return_all_BIC = TRUE
)
}
\arguments{
\item{contin_table}{an IxJ contingency table showing pairwise counts of adverse
events for I AEs (along the rows) and J drugs (along the columns).}

\item{model}{the model to be tuned. Available models are "general-gamma" and
"efron". Default to "general-gamma".}

\item{alpha_vec}{vector of hyperparameter alpha values to be selected. Alpha
is a hyperparameter in general-gamma model which is numeric and between 0 and 1.
If is NULL, a default set of alpha values (0, 0.1, 0.3, 0.5, 0.7, 0.9) will
be used.}

\item{p_vec}{vector of hyperparameter p values to be selected. p is
a hyperparameter in "efron" model which should be a positive integer. If is NULL,
a default set of p values (80, 100, 120, 150, 200) will be used.}

\item{c0_vec}{vector of hyperparameter c0 values to be selected. c0 is
a hyperparameter in "efron" model which should be a positive number. If is NULL,
a default set of c0 values (0.001, 0.01, 0.1, 0.2, 0.5) will be used.}

\item{use_AIC}{logical, indicating whether AIC or BIC is used. Default to be
TRUE.}

\item{n_posterior_draws}{number of posterior draws for each AE-drug
combination.}

\item{return_all_fit}{logical, indicating whether to return all the fitted
model under the selection. Default to be FALSE.}

\item{return_all_AIC}{logical, indicating whether to return AIC values for
each fitted model under the selection. Default to be TRUE.}

\item{return_all_BIC}{logical, indicating whether to return BIC values for
each fitted model under the selection. Default to be TRUE.}
}
\value{
The function returns an S3 object of class \code{pvEBayes} containing the selected
estimated model parameters as well as posterior draws for each AE-drug
combination if the number of posterior draws is specified.
}
\description{
This function performs hyperparameter tuning for the general-gamma or Efron
model using AIC or BIC. For a given AE-drug contingency table, the
function fits a series of models across a grid of candidate hyperparameter values
and computes their AIC and BIC. The models with the lowest AIC or BIC values
are selected as the optimal fits.
}
\examples{

fit <- pvEBayes_tune(statin2025_44, model = "general-gamma")

}
\references{
Akaike H. A new look at the statistical model identification. \emph{IEEE Transactions on Automatic Control.}
2003; 19(6):716-23. \cr

Schwarz G. Estimating the dimension of a model. \emph{The Annals of Statistics.}
1978; 1:461-4.

Tan Y, Markatou M and Chakraborty S. Flexible Empirical Bayesian Approaches to
Pharmacovigilance for Simultaneous Signal Detection and Signal Strength Estimation
in Spontaneous Reporting Systems Data. \emph{arXiv preprint.} 2025; arXiv:2502.09816.
}
