% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svarirf.R
\name{irf.varx}
\alias{irf.varx}
\title{Impulse Response Functions}
\usage{
\method{irf}{varx}(x, ..., n.ahead = 20, normf = NULL)
}
\arguments{
\item{x}{VAR object of class '\code{varx}', '\code{id}', or any other 
that will be \link[=as.varx]{coerced} to '\code{varx}'.}

\item{...}{Currently not used.}

\item{n.ahead}{Integer. Number of periods to consider after the initial impulse, i.e. the horizon of the IRF.}

\item{normf}{Function. A given function that normalizes the \eqn{K \times S} input-matrix 
into an output matrix of same dimension. See the example in \code{\link{id.iv}} 
for the normalization of Jentsch and Lunsford (2021) 
that fixes the size of the impact response.}
}
\value{
A list of class '\code{svarirf}' holding the impulse response functions as a '\code{data.frame}'.
}
\description{
Calculates impulse response functions.
}
\examples{
data("PCIT")
names_k = c("APITR", "ACITR", "PITB", "CITB", "GOV", "RGDP", "DEBT")
names_l = c("m_PI", "m_CI")  # proxy names
names_s = paste0("epsilon[ ", c("PI", "CI"), " ]")  # shock names
dim_p   = 4  # lag-order

# estimate and identify proxy SVAR #
R.vars = vars::VAR(PCIT[ , names_k], p=dim_p, type="const")
R.idBL = id.iv(R.vars, iv=PCIT[-(1:dim_p), names_l], S2="MR", cov_u="OMEGA")
colnames(R.idBL$B) = names_s  # labeling

# calculate and plot normalized IRF #
R.norm = function(B) B / matrix(-diag(B), nrow(B), ncol(B), byrow=TRUE)
plot(irf(R.idBL, normf=R.norm))

}
\references{
Luetkepohl, H. (2005): 
  \emph{New Introduction to Multiple Time Series Analysis}, 
  Springer, 2nd ed.

Jentsch, C., and Lunsford, K. G. (2021):
  "Asymptotically Valid Bootstrap Inference for Proxy SVARs",
  \emph{Journal of Business and Economic Statistics}, 40, pp. 1876-1891.
}
