% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_helpers.R
\name{add_extension}
\alias{add_extension}
\title{Add Extensions to Variable Names}
\usage{
add_extension(data_frame, from, extensions, reuse = "none")
}
\arguments{
\item{data_frame}{The data frame in which variables should gain extensions to their name.}

\item{from}{The position of the variable inside the data frame at which to start the renaming.}

\item{extensions}{The extensions to add.}

\item{reuse}{"none" by default, meaning only the provided extensions will be set. E.g. if
there are two extensions provided, two variables will be renamed. If "last", the last provided
extension will be used for every following variable until the end of the data frame. If "repeat",
the provided extensions will be repeated from the first one for every following variable until
the end of the data frame.}
}
\value{
Returns a data frame with extended variable names.
}
\description{
Renames variables in a data frame by adding the desired extensions to the original names.
This can be useful if you want to use pre summarised data with \code{\link[=any_table]{any_table()}}, which needs
the value variables to have the statistic extensions.
}
\examples{
# Example data frame
my_data <- dummy_data(1000)

# Add extensions to variable names
new_names1 <- my_data |> add_extension(5, c("sum", "pct"))
new_names2 <- my_data |> add_extension(5, c("sum", "pct"), reuse = "last")
new_names3 <- my_data |> add_extension(5, c("sum", "pct"), reuse = "alternate")

}
