% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sample_locations.R
\name{get_sample_locations}
\alias{get_sample_locations}
\title{Get the well locations of the samples used in the RT-QuIC run.}
\usage{
get_sample_locations(
  file,
  tab_name = "Sample IDs",
  dilution_bool = FALSE,
  dilution_fun = function(x) 1 * x,
  sep = "\\n",
  plate = 96
)
}
\arguments{
\item{file}{Excel file exported from MARS}

\item{tab_name}{Table name containing the sample IDs.}

\item{dilution_bool}{Logical; is there a table containing dilution factors? If so, will add a newline and the log of the dilution factor to the ID column.}

\item{dilution_fun}{A function for transforming the dilution factor.}

\item{sep}{A string used to separate the sample ID and dilution factor.}

\item{plate}{Integer; either 96 or 384 to denote microplate type.}
}
\value{
A vector containing well IDs.
}
\description{
Returns a dataframe with the sample IDs and well IDs used in the plate.
}
\examples{
file <- system.file(
  "extdata/input_files",
  file = "test.xlsx",
  package = "quicR"
)
get_sample_locations(file)

}
