% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_check.R
\name{normalize_check}
\alias{normalize_check}
\title{Normalize Check Function for qstate Class Object}
\usage{
normalize_check(qstate_obj, probs = FALSE)
}
\arguments{
\item{qstate_obj}{A quantum state object.}

\item{probs}{Are probabilities required as output?}
}
\value{
Either the sum of the squared magnitudes of the coefficients of the qstate object or its probabilities.
}
\description{
Check the normalization of a qstate object created by qsimulatR package.
}
\examples{
library(qsimulatR)
ket0 <- qstate(nbits = 1) 
normalize_check(ket0)
}
